// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.networking.FloatingIpArgs;
import com.pulumi.openstack.networking.inputs.FloatingIpState;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * ## Import
 * 
 * Floating IPs can be imported using the `id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:networking/floatingIp:FloatingIp floatip_1 2c7f39f3-702b-48d1-940c-b50384177ee1
 * ```
 * 
 */
@ResourceType(type="openstack:networking/floatingIp:FloatingIp")
public class FloatingIp extends com.pulumi.resources.CustomResource {
    /**
     * The actual/specific floating IP to obtain. By default,
     * non-admin users are not able to specify a floating IP, so you must either be
     * an admin user or have had a custom policy or role applied to your OpenStack
     * user or project.
     * 
     */
    @Export(name="address", refs={String.class}, tree="[0]")
    private Output<String> address;

    /**
     * @return The actual/specific floating IP to obtain. By default,
     * non-admin users are not able to specify a floating IP, so you must either be
     * an admin user or have had a custom policy or role applied to your OpenStack
     * user or project.
     * 
     */
    public Output<String> address() {
        return this.address;
    }
    /**
     * The collection of tags assigned on the floating IP, which have
     * been explicitly and implicitly added.
     * 
     */
    @Export(name="allTags", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> allTags;

    /**
     * @return The collection of tags assigned on the floating IP, which have
     * been explicitly and implicitly added.
     * 
     */
    public Output<List<String>> allTags() {
        return this.allTags;
    }
    /**
     * Human-readable description for the floating IP.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Human-readable description for the floating IP.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The floating IP DNS domain. Available, when Neutron
     * DNS extension is enabled. The data in this attribute will be published in an
     * external DNS service when Neutron is configured to integrate with such a
     * service. Changing this creates a new floating IP.
     * 
     */
    @Export(name="dnsDomain", refs={String.class}, tree="[0]")
    private Output<String> dnsDomain;

    /**
     * @return The floating IP DNS domain. Available, when Neutron
     * DNS extension is enabled. The data in this attribute will be published in an
     * external DNS service when Neutron is configured to integrate with such a
     * service. Changing this creates a new floating IP.
     * 
     */
    public Output<String> dnsDomain() {
        return this.dnsDomain;
    }
    /**
     * The floating IP DNS name. Available, when Neutron DNS
     * extension is enabled. The data in this attribute will be published in an
     * external DNS service when Neutron is configured to integrate with such a
     * service. Changing this creates a new floating IP.
     * 
     */
    @Export(name="dnsName", refs={String.class}, tree="[0]")
    private Output<String> dnsName;

    /**
     * @return The floating IP DNS name. Available, when Neutron DNS
     * extension is enabled. The data in this attribute will be published in an
     * external DNS service when Neutron is configured to integrate with such a
     * service. Changing this creates a new floating IP.
     * 
     */
    public Output<String> dnsName() {
        return this.dnsName;
    }
    /**
     * Fixed IP of the port to associate with this floating IP. Required if
     * the port has multiple fixed IPs.
     * 
     */
    @Export(name="fixedIp", refs={String.class}, tree="[0]")
    private Output<String> fixedIp;

    /**
     * @return Fixed IP of the port to associate with this floating IP. Required if
     * the port has multiple fixed IPs.
     * 
     */
    public Output<String> fixedIp() {
        return this.fixedIp;
    }
    /**
     * The name of the pool from which to obtain the floating
     * IP. Changing this creates a new floating IP.
     * 
     */
    @Export(name="pool", refs={String.class}, tree="[0]")
    private Output<String> pool;

    /**
     * @return The name of the pool from which to obtain the floating
     * IP. Changing this creates a new floating IP.
     * 
     */
    public Output<String> pool() {
        return this.pool;
    }
    /**
     * ID of an existing port with at least one IP address to
     * associate with this floating IP.
     * 
     */
    @Export(name="portId", refs={String.class}, tree="[0]")
    private Output<String> portId;

    /**
     * @return ID of an existing port with at least one IP address to
     * associate with this floating IP.
     * 
     */
    public Output<String> portId() {
        return this.portId;
    }
    /**
     * The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a floating IP that can be used with
     * another networking resource, such as a load balancer. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * floating IP (which may or may not have a different address).
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a floating IP that can be used with
     * another networking resource, such as a load balancer. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * floating IP (which may or may not have a different address).
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * The subnet ID of the floating IP pool. Specify this if
     * the floating IP network has multiple subnets.
     * 
     */
    @Export(name="subnetId", refs={String.class}, tree="[0]")
    private Output<String> subnetId;

    /**
     * @return The subnet ID of the floating IP pool. Specify this if
     * the floating IP network has multiple subnets.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }
    /**
     * A list of external subnet IDs to try over each to
     * allocate a floating IP address. If a subnet ID in a list has exhausted
     * floating IP pool, the next subnet ID will be tried. This argument is used only
     * during the resource creation. Conflicts with a `subnet_id` argument.
     * 
     */
    @Export(name="subnetIds", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> subnetIds;

    /**
     * @return A list of external subnet IDs to try over each to
     * allocate a floating IP address. If a subnet ID in a list has exhausted
     * floating IP pool, the next subnet ID will be tried. This argument is used only
     * during the resource creation. Conflicts with a `subnet_id` argument.
     * 
     */
    public Output<Optional<List<String>>> subnetIds() {
        return Codegen.optional(this.subnetIds);
    }
    /**
     * A set of string tags for the floating IP.
     * 
     */
    @Export(name="tags", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tags;

    /**
     * @return A set of string tags for the floating IP.
     * 
     */
    public Output<Optional<List<String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * The target tenant ID in which to allocate the floating
     * IP, if you specify this together with a port_id, make sure the target port
     * belongs to the same tenant. Changing this creates a new floating IP (which
     * may or may not have a different address)
     * 
     */
    @Export(name="tenantId", refs={String.class}, tree="[0]")
    private Output<String> tenantId;

    /**
     * @return The target tenant ID in which to allocate the floating
     * IP, if you specify this together with a port_id, make sure the target port
     * belongs to the same tenant. Changing this creates a new floating IP (which
     * may or may not have a different address)
     * 
     */
    public Output<String> tenantId() {
        return this.tenantId;
    }
    /**
     * Map of additional options.
     * 
     */
    @Export(name="valueSpecs", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional options.
     * 
     */
    public Output<Optional<Map<String,Object>>> valueSpecs() {
        return Codegen.optional(this.valueSpecs);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public FloatingIp(String name) {
        this(name, FloatingIpArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public FloatingIp(String name, FloatingIpArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public FloatingIp(String name, FloatingIpArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/floatingIp:FloatingIp", name, args == null ? FloatingIpArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private FloatingIp(String name, Output<String> id, @Nullable FloatingIpState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/floatingIp:FloatingIp", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static FloatingIp get(String name, Output<String> id, @Nullable FloatingIpState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new FloatingIp(name, id, state, options);
    }
}
