// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.networking.FloatingIpAssociateArgs;
import com.pulumi.openstack.networking.inputs.FloatingIpAssociateState;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Associates a floating IP to a port. This is useful for situations
 * where you have a pre-allocated floating IP or are unable to use the
 * `openstack.networking.FloatingIp` resource to create a floating IP.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.Port;
 * import com.pulumi.openstack.networking.PortArgs;
 * import com.pulumi.openstack.networking.FloatingIpAssociate;
 * import com.pulumi.openstack.networking.FloatingIpAssociateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var port1 = new Port(&#34;port1&#34;, PortArgs.builder()        
 *             .networkId(&#34;a5bbd213-e1d3-49b6-aed1-9df60ea94b9a&#34;)
 *             .build());
 * 
 *         var fip1 = new FloatingIpAssociate(&#34;fip1&#34;, FloatingIpAssociateArgs.builder()        
 *             .floatingIp(&#34;1.2.3.4&#34;)
 *             .portId(port1.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Floating IP associations can be imported using the `id` of the floating IP, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:networking/floatingIpAssociate:FloatingIpAssociate fip 2c7f39f3-702b-48d1-940c-b50384177ee1
 * ```
 * 
 */
@ResourceType(type="openstack:networking/floatingIpAssociate:FloatingIpAssociate")
public class FloatingIpAssociate extends com.pulumi.resources.CustomResource {
    @Export(name="fixedIp", refs={String.class}, tree="[0]")
    private Output<String> fixedIp;

    public Output<String> fixedIp() {
        return this.fixedIp;
    }
    /**
     * IP Address of an existing floating IP.
     * 
     */
    @Export(name="floatingIp", refs={String.class}, tree="[0]")
    private Output<String> floatingIp;

    /**
     * @return IP Address of an existing floating IP.
     * 
     */
    public Output<String> floatingIp() {
        return this.floatingIp;
    }
    /**
     * ID of an existing port with at least one IP address to
     * associate with this floating IP.
     * 
     */
    @Export(name="portId", refs={String.class}, tree="[0]")
    private Output<String> portId;

    /**
     * @return ID of an existing port with at least one IP address to
     * associate with this floating IP.
     * 
     */
    public Output<String> portId() {
        return this.portId;
    }
    /**
     * The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a floating IP that can be used with
     * another networking resource, such as a load balancer. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * floating IP (which may or may not have a different address).
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a floating IP that can be used with
     * another networking resource, such as a load balancer. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * floating IP (which may or may not have a different address).
     * 
     */
    public Output<String> region() {
        return this.region;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public FloatingIpAssociate(String name) {
        this(name, FloatingIpAssociateArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public FloatingIpAssociate(String name, FloatingIpAssociateArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public FloatingIpAssociate(String name, FloatingIpAssociateArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/floatingIpAssociate:FloatingIpAssociate", name, args == null ? FloatingIpAssociateArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private FloatingIpAssociate(String name, Output<String> id, @Nullable FloatingIpAssociateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/floatingIpAssociate:FloatingIpAssociate", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static FloatingIpAssociate get(String name, Output<String> id, @Nullable FloatingIpAssociateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new FloatingIpAssociate(name, id, state, options);
    }
}
