// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.networking.NetworkArgs;
import com.pulumi.openstack.networking.inputs.NetworkState;
import com.pulumi.openstack.networking.outputs.NetworkSegment;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a V2 Neutron network resource within OpenStack.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.Network;
 * import com.pulumi.openstack.networking.NetworkArgs;
 * import com.pulumi.openstack.networking.Subnet;
 * import com.pulumi.openstack.networking.SubnetArgs;
 * import com.pulumi.openstack.compute.SecGroup;
 * import com.pulumi.openstack.compute.SecGroupArgs;
 * import com.pulumi.openstack.compute.inputs.SecGroupRuleArgs;
 * import com.pulumi.openstack.networking.Port;
 * import com.pulumi.openstack.networking.PortArgs;
 * import com.pulumi.openstack.networking.inputs.PortFixedIpArgs;
 * import com.pulumi.openstack.compute.Instance;
 * import com.pulumi.openstack.compute.InstanceArgs;
 * import com.pulumi.openstack.compute.inputs.InstanceNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var network1 = new Network(&#34;network1&#34;, NetworkArgs.builder()        
 *             .adminStateUp(&#34;true&#34;)
 *             .build());
 * 
 *         var subnet1 = new Subnet(&#34;subnet1&#34;, SubnetArgs.builder()        
 *             .networkId(network1.id())
 *             .cidr(&#34;192.168.199.0/24&#34;)
 *             .ipVersion(4)
 *             .build());
 * 
 *         var secgroup1 = new SecGroup(&#34;secgroup1&#34;, SecGroupArgs.builder()        
 *             .description(&#34;a security group&#34;)
 *             .rules(SecGroupRuleArgs.builder()
 *                 .fromPort(22)
 *                 .toPort(22)
 *                 .ipProtocol(&#34;tcp&#34;)
 *                 .cidr(&#34;0.0.0.0/0&#34;)
 *                 .build())
 *             .build());
 * 
 *         var port1 = new Port(&#34;port1&#34;, PortArgs.builder()        
 *             .networkId(network1.id())
 *             .adminStateUp(&#34;true&#34;)
 *             .securityGroupIds(secgroup1.id())
 *             .fixedIps(PortFixedIpArgs.builder()
 *                 .subnetId(subnet1.id())
 *                 .ipAddress(&#34;192.168.199.10&#34;)
 *                 .build())
 *             .build());
 * 
 *         var instance1 = new Instance(&#34;instance1&#34;, InstanceArgs.builder()        
 *             .securityGroups(secgroup1.name())
 *             .networks(InstanceNetworkArgs.builder()
 *                 .port(port1.id())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Networks can be imported using the `id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:networking/network:Network network_1 d90ce693-5ccf-4136-a0ed-152ce412b6b9
 * ```
 * 
 */
@ResourceType(type="openstack:networking/network:Network")
public class Network extends com.pulumi.resources.CustomResource {
    /**
     * The administrative state of the network.
     * Acceptable values are &#34;true&#34; and &#34;false&#34;. Changing this value updates the
     * state of the existing network.
     * 
     */
    @Export(name="adminStateUp", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> adminStateUp;

    /**
     * @return The administrative state of the network.
     * Acceptable values are &#34;true&#34; and &#34;false&#34;. Changing this value updates the
     * state of the existing network.
     * 
     */
    public Output<Boolean> adminStateUp() {
        return this.adminStateUp;
    }
    /**
     * The collection of tags assigned on the network, which have been
     * explicitly and implicitly added.
     * 
     */
    @Export(name="allTags", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> allTags;

    /**
     * @return The collection of tags assigned on the network, which have been
     * explicitly and implicitly added.
     * 
     */
    public Output<List<String>> allTags() {
        return this.allTags;
    }
    /**
     * An availability zone is used to make
     * network resources highly available. Used for resources with high availability
     * so that they are scheduled on different availability zones. Changing this
     * creates a new network.
     * 
     */
    @Export(name="availabilityZoneHints", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> availabilityZoneHints;

    /**
     * @return An availability zone is used to make
     * network resources highly available. Used for resources with high availability
     * so that they are scheduled on different availability zones. Changing this
     * creates a new network.
     * 
     */
    public Output<List<String>> availabilityZoneHints() {
        return this.availabilityZoneHints;
    }
    /**
     * Human-readable description of the network. Changing this
     * updates the name of the existing network.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Human-readable description of the network. Changing this
     * updates the name of the existing network.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The network DNS domain. Available, when Neutron DNS
     * extension is enabled. The `dns_domain` of a network in conjunction with the
     * `dns_name` attribute of its ports will be published in an external DNS
     * service when Neutron is configured to integrate with such a service.
     * 
     */
    @Export(name="dnsDomain", refs={String.class}, tree="[0]")
    private Output<String> dnsDomain;

    /**
     * @return The network DNS domain. Available, when Neutron DNS
     * extension is enabled. The `dns_domain` of a network in conjunction with the
     * `dns_name` attribute of its ports will be published in an external DNS
     * service when Neutron is configured to integrate with such a service.
     * 
     */
    public Output<String> dnsDomain() {
        return this.dnsDomain;
    }
    /**
     * Specifies whether the network resource has the
     * external routing facility. Valid values are true and false. Defaults to
     * false. Changing this updates the external attribute of the existing network.
     * 
     */
    @Export(name="external", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> external;

    /**
     * @return Specifies whether the network resource has the
     * external routing facility. Valid values are true and false. Defaults to
     * false. Changing this updates the external attribute of the existing network.
     * 
     */
    public Output<Boolean> external() {
        return this.external;
    }
    /**
     * The network MTU. Available for read-only, when Neutron
     * `net-mtu` extension is enabled. Available for the modification, when
     * Neutron `net-mtu-writable` extension is enabled.
     * 
     */
    @Export(name="mtu", refs={Integer.class}, tree="[0]")
    private Output<Integer> mtu;

    /**
     * @return The network MTU. Available for read-only, when Neutron
     * `net-mtu` extension is enabled. Available for the modification, when
     * Neutron `net-mtu-writable` extension is enabled.
     * 
     */
    public Output<Integer> mtu() {
        return this.mtu;
    }
    /**
     * The name of the network. Changing this updates the name of
     * the existing network.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the network. Changing this updates the name of
     * the existing network.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Whether to explicitly enable or disable
     * port security on the network. Port Security is usually enabled by default, so
     * omitting this argument will usually result in a value of &#34;true&#34;. Setting this
     * explicitly to `false` will disable port security. Valid values are `true` and
     * `false`.
     * 
     */
    @Export(name="portSecurityEnabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> portSecurityEnabled;

    /**
     * @return Whether to explicitly enable or disable
     * port security on the network. Port Security is usually enabled by default, so
     * omitting this argument will usually result in a value of &#34;true&#34;. Setting this
     * explicitly to `false` will disable port security. Valid values are `true` and
     * `false`.
     * 
     */
    public Output<Boolean> portSecurityEnabled() {
        return this.portSecurityEnabled;
    }
    /**
     * Reference to the associated QoS policy.
     * 
     */
    @Export(name="qosPolicyId", refs={String.class}, tree="[0]")
    private Output<String> qosPolicyId;

    /**
     * @return Reference to the associated QoS policy.
     * 
     */
    public Output<String> qosPolicyId() {
        return this.qosPolicyId;
    }
    /**
     * The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a Neutron network. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * network.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a Neutron network. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * network.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * An array of one or more provider segment objects.
     * Note: most Networking plug-ins (e.g. ML2 Plugin) and drivers do not support
     * updating any provider related segments attributes. Check your plug-in whether
     * it supports updating.
     * 
     */
    @Export(name="segments", refs={List.class,NetworkSegment.class}, tree="[0,1]")
    private Output<List<NetworkSegment>> segments;

    /**
     * @return An array of one or more provider segment objects.
     * Note: most Networking plug-ins (e.g. ML2 Plugin) and drivers do not support
     * updating any provider related segments attributes. Check your plug-in whether
     * it supports updating.
     * 
     */
    public Output<List<NetworkSegment>> segments() {
        return this.segments;
    }
    /**
     * Specifies whether the network resource can be accessed
     * by any tenant or not. Changing this updates the sharing capabilities of the
     * existing network.
     * 
     */
    @Export(name="shared", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> shared;

    /**
     * @return Specifies whether the network resource can be accessed
     * by any tenant or not. Changing this updates the sharing capabilities of the
     * existing network.
     * 
     */
    public Output<Boolean> shared() {
        return this.shared;
    }
    /**
     * A set of string tags for the network.
     * 
     */
    @Export(name="tags", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tags;

    /**
     * @return A set of string tags for the network.
     * 
     */
    public Output<Optional<List<String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * The owner of the network. Required if admin wants to
     * create a network for another tenant. Changing this creates a new network.
     * 
     */
    @Export(name="tenantId", refs={String.class}, tree="[0]")
    private Output<String> tenantId;

    /**
     * @return The owner of the network. Required if admin wants to
     * create a network for another tenant. Changing this creates a new network.
     * 
     */
    public Output<String> tenantId() {
        return this.tenantId;
    }
    /**
     * Specifies whether the network resource has the
     * VLAN transparent attribute set. Valid values are true and false. Defaults to
     * false. Changing this updates the `transparent_vlan` attribute of the existing
     * network.
     * 
     */
    @Export(name="transparentVlan", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> transparentVlan;

    /**
     * @return Specifies whether the network resource has the
     * VLAN transparent attribute set. Valid values are true and false. Defaults to
     * false. Changing this updates the `transparent_vlan` attribute of the existing
     * network.
     * 
     */
    public Output<Boolean> transparentVlan() {
        return this.transparentVlan;
    }
    /**
     * Map of additional options.
     * 
     */
    @Export(name="valueSpecs", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional options.
     * 
     */
    public Output<Optional<Map<String,Object>>> valueSpecs() {
        return Codegen.optional(this.valueSpecs);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Network(String name) {
        this(name, NetworkArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Network(String name, @Nullable NetworkArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Network(String name, @Nullable NetworkArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/network:Network", name, args == null ? NetworkArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Network(String name, Output<String> id, @Nullable NetworkState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/network:Network", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Network get(String name, Output<String> id, @Nullable NetworkState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Network(name, id, state, options);
    }
}
