// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class PortForwardingV2Args extends com.pulumi.resources.ResourceArgs {

    public static final PortForwardingV2Args Empty = new PortForwardingV2Args();

    /**
     * A text describing the port forwarding. Changing this
     * updates the `description` of an existing port forwarding.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A text describing the port forwarding. Changing this
     * updates the `description` of an existing port forwarding.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The TCP/UDP/other protocol port number of the port forwarding. Changing this
     * updates the `external_port` of an existing port forwarding.
     * 
     */
    @Import(name="externalPort", required=true)
    private Output<Integer> externalPort;

    /**
     * @return The TCP/UDP/other protocol port number of the port forwarding. Changing this
     * updates the `external_port` of an existing port forwarding.
     * 
     */
    public Output<Integer> externalPort() {
        return this.externalPort;
    }

    /**
     * The ID of the Neutron floating IP address. Changing this creates a new port forwarding.
     * 
     */
    @Import(name="floatingipId", required=true)
    private Output<String> floatingipId;

    /**
     * @return The ID of the Neutron floating IP address. Changing this creates a new port forwarding.
     * 
     */
    public Output<String> floatingipId() {
        return this.floatingipId;
    }

    /**
     * The fixed IPv4 address of the Neutron port associated with the port forwarding.
     * Changing this updates the `internal_ip_address` of an existing port forwarding.
     * 
     */
    @Import(name="internalIpAddress", required=true)
    private Output<String> internalIpAddress;

    /**
     * @return The fixed IPv4 address of the Neutron port associated with the port forwarding.
     * Changing this updates the `internal_ip_address` of an existing port forwarding.
     * 
     */
    public Output<String> internalIpAddress() {
        return this.internalIpAddress;
    }

    /**
     * The TCP/UDP/other protocol port number of the Neutron port fixed IP address associated to the
     * port forwarding. Changing this updates the `internal_port` of an existing port forwarding.
     * 
     */
    @Import(name="internalPort", required=true)
    private Output<Integer> internalPort;

    /**
     * @return The TCP/UDP/other protocol port number of the Neutron port fixed IP address associated to the
     * port forwarding. Changing this updates the `internal_port` of an existing port forwarding.
     * 
     */
    public Output<Integer> internalPort() {
        return this.internalPort;
    }

    /**
     * The ID of the Neutron port associated with the port forwarding. Changing
     * this updates the `internal_port_id` of an existing port forwarding.
     * 
     */
    @Import(name="internalPortId", required=true)
    private Output<String> internalPortId;

    /**
     * @return The ID of the Neutron port associated with the port forwarding. Changing
     * this updates the `internal_port_id` of an existing port forwarding.
     * 
     */
    public Output<String> internalPortId() {
        return this.internalPortId;
    }

    /**
     * The IP protocol used in the port forwarding. Changing this updates the `protocol`
     * of an existing port forwarding.
     * 
     */
    @Import(name="protocol", required=true)
    private Output<String> protocol;

    /**
     * @return The IP protocol used in the port forwarding. Changing this updates the `protocol`
     * of an existing port forwarding.
     * 
     */
    public Output<String> protocol() {
        return this.protocol;
    }

    /**
     * The region in which to obtain the V2 networking client.
     * A networking client is needed to create a port forwarding. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * port forwarding.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 networking client.
     * A networking client is needed to create a port forwarding. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * port forwarding.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    private PortForwardingV2Args() {}

    private PortForwardingV2Args(PortForwardingV2Args $) {
        this.description = $.description;
        this.externalPort = $.externalPort;
        this.floatingipId = $.floatingipId;
        this.internalIpAddress = $.internalIpAddress;
        this.internalPort = $.internalPort;
        this.internalPortId = $.internalPortId;
        this.protocol = $.protocol;
        this.region = $.region;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PortForwardingV2Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PortForwardingV2Args $;

        public Builder() {
            $ = new PortForwardingV2Args();
        }

        public Builder(PortForwardingV2Args defaults) {
            $ = new PortForwardingV2Args(Objects.requireNonNull(defaults));
        }

        /**
         * @param description A text describing the port forwarding. Changing this
         * updates the `description` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A text describing the port forwarding. Changing this
         * updates the `description` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param externalPort The TCP/UDP/other protocol port number of the port forwarding. Changing this
         * updates the `external_port` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder externalPort(Output<Integer> externalPort) {
            $.externalPort = externalPort;
            return this;
        }

        /**
         * @param externalPort The TCP/UDP/other protocol port number of the port forwarding. Changing this
         * updates the `external_port` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder externalPort(Integer externalPort) {
            return externalPort(Output.of(externalPort));
        }

        /**
         * @param floatingipId The ID of the Neutron floating IP address. Changing this creates a new port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder floatingipId(Output<String> floatingipId) {
            $.floatingipId = floatingipId;
            return this;
        }

        /**
         * @param floatingipId The ID of the Neutron floating IP address. Changing this creates a new port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder floatingipId(String floatingipId) {
            return floatingipId(Output.of(floatingipId));
        }

        /**
         * @param internalIpAddress The fixed IPv4 address of the Neutron port associated with the port forwarding.
         * Changing this updates the `internal_ip_address` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder internalIpAddress(Output<String> internalIpAddress) {
            $.internalIpAddress = internalIpAddress;
            return this;
        }

        /**
         * @param internalIpAddress The fixed IPv4 address of the Neutron port associated with the port forwarding.
         * Changing this updates the `internal_ip_address` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder internalIpAddress(String internalIpAddress) {
            return internalIpAddress(Output.of(internalIpAddress));
        }

        /**
         * @param internalPort The TCP/UDP/other protocol port number of the Neutron port fixed IP address associated to the
         * port forwarding. Changing this updates the `internal_port` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder internalPort(Output<Integer> internalPort) {
            $.internalPort = internalPort;
            return this;
        }

        /**
         * @param internalPort The TCP/UDP/other protocol port number of the Neutron port fixed IP address associated to the
         * port forwarding. Changing this updates the `internal_port` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder internalPort(Integer internalPort) {
            return internalPort(Output.of(internalPort));
        }

        /**
         * @param internalPortId The ID of the Neutron port associated with the port forwarding. Changing
         * this updates the `internal_port_id` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder internalPortId(Output<String> internalPortId) {
            $.internalPortId = internalPortId;
            return this;
        }

        /**
         * @param internalPortId The ID of the Neutron port associated with the port forwarding. Changing
         * this updates the `internal_port_id` of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder internalPortId(String internalPortId) {
            return internalPortId(Output.of(internalPortId));
        }

        /**
         * @param protocol The IP protocol used in the port forwarding. Changing this updates the `protocol`
         * of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder protocol(Output<String> protocol) {
            $.protocol = protocol;
            return this;
        }

        /**
         * @param protocol The IP protocol used in the port forwarding. Changing this updates the `protocol`
         * of an existing port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder protocol(String protocol) {
            return protocol(Output.of(protocol));
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to create a port forwarding. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to create a port forwarding. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * port forwarding.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        public PortForwardingV2Args build() {
            if ($.externalPort == null) {
                throw new MissingRequiredPropertyException("PortForwardingV2Args", "externalPort");
            }
            if ($.floatingipId == null) {
                throw new MissingRequiredPropertyException("PortForwardingV2Args", "floatingipId");
            }
            if ($.internalIpAddress == null) {
                throw new MissingRequiredPropertyException("PortForwardingV2Args", "internalIpAddress");
            }
            if ($.internalPort == null) {
                throw new MissingRequiredPropertyException("PortForwardingV2Args", "internalPort");
            }
            if ($.internalPortId == null) {
                throw new MissingRequiredPropertyException("PortForwardingV2Args", "internalPortId");
            }
            if ($.protocol == null) {
                throw new MissingRequiredPropertyException("PortForwardingV2Args", "protocol");
            }
            return $;
        }
    }

}
