// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.networking.PortSecGroupAssociateArgs;
import com.pulumi.openstack.networking.inputs.PortSecGroupAssociateState;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * ## Example Usage
 * ### Append a security group to an existing port
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.NetworkingFunctions;
 * import com.pulumi.openstack.networking.inputs.GetPortArgs;
 * import com.pulumi.openstack.networking.inputs.GetSecGroupArgs;
 * import com.pulumi.openstack.networking.PortSecGroupAssociate;
 * import com.pulumi.openstack.networking.PortSecGroupAssociateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var systemPort = NetworkingFunctions.getPort(GetPortArgs.builder()
 *             .fixedIp(&#34;10.0.0.10&#34;)
 *             .build());
 * 
 *         final var secgroup = NetworkingFunctions.getSecGroup(GetSecGroupArgs.builder()
 *             .name(&#34;secgroup&#34;)
 *             .build());
 * 
 *         var port1 = new PortSecGroupAssociate(&#34;port1&#34;, PortSecGroupAssociateArgs.builder()        
 *             .portId(systemPort.applyValue(getPortResult -&gt; getPortResult.id()))
 *             .securityGroupIds(secgroup.applyValue(getSecGroupResult -&gt; getSecGroupResult.id()))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Enforce a security group to an existing port
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.NetworkingFunctions;
 * import com.pulumi.openstack.networking.inputs.GetPortArgs;
 * import com.pulumi.openstack.networking.inputs.GetSecGroupArgs;
 * import com.pulumi.openstack.networking.PortSecGroupAssociate;
 * import com.pulumi.openstack.networking.PortSecGroupAssociateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var systemPort = NetworkingFunctions.getPort(GetPortArgs.builder()
 *             .fixedIp(&#34;10.0.0.10&#34;)
 *             .build());
 * 
 *         final var secgroup = NetworkingFunctions.getSecGroup(GetSecGroupArgs.builder()
 *             .name(&#34;secgroup&#34;)
 *             .build());
 * 
 *         var port1 = new PortSecGroupAssociate(&#34;port1&#34;, PortSecGroupAssociateArgs.builder()        
 *             .portId(systemPort.applyValue(getPortResult -&gt; getPortResult.id()))
 *             .enforce(&#34;true&#34;)
 *             .securityGroupIds(secgroup.applyValue(getSecGroupResult -&gt; getSecGroupResult.id()))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Remove all security groups from an existing port
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.NetworkingFunctions;
 * import com.pulumi.openstack.networking.inputs.GetPortArgs;
 * import com.pulumi.openstack.networking.PortSecGroupAssociate;
 * import com.pulumi.openstack.networking.PortSecGroupAssociateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var systemPort = NetworkingFunctions.getPort(GetPortArgs.builder()
 *             .fixedIp(&#34;10.0.0.10&#34;)
 *             .build());
 * 
 *         var port1 = new PortSecGroupAssociate(&#34;port1&#34;, PortSecGroupAssociateArgs.builder()        
 *             .portId(systemPort.applyValue(getPortResult -&gt; getPortResult.id()))
 *             .enforce(&#34;true&#34;)
 *             .securityGroupIds()
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Port security group association can be imported using the `id` of the port, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:networking/portSecGroupAssociate:PortSecGroupAssociate port_1 eae26a3e-1c33-4cc1-9c31-0cd729c438a1
 * ```
 * 
 */
@ResourceType(type="openstack:networking/portSecGroupAssociate:PortSecGroupAssociate")
public class PortSecGroupAssociate extends com.pulumi.resources.CustomResource {
    /**
     * The collection of Security Group IDs on the port
     * which have been explicitly and implicitly added.
     * 
     */
    @Export(name="allSecurityGroupIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> allSecurityGroupIds;

    /**
     * @return The collection of Security Group IDs on the port
     * which have been explicitly and implicitly added.
     * 
     */
    public Output<List<String>> allSecurityGroupIds() {
        return this.allSecurityGroupIds;
    }
    /**
     * Whether to replace or append the list of security
     * groups, specified in the `security_group_ids`. Defaults to `false`.
     * 
     */
    @Export(name="enforce", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enforce;

    /**
     * @return Whether to replace or append the list of security
     * groups, specified in the `security_group_ids`. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> enforce() {
        return Codegen.optional(this.enforce);
    }
    /**
     * An UUID of the port to apply security groups to.
     * 
     */
    @Export(name="portId", refs={String.class}, tree="[0]")
    private Output<String> portId;

    /**
     * @return An UUID of the port to apply security groups to.
     * 
     */
    public Output<String> portId() {
        return this.portId;
    }
    /**
     * The region in which to obtain the V2 networking client.
     * A networking client is needed to manage a port. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * resource.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 networking client.
     * A networking client is needed to manage a port. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * resource.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * A list of security group IDs to apply to
     * the port. The security groups must be specified by ID and not name (as
     * opposed to how they are configured with the Compute Instance).
     * 
     */
    @Export(name="securityGroupIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> securityGroupIds;

    /**
     * @return A list of security group IDs to apply to
     * the port. The security groups must be specified by ID and not name (as
     * opposed to how they are configured with the Compute Instance).
     * 
     */
    public Output<List<String>> securityGroupIds() {
        return this.securityGroupIds;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public PortSecGroupAssociate(String name) {
        this(name, PortSecGroupAssociateArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public PortSecGroupAssociate(String name, PortSecGroupAssociateArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public PortSecGroupAssociate(String name, PortSecGroupAssociateArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/portSecGroupAssociate:PortSecGroupAssociate", name, args == null ? PortSecGroupAssociateArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private PortSecGroupAssociate(String name, Output<String> id, @Nullable PortSecGroupAssociateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/portSecGroupAssociate:PortSecGroupAssociate", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static PortSecGroupAssociate get(String name, Output<String> id, @Nullable PortSecGroupAssociateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new PortSecGroupAssociate(name, id, state, options);
    }
}
