// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.openstack.networking.inputs.RouterExternalFixedIpArgs;
import com.pulumi.openstack.networking.inputs.RouterVendorOptionsArgs;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class RouterArgs extends com.pulumi.resources.ResourceArgs {

    public static final RouterArgs Empty = new RouterArgs();

    /**
     * Administrative up/down status for the router
     * (must be &#34;true&#34; or &#34;false&#34; if provided). Changing this updates the
     * `admin_state_up` of an existing router.
     * 
     */
    @Import(name="adminStateUp")
    private @Nullable Output<Boolean> adminStateUp;

    /**
     * @return Administrative up/down status for the router
     * (must be &#34;true&#34; or &#34;false&#34; if provided). Changing this updates the
     * `admin_state_up` of an existing router.
     * 
     */
    public Optional<Output<Boolean>> adminStateUp() {
        return Optional.ofNullable(this.adminStateUp);
    }

    /**
     * An availability zone is used to make
     * network resources highly available. Used for resources with high availability
     * so that they are scheduled on different availability zones. Changing this
     * creates a new router.
     * 
     */
    @Import(name="availabilityZoneHints")
    private @Nullable Output<List<String>> availabilityZoneHints;

    /**
     * @return An availability zone is used to make
     * network resources highly available. Used for resources with high availability
     * so that they are scheduled on different availability zones. Changing this
     * creates a new router.
     * 
     */
    public Optional<Output<List<String>>> availabilityZoneHints() {
        return Optional.ofNullable(this.availabilityZoneHints);
    }

    /**
     * Human-readable description for the router.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Human-readable description for the router.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Indicates whether or not to create a
     * distributed router. The default policy setting in Neutron restricts
     * usage of this property to administrative users only.
     * 
     */
    @Import(name="distributed")
    private @Nullable Output<Boolean> distributed;

    /**
     * @return Indicates whether or not to create a
     * distributed router. The default policy setting in Neutron restricts
     * usage of this property to administrative users only.
     * 
     */
    public Optional<Output<Boolean>> distributed() {
        return Optional.ofNullable(this.distributed);
    }

    /**
     * Enable Source NAT for the router. Valid values are
     * &#34;true&#34; or &#34;false&#34;. An `external_network_id` has to be set in order to
     * set this property. Changing this updates the `enable_snat` of the router.
     * Setting this value **requires** an **ext-gw-mode** extension to be enabled
     * in OpenStack Neutron.
     * 
     */
    @Import(name="enableSnat")
    private @Nullable Output<Boolean> enableSnat;

    /**
     * @return Enable Source NAT for the router. Valid values are
     * &#34;true&#34; or &#34;false&#34;. An `external_network_id` has to be set in order to
     * set this property. Changing this updates the `enable_snat` of the router.
     * Setting this value **requires** an **ext-gw-mode** extension to be enabled
     * in OpenStack Neutron.
     * 
     */
    public Optional<Output<Boolean>> enableSnat() {
        return Optional.ofNullable(this.enableSnat);
    }

    /**
     * An external fixed IP for the router. This
     * can be repeated. The structure is described below. An `external_network_id`
     * has to be set in order to set this property. Changing this updates the
     * external fixed IPs of the router.
     * 
     */
    @Import(name="externalFixedIps")
    private @Nullable Output<List<RouterExternalFixedIpArgs>> externalFixedIps;

    /**
     * @return An external fixed IP for the router. This
     * can be repeated. The structure is described below. An `external_network_id`
     * has to be set in order to set this property. Changing this updates the
     * external fixed IPs of the router.
     * 
     */
    public Optional<Output<List<RouterExternalFixedIpArgs>>> externalFixedIps() {
        return Optional.ofNullable(this.externalFixedIps);
    }

    /**
     * The
     * network UUID of an external gateway for the router. A router with an
     * external gateway is required if any compute instances or load balancers
     * will be using floating IPs. Changing this updates the external gateway
     * of an existing router.
     * 
     * @deprecated
     * use external_network_id instead
     * 
     */
    @Deprecated /* use external_network_id instead */
    @Import(name="externalGateway")
    private @Nullable Output<String> externalGateway;

    /**
     * @return The
     * network UUID of an external gateway for the router. A router with an
     * external gateway is required if any compute instances or load balancers
     * will be using floating IPs. Changing this updates the external gateway
     * of an existing router.
     * 
     * @deprecated
     * use external_network_id instead
     * 
     */
    @Deprecated /* use external_network_id instead */
    public Optional<Output<String>> externalGateway() {
        return Optional.ofNullable(this.externalGateway);
    }

    /**
     * The network UUID of an external gateway
     * for the router. A router with an external gateway is required if any
     * compute instances or load balancers will be using floating IPs. Changing
     * this updates the external gateway of the router.
     * 
     */
    @Import(name="externalNetworkId")
    private @Nullable Output<String> externalNetworkId;

    /**
     * @return The network UUID of an external gateway
     * for the router. A router with an external gateway is required if any
     * compute instances or load balancers will be using floating IPs. Changing
     * this updates the external gateway of the router.
     * 
     */
    public Optional<Output<String>> externalNetworkId() {
        return Optional.ofNullable(this.externalNetworkId);
    }

    /**
     * A list of external subnet IDs to try over
     * each to obtain a fixed IP for the router. If a subnet ID in a list has
     * exhausted floating IP pool, the next subnet ID will be tried. This argument is
     * used only during the router creation and allows to set only one external fixed
     * IP. Conflicts with an `external_fixed_ip` argument.
     * 
     */
    @Import(name="externalSubnetIds")
    private @Nullable Output<List<String>> externalSubnetIds;

    /**
     * @return A list of external subnet IDs to try over
     * each to obtain a fixed IP for the router. If a subnet ID in a list has
     * exhausted floating IP pool, the next subnet ID will be tried. This argument is
     * used only during the router creation and allows to set only one external fixed
     * IP. Conflicts with an `external_fixed_ip` argument.
     * 
     */
    public Optional<Output<List<String>>> externalSubnetIds() {
        return Optional.ofNullable(this.externalSubnetIds);
    }

    /**
     * A unique name for the router. Changing this
     * updates the `name` of an existing router.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return A unique name for the router. Changing this
     * updates the `name` of an existing router.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The region in which to obtain the V2 networking client.
     * A networking client is needed to create a router. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * router.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 networking client.
     * A networking client is needed to create a router. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * router.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * A set of string tags for the router.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<List<String>> tags;

    /**
     * @return A set of string tags for the router.
     * 
     */
    public Optional<Output<List<String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The owner of the floating IP. Required if admin wants
     * to create a router for another tenant. Changing this creates a new router.
     * 
     */
    @Import(name="tenantId")
    private @Nullable Output<String> tenantId;

    /**
     * @return The owner of the floating IP. Required if admin wants
     * to create a router for another tenant. Changing this creates a new router.
     * 
     */
    public Optional<Output<String>> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    /**
     * Map of additional driver-specific options.
     * 
     */
    @Import(name="valueSpecs")
    private @Nullable Output<Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional driver-specific options.
     * 
     */
    public Optional<Output<Map<String,Object>>> valueSpecs() {
        return Optional.ofNullable(this.valueSpecs);
    }

    /**
     * Map of additional vendor-specific options.
     * Supported options are described below.
     * 
     */
    @Import(name="vendorOptions")
    private @Nullable Output<RouterVendorOptionsArgs> vendorOptions;

    /**
     * @return Map of additional vendor-specific options.
     * Supported options are described below.
     * 
     */
    public Optional<Output<RouterVendorOptionsArgs>> vendorOptions() {
        return Optional.ofNullable(this.vendorOptions);
    }

    private RouterArgs() {}

    private RouterArgs(RouterArgs $) {
        this.adminStateUp = $.adminStateUp;
        this.availabilityZoneHints = $.availabilityZoneHints;
        this.description = $.description;
        this.distributed = $.distributed;
        this.enableSnat = $.enableSnat;
        this.externalFixedIps = $.externalFixedIps;
        this.externalGateway = $.externalGateway;
        this.externalNetworkId = $.externalNetworkId;
        this.externalSubnetIds = $.externalSubnetIds;
        this.name = $.name;
        this.region = $.region;
        this.tags = $.tags;
        this.tenantId = $.tenantId;
        this.valueSpecs = $.valueSpecs;
        this.vendorOptions = $.vendorOptions;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(RouterArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private RouterArgs $;

        public Builder() {
            $ = new RouterArgs();
        }

        public Builder(RouterArgs defaults) {
            $ = new RouterArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param adminStateUp Administrative up/down status for the router
         * (must be &#34;true&#34; or &#34;false&#34; if provided). Changing this updates the
         * `admin_state_up` of an existing router.
         * 
         * @return builder
         * 
         */
        public Builder adminStateUp(@Nullable Output<Boolean> adminStateUp) {
            $.adminStateUp = adminStateUp;
            return this;
        }

        /**
         * @param adminStateUp Administrative up/down status for the router
         * (must be &#34;true&#34; or &#34;false&#34; if provided). Changing this updates the
         * `admin_state_up` of an existing router.
         * 
         * @return builder
         * 
         */
        public Builder adminStateUp(Boolean adminStateUp) {
            return adminStateUp(Output.of(adminStateUp));
        }

        /**
         * @param availabilityZoneHints An availability zone is used to make
         * network resources highly available. Used for resources with high availability
         * so that they are scheduled on different availability zones. Changing this
         * creates a new router.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZoneHints(@Nullable Output<List<String>> availabilityZoneHints) {
            $.availabilityZoneHints = availabilityZoneHints;
            return this;
        }

        /**
         * @param availabilityZoneHints An availability zone is used to make
         * network resources highly available. Used for resources with high availability
         * so that they are scheduled on different availability zones. Changing this
         * creates a new router.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZoneHints(List<String> availabilityZoneHints) {
            return availabilityZoneHints(Output.of(availabilityZoneHints));
        }

        /**
         * @param availabilityZoneHints An availability zone is used to make
         * network resources highly available. Used for resources with high availability
         * so that they are scheduled on different availability zones. Changing this
         * creates a new router.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZoneHints(String... availabilityZoneHints) {
            return availabilityZoneHints(List.of(availabilityZoneHints));
        }

        /**
         * @param description Human-readable description for the router.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Human-readable description for the router.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param distributed Indicates whether or not to create a
         * distributed router. The default policy setting in Neutron restricts
         * usage of this property to administrative users only.
         * 
         * @return builder
         * 
         */
        public Builder distributed(@Nullable Output<Boolean> distributed) {
            $.distributed = distributed;
            return this;
        }

        /**
         * @param distributed Indicates whether or not to create a
         * distributed router. The default policy setting in Neutron restricts
         * usage of this property to administrative users only.
         * 
         * @return builder
         * 
         */
        public Builder distributed(Boolean distributed) {
            return distributed(Output.of(distributed));
        }

        /**
         * @param enableSnat Enable Source NAT for the router. Valid values are
         * &#34;true&#34; or &#34;false&#34;. An `external_network_id` has to be set in order to
         * set this property. Changing this updates the `enable_snat` of the router.
         * Setting this value **requires** an **ext-gw-mode** extension to be enabled
         * in OpenStack Neutron.
         * 
         * @return builder
         * 
         */
        public Builder enableSnat(@Nullable Output<Boolean> enableSnat) {
            $.enableSnat = enableSnat;
            return this;
        }

        /**
         * @param enableSnat Enable Source NAT for the router. Valid values are
         * &#34;true&#34; or &#34;false&#34;. An `external_network_id` has to be set in order to
         * set this property. Changing this updates the `enable_snat` of the router.
         * Setting this value **requires** an **ext-gw-mode** extension to be enabled
         * in OpenStack Neutron.
         * 
         * @return builder
         * 
         */
        public Builder enableSnat(Boolean enableSnat) {
            return enableSnat(Output.of(enableSnat));
        }

        /**
         * @param externalFixedIps An external fixed IP for the router. This
         * can be repeated. The structure is described below. An `external_network_id`
         * has to be set in order to set this property. Changing this updates the
         * external fixed IPs of the router.
         * 
         * @return builder
         * 
         */
        public Builder externalFixedIps(@Nullable Output<List<RouterExternalFixedIpArgs>> externalFixedIps) {
            $.externalFixedIps = externalFixedIps;
            return this;
        }

        /**
         * @param externalFixedIps An external fixed IP for the router. This
         * can be repeated. The structure is described below. An `external_network_id`
         * has to be set in order to set this property. Changing this updates the
         * external fixed IPs of the router.
         * 
         * @return builder
         * 
         */
        public Builder externalFixedIps(List<RouterExternalFixedIpArgs> externalFixedIps) {
            return externalFixedIps(Output.of(externalFixedIps));
        }

        /**
         * @param externalFixedIps An external fixed IP for the router. This
         * can be repeated. The structure is described below. An `external_network_id`
         * has to be set in order to set this property. Changing this updates the
         * external fixed IPs of the router.
         * 
         * @return builder
         * 
         */
        public Builder externalFixedIps(RouterExternalFixedIpArgs... externalFixedIps) {
            return externalFixedIps(List.of(externalFixedIps));
        }

        /**
         * @param externalGateway The
         * network UUID of an external gateway for the router. A router with an
         * external gateway is required if any compute instances or load balancers
         * will be using floating IPs. Changing this updates the external gateway
         * of an existing router.
         * 
         * @return builder
         * 
         * @deprecated
         * use external_network_id instead
         * 
         */
        @Deprecated /* use external_network_id instead */
        public Builder externalGateway(@Nullable Output<String> externalGateway) {
            $.externalGateway = externalGateway;
            return this;
        }

        /**
         * @param externalGateway The
         * network UUID of an external gateway for the router. A router with an
         * external gateway is required if any compute instances or load balancers
         * will be using floating IPs. Changing this updates the external gateway
         * of an existing router.
         * 
         * @return builder
         * 
         * @deprecated
         * use external_network_id instead
         * 
         */
        @Deprecated /* use external_network_id instead */
        public Builder externalGateway(String externalGateway) {
            return externalGateway(Output.of(externalGateway));
        }

        /**
         * @param externalNetworkId The network UUID of an external gateway
         * for the router. A router with an external gateway is required if any
         * compute instances or load balancers will be using floating IPs. Changing
         * this updates the external gateway of the router.
         * 
         * @return builder
         * 
         */
        public Builder externalNetworkId(@Nullable Output<String> externalNetworkId) {
            $.externalNetworkId = externalNetworkId;
            return this;
        }

        /**
         * @param externalNetworkId The network UUID of an external gateway
         * for the router. A router with an external gateway is required if any
         * compute instances or load balancers will be using floating IPs. Changing
         * this updates the external gateway of the router.
         * 
         * @return builder
         * 
         */
        public Builder externalNetworkId(String externalNetworkId) {
            return externalNetworkId(Output.of(externalNetworkId));
        }

        /**
         * @param externalSubnetIds A list of external subnet IDs to try over
         * each to obtain a fixed IP for the router. If a subnet ID in a list has
         * exhausted floating IP pool, the next subnet ID will be tried. This argument is
         * used only during the router creation and allows to set only one external fixed
         * IP. Conflicts with an `external_fixed_ip` argument.
         * 
         * @return builder
         * 
         */
        public Builder externalSubnetIds(@Nullable Output<List<String>> externalSubnetIds) {
            $.externalSubnetIds = externalSubnetIds;
            return this;
        }

        /**
         * @param externalSubnetIds A list of external subnet IDs to try over
         * each to obtain a fixed IP for the router. If a subnet ID in a list has
         * exhausted floating IP pool, the next subnet ID will be tried. This argument is
         * used only during the router creation and allows to set only one external fixed
         * IP. Conflicts with an `external_fixed_ip` argument.
         * 
         * @return builder
         * 
         */
        public Builder externalSubnetIds(List<String> externalSubnetIds) {
            return externalSubnetIds(Output.of(externalSubnetIds));
        }

        /**
         * @param externalSubnetIds A list of external subnet IDs to try over
         * each to obtain a fixed IP for the router. If a subnet ID in a list has
         * exhausted floating IP pool, the next subnet ID will be tried. This argument is
         * used only during the router creation and allows to set only one external fixed
         * IP. Conflicts with an `external_fixed_ip` argument.
         * 
         * @return builder
         * 
         */
        public Builder externalSubnetIds(String... externalSubnetIds) {
            return externalSubnetIds(List.of(externalSubnetIds));
        }

        /**
         * @param name A unique name for the router. Changing this
         * updates the `name` of an existing router.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name A unique name for the router. Changing this
         * updates the `name` of an existing router.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to create a router. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * router.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to create a router. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * router.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param tags A set of string tags for the router.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<List<String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A set of string tags for the router.
         * 
         * @return builder
         * 
         */
        public Builder tags(List<String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tags A set of string tags for the router.
         * 
         * @return builder
         * 
         */
        public Builder tags(String... tags) {
            return tags(List.of(tags));
        }

        /**
         * @param tenantId The owner of the floating IP. Required if admin wants
         * to create a router for another tenant. Changing this creates a new router.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(@Nullable Output<String> tenantId) {
            $.tenantId = tenantId;
            return this;
        }

        /**
         * @param tenantId The owner of the floating IP. Required if admin wants
         * to create a router for another tenant. Changing this creates a new router.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(String tenantId) {
            return tenantId(Output.of(tenantId));
        }

        /**
         * @param valueSpecs Map of additional driver-specific options.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(@Nullable Output<Map<String,Object>> valueSpecs) {
            $.valueSpecs = valueSpecs;
            return this;
        }

        /**
         * @param valueSpecs Map of additional driver-specific options.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(Map<String,Object> valueSpecs) {
            return valueSpecs(Output.of(valueSpecs));
        }

        /**
         * @param vendorOptions Map of additional vendor-specific options.
         * Supported options are described below.
         * 
         * @return builder
         * 
         */
        public Builder vendorOptions(@Nullable Output<RouterVendorOptionsArgs> vendorOptions) {
            $.vendorOptions = vendorOptions;
            return this;
        }

        /**
         * @param vendorOptions Map of additional vendor-specific options.
         * Supported options are described below.
         * 
         * @return builder
         * 
         */
        public Builder vendorOptions(RouterVendorOptionsArgs vendorOptions) {
            return vendorOptions(Output.of(vendorOptions));
        }

        public RouterArgs build() {
            return $;
        }
    }

}
