// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.networking.RouterRouteArgs;
import com.pulumi.openstack.networking.inputs.RouterRouteState;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Creates a routing entry on a OpenStack V2 router.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.Router;
 * import com.pulumi.openstack.networking.RouterArgs;
 * import com.pulumi.openstack.networking.Network;
 * import com.pulumi.openstack.networking.NetworkArgs;
 * import com.pulumi.openstack.networking.Subnet;
 * import com.pulumi.openstack.networking.SubnetArgs;
 * import com.pulumi.openstack.networking.RouterInterface;
 * import com.pulumi.openstack.networking.RouterInterfaceArgs;
 * import com.pulumi.openstack.networking.RouterRoute;
 * import com.pulumi.openstack.networking.RouterRouteArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var router1 = new Router(&#34;router1&#34;, RouterArgs.builder()        
 *             .adminStateUp(&#34;true&#34;)
 *             .build());
 * 
 *         var network1 = new Network(&#34;network1&#34;, NetworkArgs.builder()        
 *             .adminStateUp(&#34;true&#34;)
 *             .build());
 * 
 *         var subnet1 = new Subnet(&#34;subnet1&#34;, SubnetArgs.builder()        
 *             .networkId(network1.id())
 *             .cidr(&#34;192.168.199.0/24&#34;)
 *             .ipVersion(4)
 *             .build());
 * 
 *         var int1 = new RouterInterface(&#34;int1&#34;, RouterInterfaceArgs.builder()        
 *             .routerId(router1.id())
 *             .subnetId(subnet1.id())
 *             .build());
 * 
 *         var routerRoute1 = new RouterRoute(&#34;routerRoute1&#34;, RouterRouteArgs.builder()        
 *             .routerId(router1.id())
 *             .destinationCidr(&#34;10.0.1.0/24&#34;)
 *             .nextHop(&#34;192.168.199.254&#34;)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(&#34;openstack_networking_router_interface_v2.int_1&#34;)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * ## Notes
 * 
 * The `next_hop` IP address must be directly reachable from the router at the ``openstack.networking.RouterRoute``
 * resource creation time.  You can ensure that by explicitly specifying a dependency on the ``openstack.networking.RouterInterface``
 * resource that connects the next hop to the router, as in the example above.
 * 
 * ## Import
 * 
 * Routing entries can be imported using a combined ID using the following format`&lt;router_id&gt;-route-&lt;destination_cidr&gt;-&lt;next_hop&gt;`
 * 
 * ```sh
 *  $ pulumi import openstack:networking/routerRoute:RouterRoute router_route_1 686fe248-386c-4f70-9f6c-281607dad079-route-10.0.1.0/24-192.168.199.25
 * ```
 * 
 */
@ResourceType(type="openstack:networking/routerRoute:RouterRoute")
public class RouterRoute extends com.pulumi.resources.CustomResource {
    /**
     * CIDR block to match on the packet’s destination IP. Changing
     * this creates a new routing entry.
     * 
     */
    @Export(name="destinationCidr", refs={String.class}, tree="[0]")
    private Output<String> destinationCidr;

    /**
     * @return CIDR block to match on the packet’s destination IP. Changing
     * this creates a new routing entry.
     * 
     */
    public Output<String> destinationCidr() {
        return this.destinationCidr;
    }
    /**
     * IP address of the next hop gateway.  Changing
     * this creates a new routing entry.
     * 
     */
    @Export(name="nextHop", refs={String.class}, tree="[0]")
    private Output<String> nextHop;

    /**
     * @return IP address of the next hop gateway.  Changing
     * this creates a new routing entry.
     * 
     */
    public Output<String> nextHop() {
        return this.nextHop;
    }
    /**
     * The region in which to obtain the V2 networking client.
     * A networking client is needed to configure a routing entry on a router. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * routing entry.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 networking client.
     * A networking client is needed to configure a routing entry on a router. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * routing entry.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * ID of the router this routing entry belongs to. Changing
     * this creates a new routing entry.
     * 
     */
    @Export(name="routerId", refs={String.class}, tree="[0]")
    private Output<String> routerId;

    /**
     * @return ID of the router this routing entry belongs to. Changing
     * this creates a new routing entry.
     * 
     */
    public Output<String> routerId() {
        return this.routerId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public RouterRoute(String name) {
        this(name, RouterRouteArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public RouterRoute(String name, RouterRouteArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public RouterRoute(String name, RouterRouteArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/routerRoute:RouterRoute", name, args == null ? RouterRouteArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private RouterRoute(String name, Output<String> id, @Nullable RouterRouteState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/routerRoute:RouterRoute", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static RouterRoute get(String name, Output<String> id, @Nullable RouterRouteState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new RouterRoute(name, id, state, options);
    }
}
