// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class RouterRouteArgs extends com.pulumi.resources.ResourceArgs {

    public static final RouterRouteArgs Empty = new RouterRouteArgs();

    /**
     * CIDR block to match on the packet’s destination IP. Changing
     * this creates a new routing entry.
     * 
     */
    @Import(name="destinationCidr", required=true)
    private Output<String> destinationCidr;

    /**
     * @return CIDR block to match on the packet’s destination IP. Changing
     * this creates a new routing entry.
     * 
     */
    public Output<String> destinationCidr() {
        return this.destinationCidr;
    }

    /**
     * IP address of the next hop gateway.  Changing
     * this creates a new routing entry.
     * 
     */
    @Import(name="nextHop", required=true)
    private Output<String> nextHop;

    /**
     * @return IP address of the next hop gateway.  Changing
     * this creates a new routing entry.
     * 
     */
    public Output<String> nextHop() {
        return this.nextHop;
    }

    /**
     * The region in which to obtain the V2 networking client.
     * A networking client is needed to configure a routing entry on a router. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * routing entry.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 networking client.
     * A networking client is needed to configure a routing entry on a router. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * routing entry.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * ID of the router this routing entry belongs to. Changing
     * this creates a new routing entry.
     * 
     */
    @Import(name="routerId", required=true)
    private Output<String> routerId;

    /**
     * @return ID of the router this routing entry belongs to. Changing
     * this creates a new routing entry.
     * 
     */
    public Output<String> routerId() {
        return this.routerId;
    }

    private RouterRouteArgs() {}

    private RouterRouteArgs(RouterRouteArgs $) {
        this.destinationCidr = $.destinationCidr;
        this.nextHop = $.nextHop;
        this.region = $.region;
        this.routerId = $.routerId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(RouterRouteArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private RouterRouteArgs $;

        public Builder() {
            $ = new RouterRouteArgs();
        }

        public Builder(RouterRouteArgs defaults) {
            $ = new RouterRouteArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param destinationCidr CIDR block to match on the packet’s destination IP. Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder destinationCidr(Output<String> destinationCidr) {
            $.destinationCidr = destinationCidr;
            return this;
        }

        /**
         * @param destinationCidr CIDR block to match on the packet’s destination IP. Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder destinationCidr(String destinationCidr) {
            return destinationCidr(Output.of(destinationCidr));
        }

        /**
         * @param nextHop IP address of the next hop gateway.  Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder nextHop(Output<String> nextHop) {
            $.nextHop = nextHop;
            return this;
        }

        /**
         * @param nextHop IP address of the next hop gateway.  Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder nextHop(String nextHop) {
            return nextHop(Output.of(nextHop));
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to configure a routing entry on a router. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * routing entry.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to configure a routing entry on a router. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * routing entry.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param routerId ID of the router this routing entry belongs to. Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder routerId(Output<String> routerId) {
            $.routerId = routerId;
            return this;
        }

        /**
         * @param routerId ID of the router this routing entry belongs to. Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder routerId(String routerId) {
            return routerId(Output.of(routerId));
        }

        public RouterRouteArgs build() {
            if ($.destinationCidr == null) {
                throw new MissingRequiredPropertyException("RouterRouteArgs", "destinationCidr");
            }
            if ($.nextHop == null) {
                throw new MissingRequiredPropertyException("RouterRouteArgs", "nextHop");
            }
            if ($.routerId == null) {
                throw new MissingRequiredPropertyException("RouterRouteArgs", "routerId");
            }
            return $;
        }
    }

}
