// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SecGroupRuleArgs extends com.pulumi.resources.ResourceArgs {

    public static final SecGroupRuleArgs Empty = new SecGroupRuleArgs();

    /**
     * A description of the rule. Changing this creates a new security group rule.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A description of the rule. Changing this creates a new security group rule.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The direction of the rule, valid values are __ingress__
     * or __egress__. Changing this creates a new security group rule.
     * 
     */
    @Import(name="direction", required=true)
    private Output<String> direction;

    /**
     * @return The direction of the rule, valid values are __ingress__
     * or __egress__. Changing this creates a new security group rule.
     * 
     */
    public Output<String> direction() {
        return this.direction;
    }

    /**
     * The layer 3 protocol type, valid values are __IPv4__
     * or __IPv6__. Changing this creates a new security group rule.
     * 
     */
    @Import(name="ethertype", required=true)
    private Output<String> ethertype;

    /**
     * @return The layer 3 protocol type, valid values are __IPv4__
     * or __IPv6__. Changing this creates a new security group rule.
     * 
     */
    public Output<String> ethertype() {
        return this.ethertype;
    }

    /**
     * The higher part of the allowed port range, valid
     * integer value needs to be between 1 and 65535. Changing this creates a new
     * security group rule.
     * 
     */
    @Import(name="portRangeMax")
    private @Nullable Output<Integer> portRangeMax;

    /**
     * @return The higher part of the allowed port range, valid
     * integer value needs to be between 1 and 65535. Changing this creates a new
     * security group rule.
     * 
     */
    public Optional<Output<Integer>> portRangeMax() {
        return Optional.ofNullable(this.portRangeMax);
    }

    /**
     * The lower part of the allowed port range, valid
     * integer value needs to be between 1 and 65535. Changing this creates a new
     * security group rule.
     * 
     */
    @Import(name="portRangeMin")
    private @Nullable Output<Integer> portRangeMin;

    /**
     * @return The lower part of the allowed port range, valid
     * integer value needs to be between 1 and 65535. Changing this creates a new
     * security group rule.
     * 
     */
    public Optional<Output<Integer>> portRangeMin() {
        return Optional.ofNullable(this.portRangeMin);
    }

    /**
     * The layer 4 protocol type, valid values are following. Changing this creates a new security group rule. This is required if you want to specify a port range.
     * * __tcp__
     * * __udp__
     * * __icmp__
     * * __ah__
     * * __dccp__
     * * __egp__
     * * __esp__
     * * __gre__
     * * __igmp__
     * * __ipv6-encap__
     * * __ipv6-frag__
     * * __ipv6-icmp__
     * * __ipv6-nonxt__
     * * __ipv6-opts__
     * * __ipv6-route__
     * * __ospf__
     * * __pgm__
     * * __rsvp__
     * * __sctp__
     * * __udplite__
     * * __vrrp__
     * 
     */
    @Import(name="protocol")
    private @Nullable Output<String> protocol;

    /**
     * @return The layer 4 protocol type, valid values are following. Changing this creates a new security group rule. This is required if you want to specify a port range.
     * * __tcp__
     * * __udp__
     * * __icmp__
     * * __ah__
     * * __dccp__
     * * __egp__
     * * __esp__
     * * __gre__
     * * __igmp__
     * * __ipv6-encap__
     * * __ipv6-frag__
     * * __ipv6-icmp__
     * * __ipv6-nonxt__
     * * __ipv6-opts__
     * * __ipv6-route__
     * * __ospf__
     * * __pgm__
     * * __rsvp__
     * * __sctp__
     * * __udplite__
     * * __vrrp__
     * 
     */
    public Optional<Output<String>> protocol() {
        return Optional.ofNullable(this.protocol);
    }

    /**
     * The region in which to obtain the V2 networking client.
     * A networking client is needed to create a port. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * security group rule.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 networking client.
     * A networking client is needed to create a port. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * security group rule.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The remote group id, the value needs to be an
     * Openstack ID of a security group in the same tenant. Changing this creates
     * a new security group rule.
     * 
     */
    @Import(name="remoteGroupId")
    private @Nullable Output<String> remoteGroupId;

    /**
     * @return The remote group id, the value needs to be an
     * Openstack ID of a security group in the same tenant. Changing this creates
     * a new security group rule.
     * 
     */
    public Optional<Output<String>> remoteGroupId() {
        return Optional.ofNullable(this.remoteGroupId);
    }

    /**
     * The remote CIDR, the value needs to be a valid
     * CIDR (i.e. 192.168.0.0/16). Changing this creates a new security group rule.
     * 
     */
    @Import(name="remoteIpPrefix")
    private @Nullable Output<String> remoteIpPrefix;

    /**
     * @return The remote CIDR, the value needs to be a valid
     * CIDR (i.e. 192.168.0.0/16). Changing this creates a new security group rule.
     * 
     */
    public Optional<Output<String>> remoteIpPrefix() {
        return Optional.ofNullable(this.remoteIpPrefix);
    }

    /**
     * The security group id the rule should belong
     * to, the value needs to be an Openstack ID of a security group in the same
     * tenant. Changing this creates a new security group rule.
     * 
     */
    @Import(name="securityGroupId", required=true)
    private Output<String> securityGroupId;

    /**
     * @return The security group id the rule should belong
     * to, the value needs to be an Openstack ID of a security group in the same
     * tenant. Changing this creates a new security group rule.
     * 
     */
    public Output<String> securityGroupId() {
        return this.securityGroupId;
    }

    /**
     * The owner of the security group. Required if admin
     * wants to create a port for another tenant. Changing this creates a new
     * security group rule.
     * 
     */
    @Import(name="tenantId")
    private @Nullable Output<String> tenantId;

    /**
     * @return The owner of the security group. Required if admin
     * wants to create a port for another tenant. Changing this creates a new
     * security group rule.
     * 
     */
    public Optional<Output<String>> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    private SecGroupRuleArgs() {}

    private SecGroupRuleArgs(SecGroupRuleArgs $) {
        this.description = $.description;
        this.direction = $.direction;
        this.ethertype = $.ethertype;
        this.portRangeMax = $.portRangeMax;
        this.portRangeMin = $.portRangeMin;
        this.protocol = $.protocol;
        this.region = $.region;
        this.remoteGroupId = $.remoteGroupId;
        this.remoteIpPrefix = $.remoteIpPrefix;
        this.securityGroupId = $.securityGroupId;
        this.tenantId = $.tenantId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SecGroupRuleArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SecGroupRuleArgs $;

        public Builder() {
            $ = new SecGroupRuleArgs();
        }

        public Builder(SecGroupRuleArgs defaults) {
            $ = new SecGroupRuleArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description A description of the rule. Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description of the rule. Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param direction The direction of the rule, valid values are __ingress__
         * or __egress__. Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder direction(Output<String> direction) {
            $.direction = direction;
            return this;
        }

        /**
         * @param direction The direction of the rule, valid values are __ingress__
         * or __egress__. Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder direction(String direction) {
            return direction(Output.of(direction));
        }

        /**
         * @param ethertype The layer 3 protocol type, valid values are __IPv4__
         * or __IPv6__. Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder ethertype(Output<String> ethertype) {
            $.ethertype = ethertype;
            return this;
        }

        /**
         * @param ethertype The layer 3 protocol type, valid values are __IPv4__
         * or __IPv6__. Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder ethertype(String ethertype) {
            return ethertype(Output.of(ethertype));
        }

        /**
         * @param portRangeMax The higher part of the allowed port range, valid
         * integer value needs to be between 1 and 65535. Changing this creates a new
         * security group rule.
         * 
         * @return builder
         * 
         */
        public Builder portRangeMax(@Nullable Output<Integer> portRangeMax) {
            $.portRangeMax = portRangeMax;
            return this;
        }

        /**
         * @param portRangeMax The higher part of the allowed port range, valid
         * integer value needs to be between 1 and 65535. Changing this creates a new
         * security group rule.
         * 
         * @return builder
         * 
         */
        public Builder portRangeMax(Integer portRangeMax) {
            return portRangeMax(Output.of(portRangeMax));
        }

        /**
         * @param portRangeMin The lower part of the allowed port range, valid
         * integer value needs to be between 1 and 65535. Changing this creates a new
         * security group rule.
         * 
         * @return builder
         * 
         */
        public Builder portRangeMin(@Nullable Output<Integer> portRangeMin) {
            $.portRangeMin = portRangeMin;
            return this;
        }

        /**
         * @param portRangeMin The lower part of the allowed port range, valid
         * integer value needs to be between 1 and 65535. Changing this creates a new
         * security group rule.
         * 
         * @return builder
         * 
         */
        public Builder portRangeMin(Integer portRangeMin) {
            return portRangeMin(Output.of(portRangeMin));
        }

        /**
         * @param protocol The layer 4 protocol type, valid values are following. Changing this creates a new security group rule. This is required if you want to specify a port range.
         * * __tcp__
         * * __udp__
         * * __icmp__
         * * __ah__
         * * __dccp__
         * * __egp__
         * * __esp__
         * * __gre__
         * * __igmp__
         * * __ipv6-encap__
         * * __ipv6-frag__
         * * __ipv6-icmp__
         * * __ipv6-nonxt__
         * * __ipv6-opts__
         * * __ipv6-route__
         * * __ospf__
         * * __pgm__
         * * __rsvp__
         * * __sctp__
         * * __udplite__
         * * __vrrp__
         * 
         * @return builder
         * 
         */
        public Builder protocol(@Nullable Output<String> protocol) {
            $.protocol = protocol;
            return this;
        }

        /**
         * @param protocol The layer 4 protocol type, valid values are following. Changing this creates a new security group rule. This is required if you want to specify a port range.
         * * __tcp__
         * * __udp__
         * * __icmp__
         * * __ah__
         * * __dccp__
         * * __egp__
         * * __esp__
         * * __gre__
         * * __igmp__
         * * __ipv6-encap__
         * * __ipv6-frag__
         * * __ipv6-icmp__
         * * __ipv6-nonxt__
         * * __ipv6-opts__
         * * __ipv6-route__
         * * __ospf__
         * * __pgm__
         * * __rsvp__
         * * __sctp__
         * * __udplite__
         * * __vrrp__
         * 
         * @return builder
         * 
         */
        public Builder protocol(String protocol) {
            return protocol(Output.of(protocol));
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to create a port. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * security group rule.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to create a port. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * security group rule.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param remoteGroupId The remote group id, the value needs to be an
         * Openstack ID of a security group in the same tenant. Changing this creates
         * a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder remoteGroupId(@Nullable Output<String> remoteGroupId) {
            $.remoteGroupId = remoteGroupId;
            return this;
        }

        /**
         * @param remoteGroupId The remote group id, the value needs to be an
         * Openstack ID of a security group in the same tenant. Changing this creates
         * a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder remoteGroupId(String remoteGroupId) {
            return remoteGroupId(Output.of(remoteGroupId));
        }

        /**
         * @param remoteIpPrefix The remote CIDR, the value needs to be a valid
         * CIDR (i.e. 192.168.0.0/16). Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder remoteIpPrefix(@Nullable Output<String> remoteIpPrefix) {
            $.remoteIpPrefix = remoteIpPrefix;
            return this;
        }

        /**
         * @param remoteIpPrefix The remote CIDR, the value needs to be a valid
         * CIDR (i.e. 192.168.0.0/16). Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder remoteIpPrefix(String remoteIpPrefix) {
            return remoteIpPrefix(Output.of(remoteIpPrefix));
        }

        /**
         * @param securityGroupId The security group id the rule should belong
         * to, the value needs to be an Openstack ID of a security group in the same
         * tenant. Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupId(Output<String> securityGroupId) {
            $.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * @param securityGroupId The security group id the rule should belong
         * to, the value needs to be an Openstack ID of a security group in the same
         * tenant. Changing this creates a new security group rule.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupId(String securityGroupId) {
            return securityGroupId(Output.of(securityGroupId));
        }

        /**
         * @param tenantId The owner of the security group. Required if admin
         * wants to create a port for another tenant. Changing this creates a new
         * security group rule.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(@Nullable Output<String> tenantId) {
            $.tenantId = tenantId;
            return this;
        }

        /**
         * @param tenantId The owner of the security group. Required if admin
         * wants to create a port for another tenant. Changing this creates a new
         * security group rule.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(String tenantId) {
            return tenantId(Output.of(tenantId));
        }

        public SecGroupRuleArgs build() {
            if ($.direction == null) {
                throw new MissingRequiredPropertyException("SecGroupRuleArgs", "direction");
            }
            if ($.ethertype == null) {
                throw new MissingRequiredPropertyException("SecGroupRuleArgs", "ethertype");
            }
            if ($.securityGroupId == null) {
                throw new MissingRequiredPropertyException("SecGroupRuleArgs", "securityGroupId");
            }
            return $;
        }
    }

}
