// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.networking.SubnetPoolArgs;
import com.pulumi.openstack.networking.inputs.SubnetPoolState;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a V2 Neutron subnetpool resource within OpenStack.
 * 
 * ## Example Usage
 * ### Create a Subnet Pool
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.SubnetPool;
 * import com.pulumi.openstack.networking.SubnetPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var subnetpool1 = new SubnetPool(&#34;subnetpool1&#34;, SubnetPoolArgs.builder()        
 *             .ipVersion(6)
 *             .prefixes(            
 *                 &#34;fdf7:b13d:dead:beef::/64&#34;,
 *                 &#34;fd65:86cc:a334:39b7::/64&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Create a Subnet from a Subnet Pool
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.Network;
 * import com.pulumi.openstack.networking.NetworkArgs;
 * import com.pulumi.openstack.networking.SubnetPool;
 * import com.pulumi.openstack.networking.SubnetPoolArgs;
 * import com.pulumi.openstack.networking.Subnet;
 * import com.pulumi.openstack.networking.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var network1 = new Network(&#34;network1&#34;, NetworkArgs.builder()        
 *             .adminStateUp(&#34;true&#34;)
 *             .build());
 * 
 *         var subnetpool1 = new SubnetPool(&#34;subnetpool1&#34;, SubnetPoolArgs.builder()        
 *             .prefixes(&#34;10.11.12.0/24&#34;)
 *             .build());
 * 
 *         var subnet1 = new Subnet(&#34;subnet1&#34;, SubnetArgs.builder()        
 *             .cidr(&#34;10.11.12.0/25&#34;)
 *             .networkId(network1.id())
 *             .subnetpoolId(subnetpool1.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Subnetpools can be imported using the `id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:networking/subnetPool:SubnetPool subnetpool_1 832cb7f3-59fe-40cf-8f64-8350ffc03272
 * ```
 * 
 */
@ResourceType(type="openstack:networking/subnetPool:SubnetPool")
public class SubnetPool extends com.pulumi.resources.CustomResource {
    /**
     * The Neutron address scope to assign to the
     * subnetpool. Changing this updates the address scope id of the existing
     * subnetpool.
     * 
     */
    @Export(name="addressScopeId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> addressScopeId;

    /**
     * @return The Neutron address scope to assign to the
     * subnetpool. Changing this updates the address scope id of the existing
     * subnetpool.
     * 
     */
    public Output<Optional<String>> addressScopeId() {
        return Codegen.optional(this.addressScopeId);
    }
    /**
     * The collection of tags assigned on the subnetpool, which have been
     * explicitly and implicitly added.
     * 
     */
    @Export(name="allTags", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> allTags;

    /**
     * @return The collection of tags assigned on the subnetpool, which have been
     * explicitly and implicitly added.
     * 
     */
    public Output<List<String>> allTags() {
        return this.allTags;
    }
    /**
     * The time at which subnetpool was created.
     * 
     */
    @Export(name="createdAt", refs={String.class}, tree="[0]")
    private Output<String> createdAt;

    /**
     * @return The time at which subnetpool was created.
     * 
     */
    public Output<String> createdAt() {
        return this.createdAt;
    }
    /**
     * The size of the prefix to allocate when the cidr
     * or prefixlen attributes are omitted when you create the subnet. Defaults to the
     * MinPrefixLen. Changing this updates the default prefixlen of the existing
     * subnetpool.
     * 
     */
    @Export(name="defaultPrefixlen", refs={Integer.class}, tree="[0]")
    private Output<Integer> defaultPrefixlen;

    /**
     * @return The size of the prefix to allocate when the cidr
     * or prefixlen attributes are omitted when you create the subnet. Defaults to the
     * MinPrefixLen. Changing this updates the default prefixlen of the existing
     * subnetpool.
     * 
     */
    public Output<Integer> defaultPrefixlen() {
        return this.defaultPrefixlen;
    }
    /**
     * The per-project quota on the prefix space that can be
     * allocated from the subnetpool for project subnets. Changing this updates the
     * default quota of the existing subnetpool.
     * 
     */
    @Export(name="defaultQuota", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> defaultQuota;

    /**
     * @return The per-project quota on the prefix space that can be
     * allocated from the subnetpool for project subnets. Changing this updates the
     * default quota of the existing subnetpool.
     * 
     */
    public Output<Optional<Integer>> defaultQuota() {
        return Codegen.optional(this.defaultQuota);
    }
    /**
     * The human-readable description for the subnetpool.
     * Changing this updates the description of the existing subnetpool.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return The human-readable description for the subnetpool.
     * Changing this updates the description of the existing subnetpool.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The IP protocol version.
     * 
     */
    @Export(name="ipVersion", refs={Integer.class}, tree="[0]")
    private Output<Integer> ipVersion;

    /**
     * @return The IP protocol version.
     * 
     */
    public Output<Integer> ipVersion() {
        return this.ipVersion;
    }
    /**
     * Indicates whether the subnetpool is default
     * subnetpool or not. Changing this updates the default status of the existing
     * subnetpool.
     * 
     */
    @Export(name="isDefault", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> isDefault;

    /**
     * @return Indicates whether the subnetpool is default
     * subnetpool or not. Changing this updates the default status of the existing
     * subnetpool.
     * 
     */
    public Output<Optional<Boolean>> isDefault() {
        return Codegen.optional(this.isDefault);
    }
    /**
     * The maximum prefix size that can be allocated from
     * the subnetpool. For IPv4 subnetpools, default is 32. For IPv6 subnetpools,
     * default is 128. Changing this updates the max prefixlen of the existing
     * subnetpool.
     * 
     */
    @Export(name="maxPrefixlen", refs={Integer.class}, tree="[0]")
    private Output<Integer> maxPrefixlen;

    /**
     * @return The maximum prefix size that can be allocated from
     * the subnetpool. For IPv4 subnetpools, default is 32. For IPv6 subnetpools,
     * default is 128. Changing this updates the max prefixlen of the existing
     * subnetpool.
     * 
     */
    public Output<Integer> maxPrefixlen() {
        return this.maxPrefixlen;
    }
    /**
     * The smallest prefix that can be allocated from a
     * subnetpool. For IPv4 subnetpools, default is 8. For IPv6 subnetpools, default
     * is 64. Changing this updates the min prefixlen of the existing subnetpool.
     * 
     */
    @Export(name="minPrefixlen", refs={Integer.class}, tree="[0]")
    private Output<Integer> minPrefixlen;

    /**
     * @return The smallest prefix that can be allocated from a
     * subnetpool. For IPv4 subnetpools, default is 8. For IPv6 subnetpools, default
     * is 64. Changing this updates the min prefixlen of the existing subnetpool.
     * 
     */
    public Output<Integer> minPrefixlen() {
        return this.minPrefixlen;
    }
    /**
     * The name of the subnetpool. Changing this updates the name of
     * the existing subnetpool.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the subnetpool. Changing this updates the name of
     * the existing subnetpool.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * A list of subnet prefixes to assign to the subnetpool.
     * Neutron API merges adjacent prefixes and treats them as a single prefix. Each
     * subnet prefix must be unique among all subnet prefixes in all subnetpools that
     * are associated with the address scope. Changing this updates the prefixes list
     * of the existing subnetpool.
     * 
     */
    @Export(name="prefixes", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> prefixes;

    /**
     * @return A list of subnet prefixes to assign to the subnetpool.
     * Neutron API merges adjacent prefixes and treats them as a single prefix. Each
     * subnet prefix must be unique among all subnet prefixes in all subnetpools that
     * are associated with the address scope. Changing this updates the prefixes list
     * of the existing subnetpool.
     * 
     */
    public Output<List<String>> prefixes() {
        return this.prefixes;
    }
    /**
     * The owner of the subnetpool. Required if admin wants to
     * create a subnetpool for another project. Changing this creates a new subnetpool.
     * 
     */
    @Export(name="projectId", refs={String.class}, tree="[0]")
    private Output<String> projectId;

    /**
     * @return The owner of the subnetpool. Required if admin wants to
     * create a subnetpool for another project. Changing this creates a new subnetpool.
     * 
     */
    public Output<String> projectId() {
        return this.projectId;
    }
    /**
     * The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a Neutron subnetpool. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * subnetpool.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a Neutron subnetpool. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * subnetpool.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * The revision number of the subnetpool.
     * 
     */
    @Export(name="revisionNumber", refs={Integer.class}, tree="[0]")
    private Output<Integer> revisionNumber;

    /**
     * @return The revision number of the subnetpool.
     * 
     */
    public Output<Integer> revisionNumber() {
        return this.revisionNumber;
    }
    /**
     * Indicates whether this subnetpool is shared across
     * all projects. Changing this updates the shared status of the existing
     * subnetpool.
     * 
     */
    @Export(name="shared", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> shared;

    /**
     * @return Indicates whether this subnetpool is shared across
     * all projects. Changing this updates the shared status of the existing
     * subnetpool.
     * 
     */
    public Output<Optional<Boolean>> shared() {
        return Codegen.optional(this.shared);
    }
    /**
     * A set of string tags for the subnetpool.
     * 
     */
    @Export(name="tags", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tags;

    /**
     * @return A set of string tags for the subnetpool.
     * 
     */
    public Output<Optional<List<String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * The time at which subnetpool was created.
     * 
     */
    @Export(name="updatedAt", refs={String.class}, tree="[0]")
    private Output<String> updatedAt;

    /**
     * @return The time at which subnetpool was created.
     * 
     */
    public Output<String> updatedAt() {
        return this.updatedAt;
    }
    /**
     * Map of additional options.
     * 
     */
    @Export(name="valueSpecs", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional options.
     * 
     */
    public Output<Optional<Map<String,Object>>> valueSpecs() {
        return Codegen.optional(this.valueSpecs);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SubnetPool(String name) {
        this(name, SubnetPoolArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SubnetPool(String name, SubnetPoolArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SubnetPool(String name, SubnetPoolArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/subnetPool:SubnetPool", name, args == null ? SubnetPoolArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SubnetPool(String name, Output<String> id, @Nullable SubnetPoolState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:networking/subnetPool:SubnetPool", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SubnetPool get(String name, Output<String> id, @Nullable SubnetPoolState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SubnetPool(name, id, state, options);
    }
}
