// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SubnetRouteArgs extends com.pulumi.resources.ResourceArgs {

    public static final SubnetRouteArgs Empty = new SubnetRouteArgs();

    /**
     * CIDR block to match on the packet’s destination IP. Changing
     * this creates a new routing entry.
     * 
     */
    @Import(name="destinationCidr", required=true)
    private Output<String> destinationCidr;

    /**
     * @return CIDR block to match on the packet’s destination IP. Changing
     * this creates a new routing entry.
     * 
     */
    public Output<String> destinationCidr() {
        return this.destinationCidr;
    }

    /**
     * IP address of the next hop gateway.  Changing
     * this creates a new routing entry.
     * 
     */
    @Import(name="nextHop", required=true)
    private Output<String> nextHop;

    /**
     * @return IP address of the next hop gateway.  Changing
     * this creates a new routing entry.
     * 
     */
    public Output<String> nextHop() {
        return this.nextHop;
    }

    /**
     * The region in which to obtain the V2 networking client.
     * A networking client is needed to configure a routing entry on a subnet. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * routing entry.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 networking client.
     * A networking client is needed to configure a routing entry on a subnet. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * routing entry.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * ID of the subnet this routing entry belongs to. Changing
     * this creates a new routing entry.
     * 
     */
    @Import(name="subnetId", required=true)
    private Output<String> subnetId;

    /**
     * @return ID of the subnet this routing entry belongs to. Changing
     * this creates a new routing entry.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }

    private SubnetRouteArgs() {}

    private SubnetRouteArgs(SubnetRouteArgs $) {
        this.destinationCidr = $.destinationCidr;
        this.nextHop = $.nextHop;
        this.region = $.region;
        this.subnetId = $.subnetId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SubnetRouteArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SubnetRouteArgs $;

        public Builder() {
            $ = new SubnetRouteArgs();
        }

        public Builder(SubnetRouteArgs defaults) {
            $ = new SubnetRouteArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param destinationCidr CIDR block to match on the packet’s destination IP. Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder destinationCidr(Output<String> destinationCidr) {
            $.destinationCidr = destinationCidr;
            return this;
        }

        /**
         * @param destinationCidr CIDR block to match on the packet’s destination IP. Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder destinationCidr(String destinationCidr) {
            return destinationCidr(Output.of(destinationCidr));
        }

        /**
         * @param nextHop IP address of the next hop gateway.  Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder nextHop(Output<String> nextHop) {
            $.nextHop = nextHop;
            return this;
        }

        /**
         * @param nextHop IP address of the next hop gateway.  Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder nextHop(String nextHop) {
            return nextHop(Output.of(nextHop));
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to configure a routing entry on a subnet. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * routing entry.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 networking client.
         * A networking client is needed to configure a routing entry on a subnet. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * routing entry.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param subnetId ID of the subnet this routing entry belongs to. Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId ID of the subnet this routing entry belongs to. Changing
         * this creates a new routing entry.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        public SubnetRouteArgs build() {
            if ($.destinationCidr == null) {
                throw new MissingRequiredPropertyException("SubnetRouteArgs", "destinationCidr");
            }
            if ($.nextHop == null) {
                throw new MissingRequiredPropertyException("SubnetRouteArgs", "nextHop");
            }
            if ($.subnetId == null) {
                throw new MissingRequiredPropertyException("SubnetRouteArgs", "subnetId");
            }
            return $;
        }
    }

}
