// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.networking.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class FloatingIpState extends com.pulumi.resources.ResourceArgs {

    public static final FloatingIpState Empty = new FloatingIpState();

    /**
     * The actual/specific floating IP to obtain. By default,
     * non-admin users are not able to specify a floating IP, so you must either be
     * an admin user or have had a custom policy or role applied to your OpenStack
     * user or project.
     * 
     */
    @Import(name="address")
    private @Nullable Output<String> address;

    /**
     * @return The actual/specific floating IP to obtain. By default,
     * non-admin users are not able to specify a floating IP, so you must either be
     * an admin user or have had a custom policy or role applied to your OpenStack
     * user or project.
     * 
     */
    public Optional<Output<String>> address() {
        return Optional.ofNullable(this.address);
    }

    /**
     * The collection of tags assigned on the floating IP, which have
     * been explicitly and implicitly added.
     * 
     */
    @Import(name="allTags")
    private @Nullable Output<List<String>> allTags;

    /**
     * @return The collection of tags assigned on the floating IP, which have
     * been explicitly and implicitly added.
     * 
     */
    public Optional<Output<List<String>>> allTags() {
        return Optional.ofNullable(this.allTags);
    }

    /**
     * Human-readable description for the floating IP.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Human-readable description for the floating IP.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The floating IP DNS domain. Available, when Neutron
     * DNS extension is enabled. The data in this attribute will be published in an
     * external DNS service when Neutron is configured to integrate with such a
     * service. Changing this creates a new floating IP.
     * 
     */
    @Import(name="dnsDomain")
    private @Nullable Output<String> dnsDomain;

    /**
     * @return The floating IP DNS domain. Available, when Neutron
     * DNS extension is enabled. The data in this attribute will be published in an
     * external DNS service when Neutron is configured to integrate with such a
     * service. Changing this creates a new floating IP.
     * 
     */
    public Optional<Output<String>> dnsDomain() {
        return Optional.ofNullable(this.dnsDomain);
    }

    /**
     * The floating IP DNS name. Available, when Neutron DNS
     * extension is enabled. The data in this attribute will be published in an
     * external DNS service when Neutron is configured to integrate with such a
     * service. Changing this creates a new floating IP.
     * 
     */
    @Import(name="dnsName")
    private @Nullable Output<String> dnsName;

    /**
     * @return The floating IP DNS name. Available, when Neutron DNS
     * extension is enabled. The data in this attribute will be published in an
     * external DNS service when Neutron is configured to integrate with such a
     * service. Changing this creates a new floating IP.
     * 
     */
    public Optional<Output<String>> dnsName() {
        return Optional.ofNullable(this.dnsName);
    }

    /**
     * Fixed IP of the port to associate with this floating IP. Required if
     * the port has multiple fixed IPs.
     * 
     */
    @Import(name="fixedIp")
    private @Nullable Output<String> fixedIp;

    /**
     * @return Fixed IP of the port to associate with this floating IP. Required if
     * the port has multiple fixed IPs.
     * 
     */
    public Optional<Output<String>> fixedIp() {
        return Optional.ofNullable(this.fixedIp);
    }

    /**
     * The name of the pool from which to obtain the floating
     * IP. Changing this creates a new floating IP.
     * 
     */
    @Import(name="pool")
    private @Nullable Output<String> pool;

    /**
     * @return The name of the pool from which to obtain the floating
     * IP. Changing this creates a new floating IP.
     * 
     */
    public Optional<Output<String>> pool() {
        return Optional.ofNullable(this.pool);
    }

    /**
     * ID of an existing port with at least one IP address to
     * associate with this floating IP.
     * 
     */
    @Import(name="portId")
    private @Nullable Output<String> portId;

    /**
     * @return ID of an existing port with at least one IP address to
     * associate with this floating IP.
     * 
     */
    public Optional<Output<String>> portId() {
        return Optional.ofNullable(this.portId);
    }

    /**
     * The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a floating IP that can be used with
     * another networking resource, such as a load balancer. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * floating IP (which may or may not have a different address).
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a floating IP that can be used with
     * another networking resource, such as a load balancer. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * floating IP (which may or may not have a different address).
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The subnet ID of the floating IP pool. Specify this if
     * the floating IP network has multiple subnets.
     * 
     */
    @Import(name="subnetId")
    private @Nullable Output<String> subnetId;

    /**
     * @return The subnet ID of the floating IP pool. Specify this if
     * the floating IP network has multiple subnets.
     * 
     */
    public Optional<Output<String>> subnetId() {
        return Optional.ofNullable(this.subnetId);
    }

    /**
     * A list of external subnet IDs to try over each to
     * allocate a floating IP address. If a subnet ID in a list has exhausted
     * floating IP pool, the next subnet ID will be tried. This argument is used only
     * during the resource creation. Conflicts with a `subnet_id` argument.
     * 
     */
    @Import(name="subnetIds")
    private @Nullable Output<List<String>> subnetIds;

    /**
     * @return A list of external subnet IDs to try over each to
     * allocate a floating IP address. If a subnet ID in a list has exhausted
     * floating IP pool, the next subnet ID will be tried. This argument is used only
     * during the resource creation. Conflicts with a `subnet_id` argument.
     * 
     */
    public Optional<Output<List<String>>> subnetIds() {
        return Optional.ofNullable(this.subnetIds);
    }

    /**
     * A set of string tags for the floating IP.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<List<String>> tags;

    /**
     * @return A set of string tags for the floating IP.
     * 
     */
    public Optional<Output<List<String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The target tenant ID in which to allocate the floating
     * IP, if you specify this together with a port_id, make sure the target port
     * belongs to the same tenant. Changing this creates a new floating IP (which
     * may or may not have a different address)
     * 
     */
    @Import(name="tenantId")
    private @Nullable Output<String> tenantId;

    /**
     * @return The target tenant ID in which to allocate the floating
     * IP, if you specify this together with a port_id, make sure the target port
     * belongs to the same tenant. Changing this creates a new floating IP (which
     * may or may not have a different address)
     * 
     */
    public Optional<Output<String>> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    /**
     * Map of additional options.
     * 
     */
    @Import(name="valueSpecs")
    private @Nullable Output<Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional options.
     * 
     */
    public Optional<Output<Map<String,Object>>> valueSpecs() {
        return Optional.ofNullable(this.valueSpecs);
    }

    private FloatingIpState() {}

    private FloatingIpState(FloatingIpState $) {
        this.address = $.address;
        this.allTags = $.allTags;
        this.description = $.description;
        this.dnsDomain = $.dnsDomain;
        this.dnsName = $.dnsName;
        this.fixedIp = $.fixedIp;
        this.pool = $.pool;
        this.portId = $.portId;
        this.region = $.region;
        this.subnetId = $.subnetId;
        this.subnetIds = $.subnetIds;
        this.tags = $.tags;
        this.tenantId = $.tenantId;
        this.valueSpecs = $.valueSpecs;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(FloatingIpState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FloatingIpState $;

        public Builder() {
            $ = new FloatingIpState();
        }

        public Builder(FloatingIpState defaults) {
            $ = new FloatingIpState(Objects.requireNonNull(defaults));
        }

        /**
         * @param address The actual/specific floating IP to obtain. By default,
         * non-admin users are not able to specify a floating IP, so you must either be
         * an admin user or have had a custom policy or role applied to your OpenStack
         * user or project.
         * 
         * @return builder
         * 
         */
        public Builder address(@Nullable Output<String> address) {
            $.address = address;
            return this;
        }

        /**
         * @param address The actual/specific floating IP to obtain. By default,
         * non-admin users are not able to specify a floating IP, so you must either be
         * an admin user or have had a custom policy or role applied to your OpenStack
         * user or project.
         * 
         * @return builder
         * 
         */
        public Builder address(String address) {
            return address(Output.of(address));
        }

        /**
         * @param allTags The collection of tags assigned on the floating IP, which have
         * been explicitly and implicitly added.
         * 
         * @return builder
         * 
         */
        public Builder allTags(@Nullable Output<List<String>> allTags) {
            $.allTags = allTags;
            return this;
        }

        /**
         * @param allTags The collection of tags assigned on the floating IP, which have
         * been explicitly and implicitly added.
         * 
         * @return builder
         * 
         */
        public Builder allTags(List<String> allTags) {
            return allTags(Output.of(allTags));
        }

        /**
         * @param allTags The collection of tags assigned on the floating IP, which have
         * been explicitly and implicitly added.
         * 
         * @return builder
         * 
         */
        public Builder allTags(String... allTags) {
            return allTags(List.of(allTags));
        }

        /**
         * @param description Human-readable description for the floating IP.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Human-readable description for the floating IP.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param dnsDomain The floating IP DNS domain. Available, when Neutron
         * DNS extension is enabled. The data in this attribute will be published in an
         * external DNS service when Neutron is configured to integrate with such a
         * service. Changing this creates a new floating IP.
         * 
         * @return builder
         * 
         */
        public Builder dnsDomain(@Nullable Output<String> dnsDomain) {
            $.dnsDomain = dnsDomain;
            return this;
        }

        /**
         * @param dnsDomain The floating IP DNS domain. Available, when Neutron
         * DNS extension is enabled. The data in this attribute will be published in an
         * external DNS service when Neutron is configured to integrate with such a
         * service. Changing this creates a new floating IP.
         * 
         * @return builder
         * 
         */
        public Builder dnsDomain(String dnsDomain) {
            return dnsDomain(Output.of(dnsDomain));
        }

        /**
         * @param dnsName The floating IP DNS name. Available, when Neutron DNS
         * extension is enabled. The data in this attribute will be published in an
         * external DNS service when Neutron is configured to integrate with such a
         * service. Changing this creates a new floating IP.
         * 
         * @return builder
         * 
         */
        public Builder dnsName(@Nullable Output<String> dnsName) {
            $.dnsName = dnsName;
            return this;
        }

        /**
         * @param dnsName The floating IP DNS name. Available, when Neutron DNS
         * extension is enabled. The data in this attribute will be published in an
         * external DNS service when Neutron is configured to integrate with such a
         * service. Changing this creates a new floating IP.
         * 
         * @return builder
         * 
         */
        public Builder dnsName(String dnsName) {
            return dnsName(Output.of(dnsName));
        }

        /**
         * @param fixedIp Fixed IP of the port to associate with this floating IP. Required if
         * the port has multiple fixed IPs.
         * 
         * @return builder
         * 
         */
        public Builder fixedIp(@Nullable Output<String> fixedIp) {
            $.fixedIp = fixedIp;
            return this;
        }

        /**
         * @param fixedIp Fixed IP of the port to associate with this floating IP. Required if
         * the port has multiple fixed IPs.
         * 
         * @return builder
         * 
         */
        public Builder fixedIp(String fixedIp) {
            return fixedIp(Output.of(fixedIp));
        }

        /**
         * @param pool The name of the pool from which to obtain the floating
         * IP. Changing this creates a new floating IP.
         * 
         * @return builder
         * 
         */
        public Builder pool(@Nullable Output<String> pool) {
            $.pool = pool;
            return this;
        }

        /**
         * @param pool The name of the pool from which to obtain the floating
         * IP. Changing this creates a new floating IP.
         * 
         * @return builder
         * 
         */
        public Builder pool(String pool) {
            return pool(Output.of(pool));
        }

        /**
         * @param portId ID of an existing port with at least one IP address to
         * associate with this floating IP.
         * 
         * @return builder
         * 
         */
        public Builder portId(@Nullable Output<String> portId) {
            $.portId = portId;
            return this;
        }

        /**
         * @param portId ID of an existing port with at least one IP address to
         * associate with this floating IP.
         * 
         * @return builder
         * 
         */
        public Builder portId(String portId) {
            return portId(Output.of(portId));
        }

        /**
         * @param region The region in which to obtain the V2 Networking client.
         * A Networking client is needed to create a floating IP that can be used with
         * another networking resource, such as a load balancer. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * floating IP (which may or may not have a different address).
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Networking client.
         * A Networking client is needed to create a floating IP that can be used with
         * another networking resource, such as a load balancer. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * floating IP (which may or may not have a different address).
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param subnetId The subnet ID of the floating IP pool. Specify this if
         * the floating IP network has multiple subnets.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(@Nullable Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId The subnet ID of the floating IP pool. Specify this if
         * the floating IP network has multiple subnets.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        /**
         * @param subnetIds A list of external subnet IDs to try over each to
         * allocate a floating IP address. If a subnet ID in a list has exhausted
         * floating IP pool, the next subnet ID will be tried. This argument is used only
         * during the resource creation. Conflicts with a `subnet_id` argument.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(@Nullable Output<List<String>> subnetIds) {
            $.subnetIds = subnetIds;
            return this;
        }

        /**
         * @param subnetIds A list of external subnet IDs to try over each to
         * allocate a floating IP address. If a subnet ID in a list has exhausted
         * floating IP pool, the next subnet ID will be tried. This argument is used only
         * during the resource creation. Conflicts with a `subnet_id` argument.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(List<String> subnetIds) {
            return subnetIds(Output.of(subnetIds));
        }

        /**
         * @param subnetIds A list of external subnet IDs to try over each to
         * allocate a floating IP address. If a subnet ID in a list has exhausted
         * floating IP pool, the next subnet ID will be tried. This argument is used only
         * during the resource creation. Conflicts with a `subnet_id` argument.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(String... subnetIds) {
            return subnetIds(List.of(subnetIds));
        }

        /**
         * @param tags A set of string tags for the floating IP.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<List<String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A set of string tags for the floating IP.
         * 
         * @return builder
         * 
         */
        public Builder tags(List<String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tags A set of string tags for the floating IP.
         * 
         * @return builder
         * 
         */
        public Builder tags(String... tags) {
            return tags(List.of(tags));
        }

        /**
         * @param tenantId The target tenant ID in which to allocate the floating
         * IP, if you specify this together with a port_id, make sure the target port
         * belongs to the same tenant. Changing this creates a new floating IP (which
         * may or may not have a different address)
         * 
         * @return builder
         * 
         */
        public Builder tenantId(@Nullable Output<String> tenantId) {
            $.tenantId = tenantId;
            return this;
        }

        /**
         * @param tenantId The target tenant ID in which to allocate the floating
         * IP, if you specify this together with a port_id, make sure the target port
         * belongs to the same tenant. Changing this creates a new floating IP (which
         * may or may not have a different address)
         * 
         * @return builder
         * 
         */
        public Builder tenantId(String tenantId) {
            return tenantId(Output.of(tenantId));
        }

        /**
         * @param valueSpecs Map of additional options.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(@Nullable Output<Map<String,Object>> valueSpecs) {
            $.valueSpecs = valueSpecs;
            return this;
        }

        /**
         * @param valueSpecs Map of additional options.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(Map<String,Object> valueSpecs) {
            return valueSpecs(Output.of(valueSpecs));
        }

        public FloatingIpState build() {
            return $;
        }
    }

}
