// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.objectstorage;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.openstack.objectstorage.inputs.ContainerVersioningLegacyArgs;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ContainerArgs extends com.pulumi.resources.ResourceArgs {

    public static final ContainerArgs Empty = new ContainerArgs();

    /**
     * Sets an access control list (ACL) that grants
     * read access. This header can contain a comma-delimited list of users that
     * can read the container (allows the GET method for all objects in the
     * container). Changing this updates the access control list read access.
     * 
     */
    @Import(name="containerRead")
    private @Nullable Output<String> containerRead;

    /**
     * @return Sets an access control list (ACL) that grants
     * read access. This header can contain a comma-delimited list of users that
     * can read the container (allows the GET method for all objects in the
     * container). Changing this updates the access control list read access.
     * 
     */
    public Optional<Output<String>> containerRead() {
        return Optional.ofNullable(this.containerRead);
    }

    /**
     * The secret key for container synchronization.
     * Changing this updates container synchronization.
     * 
     */
    @Import(name="containerSyncKey")
    private @Nullable Output<String> containerSyncKey;

    /**
     * @return The secret key for container synchronization.
     * Changing this updates container synchronization.
     * 
     */
    public Optional<Output<String>> containerSyncKey() {
        return Optional.ofNullable(this.containerSyncKey);
    }

    /**
     * The destination for container synchronization.
     * Changing this updates container synchronization.
     * 
     */
    @Import(name="containerSyncTo")
    private @Nullable Output<String> containerSyncTo;

    /**
     * @return The destination for container synchronization.
     * Changing this updates container synchronization.
     * 
     */
    public Optional<Output<String>> containerSyncTo() {
        return Optional.ofNullable(this.containerSyncTo);
    }

    /**
     * Sets an ACL that grants write access.
     * Changing this updates the access control list write access.
     * 
     */
    @Import(name="containerWrite")
    private @Nullable Output<String> containerWrite;

    /**
     * @return Sets an ACL that grants write access.
     * Changing this updates the access control list write access.
     * 
     */
    public Optional<Output<String>> containerWrite() {
        return Optional.ofNullable(this.containerWrite);
    }

    /**
     * The MIME type for the container. Changing this
     * updates the MIME type.
     * 
     */
    @Import(name="contentType")
    private @Nullable Output<String> contentType;

    /**
     * @return The MIME type for the container. Changing this
     * updates the MIME type.
     * 
     */
    public Optional<Output<String>> contentType() {
        return Optional.ofNullable(this.contentType);
    }

    /**
     * A boolean that indicates all objects should be deleted from the container so that the container can be destroyed without error. These objects are not recoverable.
     * 
     */
    @Import(name="forceDestroy")
    private @Nullable Output<Boolean> forceDestroy;

    /**
     * @return A boolean that indicates all objects should be deleted from the container so that the container can be destroyed without error. These objects are not recoverable.
     * 
     */
    public Optional<Output<Boolean>> forceDestroy() {
        return Optional.ofNullable(this.forceDestroy);
    }

    /**
     * Custom key/value pairs to associate with the container.
     * Changing this updates the existing container metadata.
     * 
     */
    @Import(name="metadata")
    private @Nullable Output<Map<String,Object>> metadata;

    /**
     * @return Custom key/value pairs to associate with the container.
     * Changing this updates the existing container metadata.
     * 
     */
    public Optional<Output<Map<String,Object>>> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    /**
     * A unique name for the container. Changing this creates a
     * new container.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return A unique name for the container. Changing this creates a
     * new container.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The region in which to create the container. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new container.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to create the container. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new container.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The storage policy to be used for the container.
     * Changing this creates a new container.
     * 
     */
    @Import(name="storagePolicy")
    private @Nullable Output<String> storagePolicy;

    /**
     * @return The storage policy to be used for the container.
     * Changing this creates a new container.
     * 
     */
    public Optional<Output<String>> storagePolicy() {
        return Optional.ofNullable(this.storagePolicy);
    }

    /**
     * A boolean that can enable or disable object
     * versioning. The default value is `false`. To use this feature, your Swift
     * version must be 2.24 or higher (as described in the [OpenStack Swift Ussuri release notes](https://docs.openstack.org/releasenotes/swift/ussuri.html#relnotes-2-24-0-stable-ussuri)),
     * and a cloud administrator must have set the `allow_object_versioning = true`
     * configuration option in Swift. If you cannot set this versioning type, you may
     * want to consider using `versioning_legacy` instead.
     * 
     */
    @Import(name="versioning")
    private @Nullable Output<Boolean> versioning;

    /**
     * @return A boolean that can enable or disable object
     * versioning. The default value is `false`. To use this feature, your Swift
     * version must be 2.24 or higher (as described in the [OpenStack Swift Ussuri release notes](https://docs.openstack.org/releasenotes/swift/ussuri.html#relnotes-2-24-0-stable-ussuri)),
     * and a cloud administrator must have set the `allow_object_versioning = true`
     * configuration option in Swift. If you cannot set this versioning type, you may
     * want to consider using `versioning_legacy` instead.
     * 
     */
    public Optional<Output<Boolean>> versioning() {
        return Optional.ofNullable(this.versioning);
    }

    /**
     * Enable legacy object versioning. The structure is described below.
     * 
     * @deprecated
     * Use newer &#34;versioning&#34; implementation
     * 
     */
    @Deprecated /* Use newer ""versioning"" implementation */
    @Import(name="versioningLegacy")
    private @Nullable Output<ContainerVersioningLegacyArgs> versioningLegacy;

    /**
     * @return Enable legacy object versioning. The structure is described below.
     * 
     * @deprecated
     * Use newer &#34;versioning&#34; implementation
     * 
     */
    @Deprecated /* Use newer ""versioning"" implementation */
    public Optional<Output<ContainerVersioningLegacyArgs>> versioningLegacy() {
        return Optional.ofNullable(this.versioningLegacy);
    }

    private ContainerArgs() {}

    private ContainerArgs(ContainerArgs $) {
        this.containerRead = $.containerRead;
        this.containerSyncKey = $.containerSyncKey;
        this.containerSyncTo = $.containerSyncTo;
        this.containerWrite = $.containerWrite;
        this.contentType = $.contentType;
        this.forceDestroy = $.forceDestroy;
        this.metadata = $.metadata;
        this.name = $.name;
        this.region = $.region;
        this.storagePolicy = $.storagePolicy;
        this.versioning = $.versioning;
        this.versioningLegacy = $.versioningLegacy;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ContainerArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerArgs $;

        public Builder() {
            $ = new ContainerArgs();
        }

        public Builder(ContainerArgs defaults) {
            $ = new ContainerArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param containerRead Sets an access control list (ACL) that grants
         * read access. This header can contain a comma-delimited list of users that
         * can read the container (allows the GET method for all objects in the
         * container). Changing this updates the access control list read access.
         * 
         * @return builder
         * 
         */
        public Builder containerRead(@Nullable Output<String> containerRead) {
            $.containerRead = containerRead;
            return this;
        }

        /**
         * @param containerRead Sets an access control list (ACL) that grants
         * read access. This header can contain a comma-delimited list of users that
         * can read the container (allows the GET method for all objects in the
         * container). Changing this updates the access control list read access.
         * 
         * @return builder
         * 
         */
        public Builder containerRead(String containerRead) {
            return containerRead(Output.of(containerRead));
        }

        /**
         * @param containerSyncKey The secret key for container synchronization.
         * Changing this updates container synchronization.
         * 
         * @return builder
         * 
         */
        public Builder containerSyncKey(@Nullable Output<String> containerSyncKey) {
            $.containerSyncKey = containerSyncKey;
            return this;
        }

        /**
         * @param containerSyncKey The secret key for container synchronization.
         * Changing this updates container synchronization.
         * 
         * @return builder
         * 
         */
        public Builder containerSyncKey(String containerSyncKey) {
            return containerSyncKey(Output.of(containerSyncKey));
        }

        /**
         * @param containerSyncTo The destination for container synchronization.
         * Changing this updates container synchronization.
         * 
         * @return builder
         * 
         */
        public Builder containerSyncTo(@Nullable Output<String> containerSyncTo) {
            $.containerSyncTo = containerSyncTo;
            return this;
        }

        /**
         * @param containerSyncTo The destination for container synchronization.
         * Changing this updates container synchronization.
         * 
         * @return builder
         * 
         */
        public Builder containerSyncTo(String containerSyncTo) {
            return containerSyncTo(Output.of(containerSyncTo));
        }

        /**
         * @param containerWrite Sets an ACL that grants write access.
         * Changing this updates the access control list write access.
         * 
         * @return builder
         * 
         */
        public Builder containerWrite(@Nullable Output<String> containerWrite) {
            $.containerWrite = containerWrite;
            return this;
        }

        /**
         * @param containerWrite Sets an ACL that grants write access.
         * Changing this updates the access control list write access.
         * 
         * @return builder
         * 
         */
        public Builder containerWrite(String containerWrite) {
            return containerWrite(Output.of(containerWrite));
        }

        /**
         * @param contentType The MIME type for the container. Changing this
         * updates the MIME type.
         * 
         * @return builder
         * 
         */
        public Builder contentType(@Nullable Output<String> contentType) {
            $.contentType = contentType;
            return this;
        }

        /**
         * @param contentType The MIME type for the container. Changing this
         * updates the MIME type.
         * 
         * @return builder
         * 
         */
        public Builder contentType(String contentType) {
            return contentType(Output.of(contentType));
        }

        /**
         * @param forceDestroy A boolean that indicates all objects should be deleted from the container so that the container can be destroyed without error. These objects are not recoverable.
         * 
         * @return builder
         * 
         */
        public Builder forceDestroy(@Nullable Output<Boolean> forceDestroy) {
            $.forceDestroy = forceDestroy;
            return this;
        }

        /**
         * @param forceDestroy A boolean that indicates all objects should be deleted from the container so that the container can be destroyed without error. These objects are not recoverable.
         * 
         * @return builder
         * 
         */
        public Builder forceDestroy(Boolean forceDestroy) {
            return forceDestroy(Output.of(forceDestroy));
        }

        /**
         * @param metadata Custom key/value pairs to associate with the container.
         * Changing this updates the existing container metadata.
         * 
         * @return builder
         * 
         */
        public Builder metadata(@Nullable Output<Map<String,Object>> metadata) {
            $.metadata = metadata;
            return this;
        }

        /**
         * @param metadata Custom key/value pairs to associate with the container.
         * Changing this updates the existing container metadata.
         * 
         * @return builder
         * 
         */
        public Builder metadata(Map<String,Object> metadata) {
            return metadata(Output.of(metadata));
        }

        /**
         * @param name A unique name for the container. Changing this creates a
         * new container.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name A unique name for the container. Changing this creates a
         * new container.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param region The region in which to create the container. If
         * omitted, the `region` argument of the provider is used. Changing this
         * creates a new container.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to create the container. If
         * omitted, the `region` argument of the provider is used. Changing this
         * creates a new container.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param storagePolicy The storage policy to be used for the container.
         * Changing this creates a new container.
         * 
         * @return builder
         * 
         */
        public Builder storagePolicy(@Nullable Output<String> storagePolicy) {
            $.storagePolicy = storagePolicy;
            return this;
        }

        /**
         * @param storagePolicy The storage policy to be used for the container.
         * Changing this creates a new container.
         * 
         * @return builder
         * 
         */
        public Builder storagePolicy(String storagePolicy) {
            return storagePolicy(Output.of(storagePolicy));
        }

        /**
         * @param versioning A boolean that can enable or disable object
         * versioning. The default value is `false`. To use this feature, your Swift
         * version must be 2.24 or higher (as described in the [OpenStack Swift Ussuri release notes](https://docs.openstack.org/releasenotes/swift/ussuri.html#relnotes-2-24-0-stable-ussuri)),
         * and a cloud administrator must have set the `allow_object_versioning = true`
         * configuration option in Swift. If you cannot set this versioning type, you may
         * want to consider using `versioning_legacy` instead.
         * 
         * @return builder
         * 
         */
        public Builder versioning(@Nullable Output<Boolean> versioning) {
            $.versioning = versioning;
            return this;
        }

        /**
         * @param versioning A boolean that can enable or disable object
         * versioning. The default value is `false`. To use this feature, your Swift
         * version must be 2.24 or higher (as described in the [OpenStack Swift Ussuri release notes](https://docs.openstack.org/releasenotes/swift/ussuri.html#relnotes-2-24-0-stable-ussuri)),
         * and a cloud administrator must have set the `allow_object_versioning = true`
         * configuration option in Swift. If you cannot set this versioning type, you may
         * want to consider using `versioning_legacy` instead.
         * 
         * @return builder
         * 
         */
        public Builder versioning(Boolean versioning) {
            return versioning(Output.of(versioning));
        }

        /**
         * @param versioningLegacy Enable legacy object versioning. The structure is described below.
         * 
         * @return builder
         * 
         * @deprecated
         * Use newer &#34;versioning&#34; implementation
         * 
         */
        @Deprecated /* Use newer ""versioning"" implementation */
        public Builder versioningLegacy(@Nullable Output<ContainerVersioningLegacyArgs> versioningLegacy) {
            $.versioningLegacy = versioningLegacy;
            return this;
        }

        /**
         * @param versioningLegacy Enable legacy object versioning. The structure is described below.
         * 
         * @return builder
         * 
         * @deprecated
         * Use newer &#34;versioning&#34; implementation
         * 
         */
        @Deprecated /* Use newer ""versioning"" implementation */
        public Builder versioningLegacy(ContainerVersioningLegacyArgs versioningLegacy) {
            return versioningLegacy(Output.of(versioningLegacy));
        }

        public ContainerArgs build() {
            return $;
        }
    }

}
