// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.objectstorage;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.objectstorage.TempUrlArgs;
import com.pulumi.openstack.objectstorage.inputs.TempUrlState;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Use this resource to generate an OpenStack Object Storage temporary URL.
 * 
 * The temporary URL will be valid for as long as TTL is set to (in seconds).
 * Once the URL has expired, it will no longer be valid, but the resource
 * will remain in place. If you wish to automatically regenerate a URL, set
 * the `regenerate` argument to `true`. This will create a new resource with
 * a new ID and URL.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.objectstorage.Container;
 * import com.pulumi.openstack.objectstorage.ContainerArgs;
 * import com.pulumi.openstack.objectstorage.ContainerObject;
 * import com.pulumi.openstack.objectstorage.ContainerObjectArgs;
 * import com.pulumi.openstack.objectstorage.TempUrl;
 * import com.pulumi.openstack.objectstorage.TempUrlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var container1 = new Container(&#34;container1&#34;, ContainerArgs.builder()        
 *             .metadata(Map.of(&#34;Temp-URL-Key&#34;, &#34;testkey&#34;))
 *             .build());
 * 
 *         var object1 = new ContainerObject(&#34;object1&#34;, ContainerObjectArgs.builder()        
 *             .containerName(container1.name())
 *             .content(&#34;Hello, world!&#34;)
 *             .build());
 * 
 *         var objTempurl = new TempUrl(&#34;objTempurl&#34;, TempUrlArgs.builder()        
 *             .container(container1.name())
 *             .object(object1.name())
 *             .method(&#34;post&#34;)
 *             .ttl(20)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="openstack:objectstorage/tempUrl:TempUrl")
public class TempUrl extends com.pulumi.resources.CustomResource {
    /**
     * The container name the object belongs to.
     * 
     */
    @Export(name="container", refs={String.class}, tree="[0]")
    private Output<String> container;

    /**
     * @return The container name the object belongs to.
     * 
     */
    public Output<String> container() {
        return this.container;
    }
    /**
     * The method allowed when accessing this URL.
     * Valid values are `GET`, and `POST`. Default is `GET`.
     * 
     */
    @Export(name="method", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> method;

    /**
     * @return The method allowed when accessing this URL.
     * Valid values are `GET`, and `POST`. Default is `GET`.
     * 
     */
    public Output<Optional<String>> method() {
        return Codegen.optional(this.method);
    }
    /**
     * The object name the tempurl is for.
     * 
     */
    @Export(name="object", refs={String.class}, tree="[0]")
    private Output<String> object;

    /**
     * @return The object name the tempurl is for.
     * 
     */
    public Output<String> object() {
        return this.object;
    }
    /**
     * Whether to automatically regenerate the URL when
     * it has expired. If set to true, this will create a new resource with a new
     * ID and new URL. Defaults to false.
     * 
     */
    @Export(name="regenerate", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> regenerate;

    /**
     * @return Whether to automatically regenerate the URL when
     * it has expired. If set to true, this will create a new resource with a new
     * ID and new URL. Defaults to false.
     * 
     */
    public Output<Optional<Boolean>> regenerate() {
        return Codegen.optional(this.regenerate);
    }
    /**
     * The region the tempurl is located in.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region the tempurl is located in.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    @Export(name="split", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> split;

    public Output<Optional<String>> split() {
        return Codegen.optional(this.split);
    }
    /**
     * The TTL, in seconds, for the URL. For how long it should
     * be valid.
     * 
     */
    @Export(name="ttl", refs={Integer.class}, tree="[0]")
    private Output<Integer> ttl;

    /**
     * @return The TTL, in seconds, for the URL. For how long it should
     * be valid.
     * 
     */
    public Output<Integer> ttl() {
        return this.ttl;
    }
    /**
     * The URL
     * 
     */
    @Export(name="url", refs={String.class}, tree="[0]")
    private Output<String> url;

    /**
     * @return The URL
     * 
     */
    public Output<String> url() {
        return this.url;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public TempUrl(String name) {
        this(name, TempUrlArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public TempUrl(String name, TempUrlArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public TempUrl(String name, TempUrlArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:objectstorage/tempUrl:TempUrl", name, args == null ? TempUrlArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private TempUrl(String name, Output<String> id, @Nullable TempUrlState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:objectstorage/tempUrl:TempUrl", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "url"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static TempUrl get(String name, Output<String> id, @Nullable TempUrlState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new TempUrl(name, id, state, options);
    }
}
