// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.objectstorage;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TempUrlArgs extends com.pulumi.resources.ResourceArgs {

    public static final TempUrlArgs Empty = new TempUrlArgs();

    /**
     * The container name the object belongs to.
     * 
     */
    @Import(name="container", required=true)
    private Output<String> container;

    /**
     * @return The container name the object belongs to.
     * 
     */
    public Output<String> container() {
        return this.container;
    }

    /**
     * The method allowed when accessing this URL.
     * Valid values are `GET`, and `POST`. Default is `GET`.
     * 
     */
    @Import(name="method")
    private @Nullable Output<String> method;

    /**
     * @return The method allowed when accessing this URL.
     * Valid values are `GET`, and `POST`. Default is `GET`.
     * 
     */
    public Optional<Output<String>> method() {
        return Optional.ofNullable(this.method);
    }

    /**
     * The object name the tempurl is for.
     * 
     */
    @Import(name="object", required=true)
    private Output<String> object;

    /**
     * @return The object name the tempurl is for.
     * 
     */
    public Output<String> object() {
        return this.object;
    }

    /**
     * Whether to automatically regenerate the URL when
     * it has expired. If set to true, this will create a new resource with a new
     * ID and new URL. Defaults to false.
     * 
     */
    @Import(name="regenerate")
    private @Nullable Output<Boolean> regenerate;

    /**
     * @return Whether to automatically regenerate the URL when
     * it has expired. If set to true, this will create a new resource with a new
     * ID and new URL. Defaults to false.
     * 
     */
    public Optional<Output<Boolean>> regenerate() {
        return Optional.ofNullable(this.regenerate);
    }

    /**
     * The region the tempurl is located in.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region the tempurl is located in.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    @Import(name="split")
    private @Nullable Output<String> split;

    public Optional<Output<String>> split() {
        return Optional.ofNullable(this.split);
    }

    /**
     * The TTL, in seconds, for the URL. For how long it should
     * be valid.
     * 
     */
    @Import(name="ttl", required=true)
    private Output<Integer> ttl;

    /**
     * @return The TTL, in seconds, for the URL. For how long it should
     * be valid.
     * 
     */
    public Output<Integer> ttl() {
        return this.ttl;
    }

    private TempUrlArgs() {}

    private TempUrlArgs(TempUrlArgs $) {
        this.container = $.container;
        this.method = $.method;
        this.object = $.object;
        this.regenerate = $.regenerate;
        this.region = $.region;
        this.split = $.split;
        this.ttl = $.ttl;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TempUrlArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TempUrlArgs $;

        public Builder() {
            $ = new TempUrlArgs();
        }

        public Builder(TempUrlArgs defaults) {
            $ = new TempUrlArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param container The container name the object belongs to.
         * 
         * @return builder
         * 
         */
        public Builder container(Output<String> container) {
            $.container = container;
            return this;
        }

        /**
         * @param container The container name the object belongs to.
         * 
         * @return builder
         * 
         */
        public Builder container(String container) {
            return container(Output.of(container));
        }

        /**
         * @param method The method allowed when accessing this URL.
         * Valid values are `GET`, and `POST`. Default is `GET`.
         * 
         * @return builder
         * 
         */
        public Builder method(@Nullable Output<String> method) {
            $.method = method;
            return this;
        }

        /**
         * @param method The method allowed when accessing this URL.
         * Valid values are `GET`, and `POST`. Default is `GET`.
         * 
         * @return builder
         * 
         */
        public Builder method(String method) {
            return method(Output.of(method));
        }

        /**
         * @param object The object name the tempurl is for.
         * 
         * @return builder
         * 
         */
        public Builder object(Output<String> object) {
            $.object = object;
            return this;
        }

        /**
         * @param object The object name the tempurl is for.
         * 
         * @return builder
         * 
         */
        public Builder object(String object) {
            return object(Output.of(object));
        }

        /**
         * @param regenerate Whether to automatically regenerate the URL when
         * it has expired. If set to true, this will create a new resource with a new
         * ID and new URL. Defaults to false.
         * 
         * @return builder
         * 
         */
        public Builder regenerate(@Nullable Output<Boolean> regenerate) {
            $.regenerate = regenerate;
            return this;
        }

        /**
         * @param regenerate Whether to automatically regenerate the URL when
         * it has expired. If set to true, this will create a new resource with a new
         * ID and new URL. Defaults to false.
         * 
         * @return builder
         * 
         */
        public Builder regenerate(Boolean regenerate) {
            return regenerate(Output.of(regenerate));
        }

        /**
         * @param region The region the tempurl is located in.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region the tempurl is located in.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        public Builder split(@Nullable Output<String> split) {
            $.split = split;
            return this;
        }

        public Builder split(String split) {
            return split(Output.of(split));
        }

        /**
         * @param ttl The TTL, in seconds, for the URL. For how long it should
         * be valid.
         * 
         * @return builder
         * 
         */
        public Builder ttl(Output<Integer> ttl) {
            $.ttl = ttl;
            return this;
        }

        /**
         * @param ttl The TTL, in seconds, for the URL. For how long it should
         * be valid.
         * 
         * @return builder
         * 
         */
        public Builder ttl(Integer ttl) {
            return ttl(Output.of(ttl));
        }

        public TempUrlArgs build() {
            if ($.container == null) {
                throw new MissingRequiredPropertyException("TempUrlArgs", "container");
            }
            if ($.object == null) {
                throw new MissingRequiredPropertyException("TempUrlArgs", "object");
            }
            if ($.ttl == null) {
                throw new MissingRequiredPropertyException("TempUrlArgs", "ttl");
            }
            return $;
        }
    }

}
