// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.orchestration;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.orchestration.StackV1Args;
import com.pulumi.openstack.orchestration.inputs.StackV1State;
import com.pulumi.openstack.orchestration.outputs.StackV1StackOutput;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a V1 stack resource within OpenStack.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.orchestration.StackV1;
 * import com.pulumi.openstack.orchestration.StackV1Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var stack1 = new StackV1(&#34;stack1&#34;, StackV1Args.builder()        
 *             .disableRollback(true)
 *             .environmentOpts(Map.of(&#34;Bin&#34;, &#34;&#34;&#34;
 * 
 * 
 *             &#34;&#34;&#34;))
 *             .parameters(Map.of(&#34;length&#34;, 4))
 *             .templateOpts(Map.of(&#34;Bin&#34;, &#34;&#34;&#34;
 * heat_template_version: 2013-05-23
 * parameters:
 *   length:
 *     type: number
 * resources:
 *   test_res:
 *     type: OS::Heat::TestResource
 *   random:
 *     type: OS::Heat::RandomString
 *     properties:
 *       length: {get_param: length}
 * 
 *             &#34;&#34;&#34;))
 *             .timeout(30)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * stacks can be imported using the `id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:orchestration/stackV1:StackV1 stack_1 ea257959-eeb1-4c10-8d33-26f0409a755d
 * ```
 * 
 */
@ResourceType(type="openstack:orchestration/stackV1:StackV1")
public class StackV1 extends com.pulumi.resources.CustomResource {
    /**
     * A list of stack outputs.
     * 
     */
    @Export(name="StackOutputs", refs={List.class,StackV1StackOutput.class}, tree="[0,1]")
    private Output<List<StackV1StackOutput>> StackOutputs;

    /**
     * @return A list of stack outputs.
     * 
     */
    public Output<List<StackV1StackOutput>> StackOutputs() {
        return this.StackOutputs;
    }
    /**
     * List of stack capabilities for stack.
     * 
     */
    @Export(name="capabilities", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> capabilities;

    /**
     * @return List of stack capabilities for stack.
     * 
     */
    public Output<List<String>> capabilities() {
        return this.capabilities;
    }
    /**
     * The date and time when the resource was created. The date
     * and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
     * For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
     * is the time zone as an offset from UTC.
     * 
     */
    @Export(name="creationTime", refs={String.class}, tree="[0]")
    private Output<String> creationTime;

    /**
     * @return The date and time when the resource was created. The date
     * and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
     * For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
     * is the time zone as an offset from UTC.
     * 
     */
    public Output<String> creationTime() {
        return this.creationTime;
    }
    /**
     * The description of the stack resource.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output<String> description;

    /**
     * @return The description of the stack resource.
     * 
     */
    public Output<String> description() {
        return this.description;
    }
    /**
     * Enables or disables deletion of all stack
     * resources when a stack creation fails. Default is true, meaning all
     * resources are not deleted when stack creation fails.
     * 
     */
    @Export(name="disableRollback", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> disableRollback;

    /**
     * @return Enables or disables deletion of all stack
     * resources when a stack creation fails. Default is true, meaning all
     * resources are not deleted when stack creation fails.
     * 
     */
    public Output<Boolean> disableRollback() {
        return this.disableRollback;
    }
    /**
     * Environment key/value pairs to associate with
     * the stack which contains details for the environment of the stack.
     * Allowed keys: Bin, URL, Files. Changing this updates the existing stack
     * Environment Opts.
     * 
     */
    @Export(name="environmentOpts", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Object>> environmentOpts;

    /**
     * @return Environment key/value pairs to associate with
     * the stack which contains details for the environment of the stack.
     * Allowed keys: Bin, URL, Files. Changing this updates the existing stack
     * Environment Opts.
     * 
     */
    public Output<Optional<Map<String,Object>>> environmentOpts() {
        return Codegen.optional(this.environmentOpts);
    }
    /**
     * A unique name for the stack. It must start with an
     * alphabetic character. Changing this updates the stack&#39;s name.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return A unique name for the stack. It must start with an
     * alphabetic character. Changing this updates the stack&#39;s name.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * List of notification topics for stack.
     * 
     */
    @Export(name="notificationTopics", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> notificationTopics;

    /**
     * @return List of notification topics for stack.
     * 
     */
    public Output<List<String>> notificationTopics() {
        return this.notificationTopics;
    }
    /**
     * User-defined key/value pairs as parameters to pass
     * to the template. Changing this updates the existing stack parameters.
     * 
     */
    @Export(name="parameters", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Object>> parameters;

    /**
     * @return User-defined key/value pairs as parameters to pass
     * to the template. Changing this updates the existing stack parameters.
     * 
     */
    public Output<Optional<Map<String,Object>>> parameters() {
        return Codegen.optional(this.parameters);
    }
    /**
     * The region in which to create the stack. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new stack.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to create the stack. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new stack.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * The status of the stack.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return The status of the stack.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * The reason for the current status of the stack.
     * 
     */
    @Export(name="statusReason", refs={String.class}, tree="[0]")
    private Output<String> statusReason;

    /**
     * @return The reason for the current status of the stack.
     * 
     */
    public Output<String> statusReason() {
        return this.statusReason;
    }
    /**
     * A list of tags to assosciate with the Stack
     * 
     */
    @Export(name="tags", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> tags;

    /**
     * @return A list of tags to assosciate with the Stack
     * 
     */
    public Output<List<String>> tags() {
        return this.tags;
    }
    /**
     * The description of the stack template.
     * 
     */
    @Export(name="templateDescription", refs={String.class}, tree="[0]")
    private Output<String> templateDescription;

    /**
     * @return The description of the stack template.
     * 
     */
    public Output<String> templateDescription() {
        return this.templateDescription;
    }
    /**
     * Template key/value pairs to associate with the
     * stack which contains either the template file or url.
     * Allowed keys: Bin, URL, Files. Changing this updates the existing stack
     * Template Opts.
     * 
     */
    @Export(name="templateOpts", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output<Map<String,Object>> templateOpts;

    /**
     * @return Template key/value pairs to associate with the
     * stack which contains either the template file or url.
     * Allowed keys: Bin, URL, Files. Changing this updates the existing stack
     * Template Opts.
     * 
     */
    public Output<Map<String,Object>> templateOpts() {
        return this.templateOpts;
    }
    /**
     * The timeout for stack action in minutes.
     * 
     */
    @Export(name="timeout", refs={Integer.class}, tree="[0]")
    private Output<Integer> timeout;

    /**
     * @return The timeout for stack action in minutes.
     * 
     */
    public Output<Integer> timeout() {
        return this.timeout;
    }
    /**
     * The date and time when the resource was updated. The date
     * and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
     * For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
     * is the time zone as an offset from UTC.
     * 
     */
    @Export(name="updatedTime", refs={String.class}, tree="[0]")
    private Output<String> updatedTime;

    /**
     * @return The date and time when the resource was updated. The date
     * and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
     * For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
     * is the time zone as an offset from UTC.
     * 
     */
    public Output<String> updatedTime() {
        return this.updatedTime;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public StackV1(String name) {
        this(name, StackV1Args.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public StackV1(String name, StackV1Args args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public StackV1(String name, StackV1Args args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:orchestration/stackV1:StackV1", name, args == null ? StackV1Args.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private StackV1(String name, Output<String> id, @Nullable StackV1State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:orchestration/stackV1:StackV1", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static StackV1 get(String name, Output<String> id, @Nullable StackV1State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new StackV1(name, id, state, options);
    }
}
