// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.sharedfilesystem;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ShareAccessArgs extends com.pulumi.resources.ResourceArgs {

    public static final ShareAccessArgs Empty = new ShareAccessArgs();

    /**
     * The access level to the share. Can either be `rw` or `ro`.
     * 
     */
    @Import(name="accessLevel", required=true)
    private Output<String> accessLevel;

    /**
     * @return The access level to the share. Can either be `rw` or `ro`.
     * 
     */
    public Output<String> accessLevel() {
        return this.accessLevel;
    }

    /**
     * The value that defines the access. Can either be an IP
     * address or a username verified by configured Security Service of the Share Network.
     * 
     */
    @Import(name="accessTo", required=true)
    private Output<String> accessTo;

    /**
     * @return The value that defines the access. Can either be an IP
     * address or a username verified by configured Security Service of the Share Network.
     * 
     */
    public Output<String> accessTo() {
        return this.accessTo;
    }

    /**
     * The access rule type. Can either be an ip, user,
     * cert, or cephx. cephx support requires an OpenStack environment that supports
     * Shared Filesystem microversion 2.13 (Mitaka) or later.
     * 
     */
    @Import(name="accessType", required=true)
    private Output<String> accessType;

    /**
     * @return The access rule type. Can either be an ip, user,
     * cert, or cephx. cephx support requires an OpenStack environment that supports
     * Shared Filesystem microversion 2.13 (Mitaka) or later.
     * 
     */
    public Output<String> accessType() {
        return this.accessType;
    }

    /**
     * The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a share access. Changing this
     * creates a new share access.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a share access. Changing this
     * creates a new share access.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The UUID of the share to which you are granted access.
     * 
     */
    @Import(name="shareId", required=true)
    private Output<String> shareId;

    /**
     * @return The UUID of the share to which you are granted access.
     * 
     */
    public Output<String> shareId() {
        return this.shareId;
    }

    private ShareAccessArgs() {}

    private ShareAccessArgs(ShareAccessArgs $) {
        this.accessLevel = $.accessLevel;
        this.accessTo = $.accessTo;
        this.accessType = $.accessType;
        this.region = $.region;
        this.shareId = $.shareId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ShareAccessArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ShareAccessArgs $;

        public Builder() {
            $ = new ShareAccessArgs();
        }

        public Builder(ShareAccessArgs defaults) {
            $ = new ShareAccessArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessLevel The access level to the share. Can either be `rw` or `ro`.
         * 
         * @return builder
         * 
         */
        public Builder accessLevel(Output<String> accessLevel) {
            $.accessLevel = accessLevel;
            return this;
        }

        /**
         * @param accessLevel The access level to the share. Can either be `rw` or `ro`.
         * 
         * @return builder
         * 
         */
        public Builder accessLevel(String accessLevel) {
            return accessLevel(Output.of(accessLevel));
        }

        /**
         * @param accessTo The value that defines the access. Can either be an IP
         * address or a username verified by configured Security Service of the Share Network.
         * 
         * @return builder
         * 
         */
        public Builder accessTo(Output<String> accessTo) {
            $.accessTo = accessTo;
            return this;
        }

        /**
         * @param accessTo The value that defines the access. Can either be an IP
         * address or a username verified by configured Security Service of the Share Network.
         * 
         * @return builder
         * 
         */
        public Builder accessTo(String accessTo) {
            return accessTo(Output.of(accessTo));
        }

        /**
         * @param accessType The access rule type. Can either be an ip, user,
         * cert, or cephx. cephx support requires an OpenStack environment that supports
         * Shared Filesystem microversion 2.13 (Mitaka) or later.
         * 
         * @return builder
         * 
         */
        public Builder accessType(Output<String> accessType) {
            $.accessType = accessType;
            return this;
        }

        /**
         * @param accessType The access rule type. Can either be an ip, user,
         * cert, or cephx. cephx support requires an OpenStack environment that supports
         * Shared Filesystem microversion 2.13 (Mitaka) or later.
         * 
         * @return builder
         * 
         */
        public Builder accessType(String accessType) {
            return accessType(Output.of(accessType));
        }

        /**
         * @param region The region in which to obtain the V2 Shared File System client.
         * A Shared File System client is needed to create a share access. Changing this
         * creates a new share access.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Shared File System client.
         * A Shared File System client is needed to create a share access. Changing this
         * creates a new share access.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param shareId The UUID of the share to which you are granted access.
         * 
         * @return builder
         * 
         */
        public Builder shareId(Output<String> shareId) {
            $.shareId = shareId;
            return this;
        }

        /**
         * @param shareId The UUID of the share to which you are granted access.
         * 
         * @return builder
         * 
         */
        public Builder shareId(String shareId) {
            return shareId(Output.of(shareId));
        }

        public ShareAccessArgs build() {
            if ($.accessLevel == null) {
                throw new MissingRequiredPropertyException("ShareAccessArgs", "accessLevel");
            }
            if ($.accessTo == null) {
                throw new MissingRequiredPropertyException("ShareAccessArgs", "accessTo");
            }
            if ($.accessType == null) {
                throw new MissingRequiredPropertyException("ShareAccessArgs", "accessType");
            }
            if ($.shareId == null) {
                throw new MissingRequiredPropertyException("ShareAccessArgs", "shareId");
            }
            return $;
        }
    }

}
