// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.sharedfilesystem;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.sharedfilesystem.ShareNetworkArgs;
import com.pulumi.openstack.sharedfilesystem.inputs.ShareNetworkState;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Use this resource to configure a share network.
 * 
 * A share network stores network information that share servers can use when
 * shares are created.
 * 
 * ## Example Usage
 * ### Basic share network
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.Network;
 * import com.pulumi.openstack.networking.NetworkArgs;
 * import com.pulumi.openstack.networking.Subnet;
 * import com.pulumi.openstack.networking.SubnetArgs;
 * import com.pulumi.openstack.sharedfilesystem.ShareNetwork;
 * import com.pulumi.openstack.sharedfilesystem.ShareNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var network1 = new Network(&#34;network1&#34;, NetworkArgs.builder()        
 *             .adminStateUp(&#34;true&#34;)
 *             .build());
 * 
 *         var subnet1 = new Subnet(&#34;subnet1&#34;, SubnetArgs.builder()        
 *             .cidr(&#34;192.168.199.0/24&#34;)
 *             .ipVersion(4)
 *             .networkId(network1.id())
 *             .build());
 * 
 *         var sharenetwork1 = new ShareNetwork(&#34;sharenetwork1&#34;, ShareNetworkArgs.builder()        
 *             .description(&#34;test share network&#34;)
 *             .neutronNetId(network1.id())
 *             .neutronSubnetId(subnet1.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Share network with associated security services
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.networking.Network;
 * import com.pulumi.openstack.networking.NetworkArgs;
 * import com.pulumi.openstack.networking.Subnet;
 * import com.pulumi.openstack.networking.SubnetArgs;
 * import com.pulumi.openstack.sharedfilesystem.SecurityService;
 * import com.pulumi.openstack.sharedfilesystem.SecurityServiceArgs;
 * import com.pulumi.openstack.sharedfilesystem.ShareNetwork;
 * import com.pulumi.openstack.sharedfilesystem.ShareNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var network1 = new Network(&#34;network1&#34;, NetworkArgs.builder()        
 *             .adminStateUp(&#34;true&#34;)
 *             .build());
 * 
 *         var subnet1 = new Subnet(&#34;subnet1&#34;, SubnetArgs.builder()        
 *             .cidr(&#34;192.168.199.0/24&#34;)
 *             .ipVersion(4)
 *             .networkId(network1.id())
 *             .build());
 * 
 *         var securityservice1 = new SecurityService(&#34;securityservice1&#34;, SecurityServiceArgs.builder()        
 *             .description(&#34;created by terraform&#34;)
 *             .type(&#34;active_directory&#34;)
 *             .server(&#34;192.168.199.10&#34;)
 *             .dnsIp(&#34;192.168.199.10&#34;)
 *             .domain(&#34;example.com&#34;)
 *             .ou(&#34;CN=Computers,DC=example,DC=com&#34;)
 *             .user(&#34;joinDomainUser&#34;)
 *             .password(&#34;s8cret&#34;)
 *             .build());
 * 
 *         var sharenetwork1 = new ShareNetwork(&#34;sharenetwork1&#34;, ShareNetworkArgs.builder()        
 *             .description(&#34;test share network with security services&#34;)
 *             .neutronNetId(network1.id())
 *             .neutronSubnetId(subnet1.id())
 *             .securityServiceIds(securityservice1.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * This resource can be imported by specifying the ID of the share network:
 * 
 * ```sh
 *  $ pulumi import openstack:sharedfilesystem/shareNetwork:ShareNetwork sharenetwork_1 id
 * ```
 * 
 */
@ResourceType(type="openstack:sharedfilesystem/shareNetwork:ShareNetwork")
public class ShareNetwork extends com.pulumi.resources.CustomResource {
    /**
     * The share network CIDR.
     * 
     */
    @Export(name="cidr", refs={String.class}, tree="[0]")
    private Output<String> cidr;

    /**
     * @return The share network CIDR.
     * 
     */
    public Output<String> cidr() {
        return this.cidr;
    }
    /**
     * The human-readable description for the share network.
     * Changing this updates the description of the existing share network.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return The human-readable description for the share network.
     * Changing this updates the description of the existing share network.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The IP version of the share network. Can either be 4 or 6.
     * 
     */
    @Export(name="ipVersion", refs={Integer.class}, tree="[0]")
    private Output<Integer> ipVersion;

    /**
     * @return The IP version of the share network. Can either be 4 or 6.
     * 
     */
    public Output<Integer> ipVersion() {
        return this.ipVersion;
    }
    /**
     * The name for the share network. Changing this updates the name
     * of the existing share network.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name for the share network. Changing this updates the name
     * of the existing share network.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The share network type. Can either be VLAN, VXLAN, GRE, or flat.
     * 
     */
    @Export(name="networkType", refs={String.class}, tree="[0]")
    private Output<String> networkType;

    /**
     * @return The share network type. Can either be VLAN, VXLAN, GRE, or flat.
     * 
     */
    public Output<String> networkType() {
        return this.networkType;
    }
    /**
     * The UUID of a neutron network when setting up or updating
     * a share network. Changing this updates the existing share network if it&#39;s not used by
     * shares.
     * 
     */
    @Export(name="neutronNetId", refs={String.class}, tree="[0]")
    private Output<String> neutronNetId;

    /**
     * @return The UUID of a neutron network when setting up or updating
     * a share network. Changing this updates the existing share network if it&#39;s not used by
     * shares.
     * 
     */
    public Output<String> neutronNetId() {
        return this.neutronNetId;
    }
    /**
     * The UUID of the neutron subnet when setting up or
     * updating a share network. Changing this updates the existing share network if it&#39;s
     * not used by shares.
     * 
     */
    @Export(name="neutronSubnetId", refs={String.class}, tree="[0]")
    private Output<String> neutronSubnetId;

    /**
     * @return The UUID of the neutron subnet when setting up or
     * updating a share network. Changing this updates the existing share network if it&#39;s
     * not used by shares.
     * 
     */
    public Output<String> neutronSubnetId() {
        return this.neutronSubnetId;
    }
    /**
     * The owner of the Share Network.
     * 
     */
    @Export(name="projectId", refs={String.class}, tree="[0]")
    private Output<String> projectId;

    /**
     * @return The owner of the Share Network.
     * 
     */
    public Output<String> projectId() {
        return this.projectId;
    }
    /**
     * The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a share network. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * share network.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a share network. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * share network.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * The list of security service IDs to associate with
     * the share network. The security service must be specified by ID and not name.
     * 
     */
    @Export(name="securityServiceIds", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> securityServiceIds;

    /**
     * @return The list of security service IDs to associate with
     * the share network. The security service must be specified by ID and not name.
     * 
     */
    public Output<Optional<List<String>>> securityServiceIds() {
        return Codegen.optional(this.securityServiceIds);
    }
    /**
     * The share network segmentation ID.
     * 
     */
    @Export(name="segmentationId", refs={Integer.class}, tree="[0]")
    private Output<Integer> segmentationId;

    /**
     * @return The share network segmentation ID.
     * 
     */
    public Output<Integer> segmentationId() {
        return this.segmentationId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ShareNetwork(String name) {
        this(name, ShareNetworkArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ShareNetwork(String name, ShareNetworkArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ShareNetwork(String name, ShareNetworkArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:sharedfilesystem/shareNetwork:ShareNetwork", name, args == null ? ShareNetworkArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ShareNetwork(String name, Output<String> id, @Nullable ShareNetworkState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:sharedfilesystem/shareNetwork:ShareNetwork", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ShareNetwork get(String name, Output<String> id, @Nullable ShareNetworkState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ShareNetwork(name, id, state, options);
    }
}
