// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.sharedfilesystem;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ShareNetworkArgs extends com.pulumi.resources.ResourceArgs {

    public static final ShareNetworkArgs Empty = new ShareNetworkArgs();

    /**
     * The human-readable description for the share network.
     * Changing this updates the description of the existing share network.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return The human-readable description for the share network.
     * Changing this updates the description of the existing share network.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The name for the share network. Changing this updates the name
     * of the existing share network.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name for the share network. Changing this updates the name
     * of the existing share network.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The UUID of a neutron network when setting up or updating
     * a share network. Changing this updates the existing share network if it&#39;s not used by
     * shares.
     * 
     */
    @Import(name="neutronNetId", required=true)
    private Output<String> neutronNetId;

    /**
     * @return The UUID of a neutron network when setting up or updating
     * a share network. Changing this updates the existing share network if it&#39;s not used by
     * shares.
     * 
     */
    public Output<String> neutronNetId() {
        return this.neutronNetId;
    }

    /**
     * The UUID of the neutron subnet when setting up or
     * updating a share network. Changing this updates the existing share network if it&#39;s
     * not used by shares.
     * 
     */
    @Import(name="neutronSubnetId", required=true)
    private Output<String> neutronSubnetId;

    /**
     * @return The UUID of the neutron subnet when setting up or
     * updating a share network. Changing this updates the existing share network if it&#39;s
     * not used by shares.
     * 
     */
    public Output<String> neutronSubnetId() {
        return this.neutronSubnetId;
    }

    /**
     * The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a share network. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * share network.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a share network. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * share network.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The list of security service IDs to associate with
     * the share network. The security service must be specified by ID and not name.
     * 
     */
    @Import(name="securityServiceIds")
    private @Nullable Output<List<String>> securityServiceIds;

    /**
     * @return The list of security service IDs to associate with
     * the share network. The security service must be specified by ID and not name.
     * 
     */
    public Optional<Output<List<String>>> securityServiceIds() {
        return Optional.ofNullable(this.securityServiceIds);
    }

    private ShareNetworkArgs() {}

    private ShareNetworkArgs(ShareNetworkArgs $) {
        this.description = $.description;
        this.name = $.name;
        this.neutronNetId = $.neutronNetId;
        this.neutronSubnetId = $.neutronSubnetId;
        this.region = $.region;
        this.securityServiceIds = $.securityServiceIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ShareNetworkArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ShareNetworkArgs $;

        public Builder() {
            $ = new ShareNetworkArgs();
        }

        public Builder(ShareNetworkArgs defaults) {
            $ = new ShareNetworkArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description The human-readable description for the share network.
         * Changing this updates the description of the existing share network.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description The human-readable description for the share network.
         * Changing this updates the description of the existing share network.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param name The name for the share network. Changing this updates the name
         * of the existing share network.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name for the share network. Changing this updates the name
         * of the existing share network.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param neutronNetId The UUID of a neutron network when setting up or updating
         * a share network. Changing this updates the existing share network if it&#39;s not used by
         * shares.
         * 
         * @return builder
         * 
         */
        public Builder neutronNetId(Output<String> neutronNetId) {
            $.neutronNetId = neutronNetId;
            return this;
        }

        /**
         * @param neutronNetId The UUID of a neutron network when setting up or updating
         * a share network. Changing this updates the existing share network if it&#39;s not used by
         * shares.
         * 
         * @return builder
         * 
         */
        public Builder neutronNetId(String neutronNetId) {
            return neutronNetId(Output.of(neutronNetId));
        }

        /**
         * @param neutronSubnetId The UUID of the neutron subnet when setting up or
         * updating a share network. Changing this updates the existing share network if it&#39;s
         * not used by shares.
         * 
         * @return builder
         * 
         */
        public Builder neutronSubnetId(Output<String> neutronSubnetId) {
            $.neutronSubnetId = neutronSubnetId;
            return this;
        }

        /**
         * @param neutronSubnetId The UUID of the neutron subnet when setting up or
         * updating a share network. Changing this updates the existing share network if it&#39;s
         * not used by shares.
         * 
         * @return builder
         * 
         */
        public Builder neutronSubnetId(String neutronSubnetId) {
            return neutronSubnetId(Output.of(neutronSubnetId));
        }

        /**
         * @param region The region in which to obtain the V2 Shared File System client.
         * A Shared File System client is needed to create a share network. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * share network.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Shared File System client.
         * A Shared File System client is needed to create a share network. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * share network.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param securityServiceIds The list of security service IDs to associate with
         * the share network. The security service must be specified by ID and not name.
         * 
         * @return builder
         * 
         */
        public Builder securityServiceIds(@Nullable Output<List<String>> securityServiceIds) {
            $.securityServiceIds = securityServiceIds;
            return this;
        }

        /**
         * @param securityServiceIds The list of security service IDs to associate with
         * the share network. The security service must be specified by ID and not name.
         * 
         * @return builder
         * 
         */
        public Builder securityServiceIds(List<String> securityServiceIds) {
            return securityServiceIds(Output.of(securityServiceIds));
        }

        /**
         * @param securityServiceIds The list of security service IDs to associate with
         * the share network. The security service must be specified by ID and not name.
         * 
         * @return builder
         * 
         */
        public Builder securityServiceIds(String... securityServiceIds) {
            return securityServiceIds(List.of(securityServiceIds));
        }

        public ShareNetworkArgs build() {
            if ($.neutronNetId == null) {
                throw new MissingRequiredPropertyException("ShareNetworkArgs", "neutronNetId");
            }
            if ($.neutronSubnetId == null) {
                throw new MissingRequiredPropertyException("ShareNetworkArgs", "neutronSubnetId");
            }
            return $;
        }
    }

}
