// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.sharedfilesystem.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SecurityServiceState extends com.pulumi.resources.ResourceArgs {

    public static final SecurityServiceState Empty = new SecurityServiceState();

    /**
     * The human-readable description for the security service.
     * Changing this updates the description of the existing security service.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return The human-readable description for the security service.
     * Changing this updates the description of the existing security service.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The security service DNS IP address that is used inside the
     * tenant network.
     * 
     */
    @Import(name="dnsIp")
    private @Nullable Output<String> dnsIp;

    /**
     * @return The security service DNS IP address that is used inside the
     * tenant network.
     * 
     */
    public Optional<Output<String>> dnsIp() {
        return Optional.ofNullable(this.dnsIp);
    }

    /**
     * The security service domain.
     * 
     */
    @Import(name="domain")
    private @Nullable Output<String> domain;

    /**
     * @return The security service domain.
     * 
     */
    public Optional<Output<String>> domain() {
        return Optional.ofNullable(this.domain);
    }

    /**
     * The name of the security service. Changing this updates the name
     * of the existing security service.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the security service. Changing this updates the name
     * of the existing security service.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The security service ou. An organizational unit can be added to
     * specify where the share ends up. New in Manila microversion 2.44.
     * 
     */
    @Import(name="ou")
    private @Nullable Output<String> ou;

    /**
     * @return The security service ou. An organizational unit can be added to
     * specify where the share ends up. New in Manila microversion 2.44.
     * 
     */
    public Optional<Output<String>> ou() {
        return Optional.ofNullable(this.ou);
    }

    /**
     * The user password, if you specify a user.
     * 
     */
    @Import(name="password")
    private @Nullable Output<String> password;

    /**
     * @return The user password, if you specify a user.
     * 
     */
    public Optional<Output<String>> password() {
        return Optional.ofNullable(this.password);
    }

    /**
     * The owner of the Security Service.
     * 
     */
    @Import(name="projectId")
    private @Nullable Output<String> projectId;

    /**
     * @return The owner of the Security Service.
     * 
     */
    public Optional<Output<String>> projectId() {
        return Optional.ofNullable(this.projectId);
    }

    /**
     * The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a security service. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * security service.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a security service. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * security service.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The security service host name or IP address.
     * 
     */
    @Import(name="server")
    private @Nullable Output<String> server;

    /**
     * @return The security service host name or IP address.
     * 
     */
    public Optional<Output<String>> server() {
        return Optional.ofNullable(this.server);
    }

    /**
     * The security service type - can either be active\_directory,
     * kerberos or ldap.  Changing this updates the existing security service.
     * 
     */
    @Import(name="type")
    private @Nullable Output<String> type;

    /**
     * @return The security service type - can either be active\_directory,
     * kerberos or ldap.  Changing this updates the existing security service.
     * 
     */
    public Optional<Output<String>> type() {
        return Optional.ofNullable(this.type);
    }

    /**
     * The security service user or group name that is used by the
     * tenant.
     * 
     */
    @Import(name="user")
    private @Nullable Output<String> user;

    /**
     * @return The security service user or group name that is used by the
     * tenant.
     * 
     */
    public Optional<Output<String>> user() {
        return Optional.ofNullable(this.user);
    }

    private SecurityServiceState() {}

    private SecurityServiceState(SecurityServiceState $) {
        this.description = $.description;
        this.dnsIp = $.dnsIp;
        this.domain = $.domain;
        this.name = $.name;
        this.ou = $.ou;
        this.password = $.password;
        this.projectId = $.projectId;
        this.region = $.region;
        this.server = $.server;
        this.type = $.type;
        this.user = $.user;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SecurityServiceState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SecurityServiceState $;

        public Builder() {
            $ = new SecurityServiceState();
        }

        public Builder(SecurityServiceState defaults) {
            $ = new SecurityServiceState(Objects.requireNonNull(defaults));
        }

        /**
         * @param description The human-readable description for the security service.
         * Changing this updates the description of the existing security service.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description The human-readable description for the security service.
         * Changing this updates the description of the existing security service.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param dnsIp The security service DNS IP address that is used inside the
         * tenant network.
         * 
         * @return builder
         * 
         */
        public Builder dnsIp(@Nullable Output<String> dnsIp) {
            $.dnsIp = dnsIp;
            return this;
        }

        /**
         * @param dnsIp The security service DNS IP address that is used inside the
         * tenant network.
         * 
         * @return builder
         * 
         */
        public Builder dnsIp(String dnsIp) {
            return dnsIp(Output.of(dnsIp));
        }

        /**
         * @param domain The security service domain.
         * 
         * @return builder
         * 
         */
        public Builder domain(@Nullable Output<String> domain) {
            $.domain = domain;
            return this;
        }

        /**
         * @param domain The security service domain.
         * 
         * @return builder
         * 
         */
        public Builder domain(String domain) {
            return domain(Output.of(domain));
        }

        /**
         * @param name The name of the security service. Changing this updates the name
         * of the existing security service.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the security service. Changing this updates the name
         * of the existing security service.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param ou The security service ou. An organizational unit can be added to
         * specify where the share ends up. New in Manila microversion 2.44.
         * 
         * @return builder
         * 
         */
        public Builder ou(@Nullable Output<String> ou) {
            $.ou = ou;
            return this;
        }

        /**
         * @param ou The security service ou. An organizational unit can be added to
         * specify where the share ends up. New in Manila microversion 2.44.
         * 
         * @return builder
         * 
         */
        public Builder ou(String ou) {
            return ou(Output.of(ou));
        }

        /**
         * @param password The user password, if you specify a user.
         * 
         * @return builder
         * 
         */
        public Builder password(@Nullable Output<String> password) {
            $.password = password;
            return this;
        }

        /**
         * @param password The user password, if you specify a user.
         * 
         * @return builder
         * 
         */
        public Builder password(String password) {
            return password(Output.of(password));
        }

        /**
         * @param projectId The owner of the Security Service.
         * 
         * @return builder
         * 
         */
        public Builder projectId(@Nullable Output<String> projectId) {
            $.projectId = projectId;
            return this;
        }

        /**
         * @param projectId The owner of the Security Service.
         * 
         * @return builder
         * 
         */
        public Builder projectId(String projectId) {
            return projectId(Output.of(projectId));
        }

        /**
         * @param region The region in which to obtain the V2 Shared File System client.
         * A Shared File System client is needed to create a security service. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * security service.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Shared File System client.
         * A Shared File System client is needed to create a security service. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * security service.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param server The security service host name or IP address.
         * 
         * @return builder
         * 
         */
        public Builder server(@Nullable Output<String> server) {
            $.server = server;
            return this;
        }

        /**
         * @param server The security service host name or IP address.
         * 
         * @return builder
         * 
         */
        public Builder server(String server) {
            return server(Output.of(server));
        }

        /**
         * @param type The security service type - can either be active\_directory,
         * kerberos or ldap.  Changing this updates the existing security service.
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type The security service type - can either be active\_directory,
         * kerberos or ldap.  Changing this updates the existing security service.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        /**
         * @param user The security service user or group name that is used by the
         * tenant.
         * 
         * @return builder
         * 
         */
        public Builder user(@Nullable Output<String> user) {
            $.user = user;
            return this;
        }

        /**
         * @param user The security service user or group name that is used by the
         * tenant.
         * 
         * @return builder
         * 
         */
        public Builder user(String user) {
            return user(Output.of(user));
        }

        public SecurityServiceState build() {
            return $;
        }
    }

}
