// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.sharedfilesystem.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ShareAccessState extends com.pulumi.resources.ResourceArgs {

    public static final ShareAccessState Empty = new ShareAccessState();

    /**
     * The access credential of the entity granted access.
     * 
     */
    @Import(name="accessKey")
    private @Nullable Output<String> accessKey;

    /**
     * @return The access credential of the entity granted access.
     * 
     */
    public Optional<Output<String>> accessKey() {
        return Optional.ofNullable(this.accessKey);
    }

    /**
     * The access level to the share. Can either be `rw` or `ro`.
     * 
     */
    @Import(name="accessLevel")
    private @Nullable Output<String> accessLevel;

    /**
     * @return The access level to the share. Can either be `rw` or `ro`.
     * 
     */
    public Optional<Output<String>> accessLevel() {
        return Optional.ofNullable(this.accessLevel);
    }

    /**
     * The value that defines the access. Can either be an IP
     * address or a username verified by configured Security Service of the Share Network.
     * 
     */
    @Import(name="accessTo")
    private @Nullable Output<String> accessTo;

    /**
     * @return The value that defines the access. Can either be an IP
     * address or a username verified by configured Security Service of the Share Network.
     * 
     */
    public Optional<Output<String>> accessTo() {
        return Optional.ofNullable(this.accessTo);
    }

    /**
     * The access rule type. Can either be an ip, user,
     * cert, or cephx. cephx support requires an OpenStack environment that supports
     * Shared Filesystem microversion 2.13 (Mitaka) or later.
     * 
     */
    @Import(name="accessType")
    private @Nullable Output<String> accessType;

    /**
     * @return The access rule type. Can either be an ip, user,
     * cert, or cephx. cephx support requires an OpenStack environment that supports
     * Shared Filesystem microversion 2.13 (Mitaka) or later.
     * 
     */
    public Optional<Output<String>> accessType() {
        return Optional.ofNullable(this.accessType);
    }

    /**
     * The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a share access. Changing this
     * creates a new share access.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Shared File System client.
     * A Shared File System client is needed to create a share access. Changing this
     * creates a new share access.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The UUID of the share to which you are granted access.
     * 
     */
    @Import(name="shareId")
    private @Nullable Output<String> shareId;

    /**
     * @return The UUID of the share to which you are granted access.
     * 
     */
    public Optional<Output<String>> shareId() {
        return Optional.ofNullable(this.shareId);
    }

    /**
     * The share access state.
     * 
     */
    @Import(name="state")
    private @Nullable Output<String> state;

    /**
     * @return The share access state.
     * 
     */
    public Optional<Output<String>> state() {
        return Optional.ofNullable(this.state);
    }

    private ShareAccessState() {}

    private ShareAccessState(ShareAccessState $) {
        this.accessKey = $.accessKey;
        this.accessLevel = $.accessLevel;
        this.accessTo = $.accessTo;
        this.accessType = $.accessType;
        this.region = $.region;
        this.shareId = $.shareId;
        this.state = $.state;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ShareAccessState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ShareAccessState $;

        public Builder() {
            $ = new ShareAccessState();
        }

        public Builder(ShareAccessState defaults) {
            $ = new ShareAccessState(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessKey The access credential of the entity granted access.
         * 
         * @return builder
         * 
         */
        public Builder accessKey(@Nullable Output<String> accessKey) {
            $.accessKey = accessKey;
            return this;
        }

        /**
         * @param accessKey The access credential of the entity granted access.
         * 
         * @return builder
         * 
         */
        public Builder accessKey(String accessKey) {
            return accessKey(Output.of(accessKey));
        }

        /**
         * @param accessLevel The access level to the share. Can either be `rw` or `ro`.
         * 
         * @return builder
         * 
         */
        public Builder accessLevel(@Nullable Output<String> accessLevel) {
            $.accessLevel = accessLevel;
            return this;
        }

        /**
         * @param accessLevel The access level to the share. Can either be `rw` or `ro`.
         * 
         * @return builder
         * 
         */
        public Builder accessLevel(String accessLevel) {
            return accessLevel(Output.of(accessLevel));
        }

        /**
         * @param accessTo The value that defines the access. Can either be an IP
         * address or a username verified by configured Security Service of the Share Network.
         * 
         * @return builder
         * 
         */
        public Builder accessTo(@Nullable Output<String> accessTo) {
            $.accessTo = accessTo;
            return this;
        }

        /**
         * @param accessTo The value that defines the access. Can either be an IP
         * address or a username verified by configured Security Service of the Share Network.
         * 
         * @return builder
         * 
         */
        public Builder accessTo(String accessTo) {
            return accessTo(Output.of(accessTo));
        }

        /**
         * @param accessType The access rule type. Can either be an ip, user,
         * cert, or cephx. cephx support requires an OpenStack environment that supports
         * Shared Filesystem microversion 2.13 (Mitaka) or later.
         * 
         * @return builder
         * 
         */
        public Builder accessType(@Nullable Output<String> accessType) {
            $.accessType = accessType;
            return this;
        }

        /**
         * @param accessType The access rule type. Can either be an ip, user,
         * cert, or cephx. cephx support requires an OpenStack environment that supports
         * Shared Filesystem microversion 2.13 (Mitaka) or later.
         * 
         * @return builder
         * 
         */
        public Builder accessType(String accessType) {
            return accessType(Output.of(accessType));
        }

        /**
         * @param region The region in which to obtain the V2 Shared File System client.
         * A Shared File System client is needed to create a share access. Changing this
         * creates a new share access.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Shared File System client.
         * A Shared File System client is needed to create a share access. Changing this
         * creates a new share access.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param shareId The UUID of the share to which you are granted access.
         * 
         * @return builder
         * 
         */
        public Builder shareId(@Nullable Output<String> shareId) {
            $.shareId = shareId;
            return this;
        }

        /**
         * @param shareId The UUID of the share to which you are granted access.
         * 
         * @return builder
         * 
         */
        public Builder shareId(String shareId) {
            return shareId(Output.of(shareId));
        }

        /**
         * @param state The share access state.
         * 
         * @return builder
         * 
         */
        public Builder state(@Nullable Output<String> state) {
            $.state = state;
            return this;
        }

        /**
         * @param state The share access state.
         * 
         * @return builder
         * 
         */
        public Builder state(String state) {
            return state(Output.of(state));
        }

        public ShareAccessState build() {
            return $;
        }
    }

}
