// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.vpnaas;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.openstack.vpnaas.inputs.SiteConnectionDpdArgs;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SiteConnectionArgs extends com.pulumi.resources.ResourceArgs {

    public static final SiteConnectionArgs Empty = new SiteConnectionArgs();

    /**
     * The administrative state of the resource. Can either be up(true) or down(false).
     * Changing this updates the administrative state of the existing connection.
     * 
     */
    @Import(name="adminStateUp")
    private @Nullable Output<Boolean> adminStateUp;

    /**
     * @return The administrative state of the resource. Can either be up(true) or down(false).
     * Changing this updates the administrative state of the existing connection.
     * 
     */
    public Optional<Output<Boolean>> adminStateUp() {
        return Optional.ofNullable(this.adminStateUp);
    }

    /**
     * The human-readable description for the connection.
     * Changing this updates the description of the existing connection.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return The human-readable description for the connection.
     * Changing this updates the description of the existing connection.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * A dictionary with dead peer detection (DPD) protocol controls.
     * 
     */
    @Import(name="dpds")
    private @Nullable Output<List<SiteConnectionDpdArgs>> dpds;

    /**
     * @return A dictionary with dead peer detection (DPD) protocol controls.
     * 
     */
    public Optional<Output<List<SiteConnectionDpdArgs>>> dpds() {
        return Optional.ofNullable(this.dpds);
    }

    /**
     * The ID of the IKE policy. Changing this creates a new connection.
     * 
     */
    @Import(name="ikepolicyId", required=true)
    private Output<String> ikepolicyId;

    /**
     * @return The ID of the IKE policy. Changing this creates a new connection.
     * 
     */
    public Output<String> ikepolicyId() {
        return this.ikepolicyId;
    }

    /**
     * A valid value is response-only or bi-directional. Default is bi-directional.
     * 
     */
    @Import(name="initiator")
    private @Nullable Output<String> initiator;

    /**
     * @return A valid value is response-only or bi-directional. Default is bi-directional.
     * 
     */
    public Optional<Output<String>> initiator() {
        return Optional.ofNullable(this.initiator);
    }

    /**
     * The ID of the IPsec policy. Changing this creates a new connection.
     * 
     */
    @Import(name="ipsecpolicyId", required=true)
    private Output<String> ipsecpolicyId;

    /**
     * @return The ID of the IPsec policy. Changing this creates a new connection.
     * 
     */
    public Output<String> ipsecpolicyId() {
        return this.ipsecpolicyId;
    }

    /**
     * The ID for the endpoint group that contains private subnets for the local side of the connection.
     * You must specify this parameter with the peer_ep_group_id parameter unless
     * in backward- compatible mode where peer_cidrs is provided with a subnet_id for the VPN service.
     * Changing this updates the existing connection.
     * 
     */
    @Import(name="localEpGroupId")
    private @Nullable Output<String> localEpGroupId;

    /**
     * @return The ID for the endpoint group that contains private subnets for the local side of the connection.
     * You must specify this parameter with the peer_ep_group_id parameter unless
     * in backward- compatible mode where peer_cidrs is provided with a subnet_id for the VPN service.
     * Changing this updates the existing connection.
     * 
     */
    public Optional<Output<String>> localEpGroupId() {
        return Optional.ofNullable(this.localEpGroupId);
    }

    /**
     * An ID to be used instead of the external IP address for a virtual router used in traffic between instances on different networks in east-west traffic.
     * Most often, local ID would be domain name, email address, etc.
     * If this is not configured then the external IP address will be used as the ID.
     * 
     */
    @Import(name="localId")
    private @Nullable Output<String> localId;

    /**
     * @return An ID to be used instead of the external IP address for a virtual router used in traffic between instances on different networks in east-west traffic.
     * Most often, local ID would be domain name, email address, etc.
     * If this is not configured then the external IP address will be used as the ID.
     * 
     */
    public Optional<Output<String>> localId() {
        return Optional.ofNullable(this.localId);
    }

    /**
     * The maximum transmission unit (MTU) value to address fragmentation.
     * Minimum value is 68 for IPv4, and 1280 for IPv6.
     * 
     */
    @Import(name="mtu")
    private @Nullable Output<Integer> mtu;

    /**
     * @return The maximum transmission unit (MTU) value to address fragmentation.
     * Minimum value is 68 for IPv4, and 1280 for IPv6.
     * 
     */
    public Optional<Output<Integer>> mtu() {
        return Optional.ofNullable(this.mtu);
    }

    /**
     * The name of the connection. Changing this updates the name of
     * the existing connection.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the connection. Changing this updates the name of
     * the existing connection.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The peer gateway public IPv4 or IPv6 address or FQDN.
     * 
     */
    @Import(name="peerAddress", required=true)
    private Output<String> peerAddress;

    /**
     * @return The peer gateway public IPv4 or IPv6 address or FQDN.
     * 
     */
    public Output<String> peerAddress() {
        return this.peerAddress;
    }

    /**
     * Unique list of valid peer private CIDRs in the form &lt; net_address &gt; / &lt; prefix &gt; .
     * 
     */
    @Import(name="peerCidrs")
    private @Nullable Output<List<String>> peerCidrs;

    /**
     * @return Unique list of valid peer private CIDRs in the form &lt; net_address &gt; / &lt; prefix &gt; .
     * 
     */
    public Optional<Output<List<String>>> peerCidrs() {
        return Optional.ofNullable(this.peerCidrs);
    }

    /**
     * The ID for the endpoint group that contains private CIDRs in the form &lt; net_address &gt; / &lt; prefix &gt; for the peer side of the connection.
     * You must specify this parameter with the local_ep_group_id parameter unless in backward-compatible mode
     * where peer_cidrs is provided with a subnet_id for the VPN service.
     * 
     */
    @Import(name="peerEpGroupId")
    private @Nullable Output<String> peerEpGroupId;

    /**
     * @return The ID for the endpoint group that contains private CIDRs in the form &lt; net_address &gt; / &lt; prefix &gt; for the peer side of the connection.
     * You must specify this parameter with the local_ep_group_id parameter unless in backward-compatible mode
     * where peer_cidrs is provided with a subnet_id for the VPN service.
     * 
     */
    public Optional<Output<String>> peerEpGroupId() {
        return Optional.ofNullable(this.peerEpGroupId);
    }

    /**
     * The peer router identity for authentication. A valid value is an IPv4 address, IPv6 address, e-mail address, key ID, or FQDN.
     * Typically, this value matches the peer_address value.
     * Changing this updates the existing policy.
     * 
     */
    @Import(name="peerId", required=true)
    private Output<String> peerId;

    /**
     * @return The peer router identity for authentication. A valid value is an IPv4 address, IPv6 address, e-mail address, key ID, or FQDN.
     * Typically, this value matches the peer_address value.
     * Changing this updates the existing policy.
     * 
     */
    public Output<String> peerId() {
        return this.peerId;
    }

    /**
     * The pre-shared key. A valid value is any string.
     * 
     */
    @Import(name="psk", required=true)
    private Output<String> psk;

    /**
     * @return The pre-shared key. A valid value is any string.
     * 
     */
    public Output<String> psk() {
        return this.psk;
    }

    /**
     * The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create an IPSec site connection. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * site connection.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create an IPSec site connection. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * site connection.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The owner of the connection. Required if admin wants to
     * create a connection for another project. Changing this creates a new connection.
     * 
     */
    @Import(name="tenantId")
    private @Nullable Output<String> tenantId;

    /**
     * @return The owner of the connection. Required if admin wants to
     * create a connection for another project. Changing this creates a new connection.
     * 
     */
    public Optional<Output<String>> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    /**
     * Map of additional options.
     * 
     */
    @Import(name="valueSpecs")
    private @Nullable Output<Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional options.
     * 
     */
    public Optional<Output<Map<String,Object>>> valueSpecs() {
        return Optional.ofNullable(this.valueSpecs);
    }

    /**
     * The ID of the VPN service. Changing this creates a new connection.
     * 
     */
    @Import(name="vpnserviceId", required=true)
    private Output<String> vpnserviceId;

    /**
     * @return The ID of the VPN service. Changing this creates a new connection.
     * 
     */
    public Output<String> vpnserviceId() {
        return this.vpnserviceId;
    }

    private SiteConnectionArgs() {}

    private SiteConnectionArgs(SiteConnectionArgs $) {
        this.adminStateUp = $.adminStateUp;
        this.description = $.description;
        this.dpds = $.dpds;
        this.ikepolicyId = $.ikepolicyId;
        this.initiator = $.initiator;
        this.ipsecpolicyId = $.ipsecpolicyId;
        this.localEpGroupId = $.localEpGroupId;
        this.localId = $.localId;
        this.mtu = $.mtu;
        this.name = $.name;
        this.peerAddress = $.peerAddress;
        this.peerCidrs = $.peerCidrs;
        this.peerEpGroupId = $.peerEpGroupId;
        this.peerId = $.peerId;
        this.psk = $.psk;
        this.region = $.region;
        this.tenantId = $.tenantId;
        this.valueSpecs = $.valueSpecs;
        this.vpnserviceId = $.vpnserviceId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SiteConnectionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SiteConnectionArgs $;

        public Builder() {
            $ = new SiteConnectionArgs();
        }

        public Builder(SiteConnectionArgs defaults) {
            $ = new SiteConnectionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param adminStateUp The administrative state of the resource. Can either be up(true) or down(false).
         * Changing this updates the administrative state of the existing connection.
         * 
         * @return builder
         * 
         */
        public Builder adminStateUp(@Nullable Output<Boolean> adminStateUp) {
            $.adminStateUp = adminStateUp;
            return this;
        }

        /**
         * @param adminStateUp The administrative state of the resource. Can either be up(true) or down(false).
         * Changing this updates the administrative state of the existing connection.
         * 
         * @return builder
         * 
         */
        public Builder adminStateUp(Boolean adminStateUp) {
            return adminStateUp(Output.of(adminStateUp));
        }

        /**
         * @param description The human-readable description for the connection.
         * Changing this updates the description of the existing connection.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description The human-readable description for the connection.
         * Changing this updates the description of the existing connection.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param dpds A dictionary with dead peer detection (DPD) protocol controls.
         * 
         * @return builder
         * 
         */
        public Builder dpds(@Nullable Output<List<SiteConnectionDpdArgs>> dpds) {
            $.dpds = dpds;
            return this;
        }

        /**
         * @param dpds A dictionary with dead peer detection (DPD) protocol controls.
         * 
         * @return builder
         * 
         */
        public Builder dpds(List<SiteConnectionDpdArgs> dpds) {
            return dpds(Output.of(dpds));
        }

        /**
         * @param dpds A dictionary with dead peer detection (DPD) protocol controls.
         * 
         * @return builder
         * 
         */
        public Builder dpds(SiteConnectionDpdArgs... dpds) {
            return dpds(List.of(dpds));
        }

        /**
         * @param ikepolicyId The ID of the IKE policy. Changing this creates a new connection.
         * 
         * @return builder
         * 
         */
        public Builder ikepolicyId(Output<String> ikepolicyId) {
            $.ikepolicyId = ikepolicyId;
            return this;
        }

        /**
         * @param ikepolicyId The ID of the IKE policy. Changing this creates a new connection.
         * 
         * @return builder
         * 
         */
        public Builder ikepolicyId(String ikepolicyId) {
            return ikepolicyId(Output.of(ikepolicyId));
        }

        /**
         * @param initiator A valid value is response-only or bi-directional. Default is bi-directional.
         * 
         * @return builder
         * 
         */
        public Builder initiator(@Nullable Output<String> initiator) {
            $.initiator = initiator;
            return this;
        }

        /**
         * @param initiator A valid value is response-only or bi-directional. Default is bi-directional.
         * 
         * @return builder
         * 
         */
        public Builder initiator(String initiator) {
            return initiator(Output.of(initiator));
        }

        /**
         * @param ipsecpolicyId The ID of the IPsec policy. Changing this creates a new connection.
         * 
         * @return builder
         * 
         */
        public Builder ipsecpolicyId(Output<String> ipsecpolicyId) {
            $.ipsecpolicyId = ipsecpolicyId;
            return this;
        }

        /**
         * @param ipsecpolicyId The ID of the IPsec policy. Changing this creates a new connection.
         * 
         * @return builder
         * 
         */
        public Builder ipsecpolicyId(String ipsecpolicyId) {
            return ipsecpolicyId(Output.of(ipsecpolicyId));
        }

        /**
         * @param localEpGroupId The ID for the endpoint group that contains private subnets for the local side of the connection.
         * You must specify this parameter with the peer_ep_group_id parameter unless
         * in backward- compatible mode where peer_cidrs is provided with a subnet_id for the VPN service.
         * Changing this updates the existing connection.
         * 
         * @return builder
         * 
         */
        public Builder localEpGroupId(@Nullable Output<String> localEpGroupId) {
            $.localEpGroupId = localEpGroupId;
            return this;
        }

        /**
         * @param localEpGroupId The ID for the endpoint group that contains private subnets for the local side of the connection.
         * You must specify this parameter with the peer_ep_group_id parameter unless
         * in backward- compatible mode where peer_cidrs is provided with a subnet_id for the VPN service.
         * Changing this updates the existing connection.
         * 
         * @return builder
         * 
         */
        public Builder localEpGroupId(String localEpGroupId) {
            return localEpGroupId(Output.of(localEpGroupId));
        }

        /**
         * @param localId An ID to be used instead of the external IP address for a virtual router used in traffic between instances on different networks in east-west traffic.
         * Most often, local ID would be domain name, email address, etc.
         * If this is not configured then the external IP address will be used as the ID.
         * 
         * @return builder
         * 
         */
        public Builder localId(@Nullable Output<String> localId) {
            $.localId = localId;
            return this;
        }

        /**
         * @param localId An ID to be used instead of the external IP address for a virtual router used in traffic between instances on different networks in east-west traffic.
         * Most often, local ID would be domain name, email address, etc.
         * If this is not configured then the external IP address will be used as the ID.
         * 
         * @return builder
         * 
         */
        public Builder localId(String localId) {
            return localId(Output.of(localId));
        }

        /**
         * @param mtu The maximum transmission unit (MTU) value to address fragmentation.
         * Minimum value is 68 for IPv4, and 1280 for IPv6.
         * 
         * @return builder
         * 
         */
        public Builder mtu(@Nullable Output<Integer> mtu) {
            $.mtu = mtu;
            return this;
        }

        /**
         * @param mtu The maximum transmission unit (MTU) value to address fragmentation.
         * Minimum value is 68 for IPv4, and 1280 for IPv6.
         * 
         * @return builder
         * 
         */
        public Builder mtu(Integer mtu) {
            return mtu(Output.of(mtu));
        }

        /**
         * @param name The name of the connection. Changing this updates the name of
         * the existing connection.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the connection. Changing this updates the name of
         * the existing connection.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param peerAddress The peer gateway public IPv4 or IPv6 address or FQDN.
         * 
         * @return builder
         * 
         */
        public Builder peerAddress(Output<String> peerAddress) {
            $.peerAddress = peerAddress;
            return this;
        }

        /**
         * @param peerAddress The peer gateway public IPv4 or IPv6 address or FQDN.
         * 
         * @return builder
         * 
         */
        public Builder peerAddress(String peerAddress) {
            return peerAddress(Output.of(peerAddress));
        }

        /**
         * @param peerCidrs Unique list of valid peer private CIDRs in the form &lt; net_address &gt; / &lt; prefix &gt; .
         * 
         * @return builder
         * 
         */
        public Builder peerCidrs(@Nullable Output<List<String>> peerCidrs) {
            $.peerCidrs = peerCidrs;
            return this;
        }

        /**
         * @param peerCidrs Unique list of valid peer private CIDRs in the form &lt; net_address &gt; / &lt; prefix &gt; .
         * 
         * @return builder
         * 
         */
        public Builder peerCidrs(List<String> peerCidrs) {
            return peerCidrs(Output.of(peerCidrs));
        }

        /**
         * @param peerCidrs Unique list of valid peer private CIDRs in the form &lt; net_address &gt; / &lt; prefix &gt; .
         * 
         * @return builder
         * 
         */
        public Builder peerCidrs(String... peerCidrs) {
            return peerCidrs(List.of(peerCidrs));
        }

        /**
         * @param peerEpGroupId The ID for the endpoint group that contains private CIDRs in the form &lt; net_address &gt; / &lt; prefix &gt; for the peer side of the connection.
         * You must specify this parameter with the local_ep_group_id parameter unless in backward-compatible mode
         * where peer_cidrs is provided with a subnet_id for the VPN service.
         * 
         * @return builder
         * 
         */
        public Builder peerEpGroupId(@Nullable Output<String> peerEpGroupId) {
            $.peerEpGroupId = peerEpGroupId;
            return this;
        }

        /**
         * @param peerEpGroupId The ID for the endpoint group that contains private CIDRs in the form &lt; net_address &gt; / &lt; prefix &gt; for the peer side of the connection.
         * You must specify this parameter with the local_ep_group_id parameter unless in backward-compatible mode
         * where peer_cidrs is provided with a subnet_id for the VPN service.
         * 
         * @return builder
         * 
         */
        public Builder peerEpGroupId(String peerEpGroupId) {
            return peerEpGroupId(Output.of(peerEpGroupId));
        }

        /**
         * @param peerId The peer router identity for authentication. A valid value is an IPv4 address, IPv6 address, e-mail address, key ID, or FQDN.
         * Typically, this value matches the peer_address value.
         * Changing this updates the existing policy.
         * 
         * @return builder
         * 
         */
        public Builder peerId(Output<String> peerId) {
            $.peerId = peerId;
            return this;
        }

        /**
         * @param peerId The peer router identity for authentication. A valid value is an IPv4 address, IPv6 address, e-mail address, key ID, or FQDN.
         * Typically, this value matches the peer_address value.
         * Changing this updates the existing policy.
         * 
         * @return builder
         * 
         */
        public Builder peerId(String peerId) {
            return peerId(Output.of(peerId));
        }

        /**
         * @param psk The pre-shared key. A valid value is any string.
         * 
         * @return builder
         * 
         */
        public Builder psk(Output<String> psk) {
            $.psk = psk;
            return this;
        }

        /**
         * @param psk The pre-shared key. A valid value is any string.
         * 
         * @return builder
         * 
         */
        public Builder psk(String psk) {
            return psk(Output.of(psk));
        }

        /**
         * @param region The region in which to obtain the V2 Networking client.
         * A Networking client is needed to create an IPSec site connection. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * site connection.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Networking client.
         * A Networking client is needed to create an IPSec site connection. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * site connection.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param tenantId The owner of the connection. Required if admin wants to
         * create a connection for another project. Changing this creates a new connection.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(@Nullable Output<String> tenantId) {
            $.tenantId = tenantId;
            return this;
        }

        /**
         * @param tenantId The owner of the connection. Required if admin wants to
         * create a connection for another project. Changing this creates a new connection.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(String tenantId) {
            return tenantId(Output.of(tenantId));
        }

        /**
         * @param valueSpecs Map of additional options.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(@Nullable Output<Map<String,Object>> valueSpecs) {
            $.valueSpecs = valueSpecs;
            return this;
        }

        /**
         * @param valueSpecs Map of additional options.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(Map<String,Object> valueSpecs) {
            return valueSpecs(Output.of(valueSpecs));
        }

        /**
         * @param vpnserviceId The ID of the VPN service. Changing this creates a new connection.
         * 
         * @return builder
         * 
         */
        public Builder vpnserviceId(Output<String> vpnserviceId) {
            $.vpnserviceId = vpnserviceId;
            return this;
        }

        /**
         * @param vpnserviceId The ID of the VPN service. Changing this creates a new connection.
         * 
         * @return builder
         * 
         */
        public Builder vpnserviceId(String vpnserviceId) {
            return vpnserviceId(Output.of(vpnserviceId));
        }

        public SiteConnectionArgs build() {
            if ($.ikepolicyId == null) {
                throw new MissingRequiredPropertyException("SiteConnectionArgs", "ikepolicyId");
            }
            if ($.ipsecpolicyId == null) {
                throw new MissingRequiredPropertyException("SiteConnectionArgs", "ipsecpolicyId");
            }
            if ($.peerAddress == null) {
                throw new MissingRequiredPropertyException("SiteConnectionArgs", "peerAddress");
            }
            if ($.peerId == null) {
                throw new MissingRequiredPropertyException("SiteConnectionArgs", "peerId");
            }
            if ($.psk == null) {
                throw new MissingRequiredPropertyException("SiteConnectionArgs", "psk");
            }
            if ($.vpnserviceId == null) {
                throw new MissingRequiredPropertyException("SiteConnectionArgs", "vpnserviceId");
            }
            return $;
        }
    }

}
