/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.openstack.compute.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class InstanceBlockDevice {
    @Nullable
    private Integer bootIndex;
    @Nullable
    private Boolean deleteOnTermination;
    @Nullable
    private String destinationType;
    @Nullable
    private String deviceType;
    @Nullable
    private String diskBus;
    @Nullable
    private String guestFormat;
    @Nullable
    private Boolean multiattach;
    private String sourceType;
    @Nullable
    private String uuid;
    @Nullable
    private Integer volumeSize;
    @Nullable
    private String volumeType;

    private InstanceBlockDevice() {
    }

    public Optional<Integer> bootIndex() {
        return Optional.ofNullable(this.bootIndex);
    }

    public Optional<Boolean> deleteOnTermination() {
        return Optional.ofNullable(this.deleteOnTermination);
    }

    public Optional<String> destinationType() {
        return Optional.ofNullable(this.destinationType);
    }

    public Optional<String> deviceType() {
        return Optional.ofNullable(this.deviceType);
    }

    public Optional<String> diskBus() {
        return Optional.ofNullable(this.diskBus);
    }

    public Optional<String> guestFormat() {
        return Optional.ofNullable(this.guestFormat);
    }

    public Optional<Boolean> multiattach() {
        return Optional.ofNullable(this.multiattach);
    }

    public String sourceType() {
        return this.sourceType;
    }

    public Optional<String> uuid() {
        return Optional.ofNullable(this.uuid);
    }

    public Optional<Integer> volumeSize() {
        return Optional.ofNullable(this.volumeSize);
    }

    public Optional<String> volumeType() {
        return Optional.ofNullable(this.volumeType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InstanceBlockDevice defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer bootIndex;
        @Nullable
        private Boolean deleteOnTermination;
        @Nullable
        private String destinationType;
        @Nullable
        private String deviceType;
        @Nullable
        private String diskBus;
        @Nullable
        private String guestFormat;
        @Nullable
        private Boolean multiattach;
        private String sourceType;
        @Nullable
        private String uuid;
        @Nullable
        private Integer volumeSize;
        @Nullable
        private String volumeType;

        public Builder() {
        }

        public Builder(InstanceBlockDevice defaults) {
            Objects.requireNonNull(defaults);
            this.bootIndex = defaults.bootIndex;
            this.deleteOnTermination = defaults.deleteOnTermination;
            this.destinationType = defaults.destinationType;
            this.deviceType = defaults.deviceType;
            this.diskBus = defaults.diskBus;
            this.guestFormat = defaults.guestFormat;
            this.multiattach = defaults.multiattach;
            this.sourceType = defaults.sourceType;
            this.uuid = defaults.uuid;
            this.volumeSize = defaults.volumeSize;
            this.volumeType = defaults.volumeType;
        }

        @CustomType.Setter
        public Builder bootIndex(@Nullable Integer bootIndex) {
            this.bootIndex = bootIndex;
            return this;
        }

        @CustomType.Setter
        public Builder deleteOnTermination(@Nullable Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        @CustomType.Setter
        public Builder destinationType(@Nullable String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @CustomType.Setter
        public Builder deviceType(@Nullable String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @CustomType.Setter
        public Builder diskBus(@Nullable String diskBus) {
            this.diskBus = diskBus;
            return this;
        }

        @CustomType.Setter
        public Builder guestFormat(@Nullable String guestFormat) {
            this.guestFormat = guestFormat;
            return this;
        }

        @CustomType.Setter
        public Builder multiattach(@Nullable Boolean multiattach) {
            this.multiattach = multiattach;
            return this;
        }

        @CustomType.Setter
        public Builder sourceType(String sourceType) {
            if (sourceType == null) {
                throw new MissingRequiredPropertyException("InstanceBlockDevice", "sourceType");
            }
            this.sourceType = sourceType;
            return this;
        }

        @CustomType.Setter
        public Builder uuid(@Nullable String uuid) {
            this.uuid = uuid;
            return this;
        }

        @CustomType.Setter
        public Builder volumeSize(@Nullable Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        @CustomType.Setter
        public Builder volumeType(@Nullable String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public InstanceBlockDevice build() {
            InstanceBlockDevice _resultValue = new InstanceBlockDevice();
            _resultValue.bootIndex = this.bootIndex;
            _resultValue.deleteOnTermination = this.deleteOnTermination;
            _resultValue.destinationType = this.destinationType;
            _resultValue.deviceType = this.deviceType;
            _resultValue.diskBus = this.diskBus;
            _resultValue.guestFormat = this.guestFormat;
            _resultValue.multiattach = this.multiattach;
            _resultValue.sourceType = this.sourceType;
            _resultValue.uuid = this.uuid;
            _resultValue.volumeSize = this.volumeSize;
            _resultValue.volumeType = this.volumeType;
            return _resultValue;
        }
    }
}

