/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.openstack.database.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class InstanceUser {
    @Nullable
    private List<String> databases;
    @Nullable
    private String host;
    private String name;
    @Nullable
    private String password;

    private InstanceUser() {
    }

    public List<String> databases() {
        return this.databases == null ? List.of() : this.databases;
    }

    public Optional<String> host() {
        return Optional.ofNullable(this.host);
    }

    public String name() {
        return this.name;
    }

    public Optional<String> password() {
        return Optional.ofNullable(this.password);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InstanceUser defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> databases;
        @Nullable
        private String host;
        private String name;
        @Nullable
        private String password;

        public Builder() {
        }

        public Builder(InstanceUser defaults) {
            Objects.requireNonNull(defaults);
            this.databases = defaults.databases;
            this.host = defaults.host;
            this.name = defaults.name;
            this.password = defaults.password;
        }

        @CustomType.Setter
        public Builder databases(@Nullable List<String> databases) {
            this.databases = databases;
            return this;
        }

        public Builder databases(String ... databases) {
            return this.databases(List.of(databases));
        }

        @CustomType.Setter
        public Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("InstanceUser", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public InstanceUser build() {
            InstanceUser _resultValue = new InstanceUser();
            _resultValue.databases = this.databases;
            _resultValue.host = this.host;
            _resultValue.name = this.name;
            _resultValue.password = this.password;
            return _resultValue;
        }
    }
}

