/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.openstack.identity.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ApplicationCredentialAccessRule {
    @Nullable
    private String id;
    private String method;
    private String path;
    private String service;

    private ApplicationCredentialAccessRule() {
    }

    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    public String method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public String service() {
        return this.service;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ApplicationCredentialAccessRule defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String id;
        private String method;
        private String path;
        private String service;

        public Builder() {
        }

        public Builder(ApplicationCredentialAccessRule defaults) {
            Objects.requireNonNull(defaults);
            this.id = defaults.id;
            this.method = defaults.method;
            this.path = defaults.path;
            this.service = defaults.service;
        }

        @CustomType.Setter
        public Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @CustomType.Setter
        public Builder method(String method) {
            if (method == null) {
                throw new MissingRequiredPropertyException("ApplicationCredentialAccessRule", "method");
            }
            this.method = method;
            return this;
        }

        @CustomType.Setter
        public Builder path(String path) {
            if (path == null) {
                throw new MissingRequiredPropertyException("ApplicationCredentialAccessRule", "path");
            }
            this.path = path;
            return this;
        }

        @CustomType.Setter
        public Builder service(String service) {
            if (service == null) {
                throw new MissingRequiredPropertyException("ApplicationCredentialAccessRule", "service");
            }
            this.service = service;
            return this;
        }

        public ApplicationCredentialAccessRule build() {
            ApplicationCredentialAccessRule _resultValue = new ApplicationCredentialAccessRule();
            _resultValue.id = this.id;
            _resultValue.method = this.method;
            _resultValue.path = this.path;
            _resultValue.service = this.service;
            return _resultValue;
        }
    }
}

