/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.openstack.keymanager.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.resources.ResourceArgs;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class OrderV1MetaArgs
extends ResourceArgs {
    public static final OrderV1MetaArgs Empty = new OrderV1MetaArgs();
    @Import(name="algorithm", required=true)
    private Output<String> algorithm;
    @Import(name="bitLength", required=true)
    private Output<Integer> bitLength;
    @Import(name="expiration")
    @Nullable
    private Output<String> expiration;
    @Import(name="mode")
    @Nullable
    private Output<String> mode;
    @Import(name="name")
    @Nullable
    private Output<String> name;
    @Import(name="payloadContentType")
    @Nullable
    private Output<String> payloadContentType;

    public Output<String> algorithm() {
        return this.algorithm;
    }

    public Output<Integer> bitLength() {
        return this.bitLength;
    }

    public Optional<Output<String>> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    public Optional<Output<String>> mode() {
        return Optional.ofNullable(this.mode);
    }

    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Output<String>> payloadContentType() {
        return Optional.ofNullable(this.payloadContentType);
    }

    private OrderV1MetaArgs() {
    }

    private OrderV1MetaArgs(OrderV1MetaArgs $) {
        this.algorithm = $.algorithm;
        this.bitLength = $.bitLength;
        this.expiration = $.expiration;
        this.mode = $.mode;
        this.name = $.name;
        this.payloadContentType = $.payloadContentType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OrderV1MetaArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private OrderV1MetaArgs $;

        public Builder() {
            this.$ = new OrderV1MetaArgs();
        }

        public Builder(OrderV1MetaArgs defaults) {
            this.$ = new OrderV1MetaArgs(Objects.requireNonNull(defaults));
        }

        public Builder algorithm(Output<String> algorithm) {
            this.$.algorithm = algorithm;
            return this;
        }

        public Builder algorithm(String algorithm) {
            return this.algorithm((Output<String>)Output.of((Object)algorithm));
        }

        public Builder bitLength(Output<Integer> bitLength) {
            this.$.bitLength = bitLength;
            return this;
        }

        public Builder bitLength(Integer bitLength) {
            return this.bitLength((Output<Integer>)Output.of((Object)bitLength));
        }

        public Builder expiration(@Nullable Output<String> expiration) {
            this.$.expiration = expiration;
            return this;
        }

        public Builder expiration(String expiration) {
            return this.expiration((Output<String>)Output.of((Object)expiration));
        }

        public Builder mode(@Nullable Output<String> mode) {
            this.$.mode = mode;
            return this;
        }

        public Builder mode(String mode) {
            return this.mode((Output<String>)Output.of((Object)mode));
        }

        public Builder name(@Nullable Output<String> name) {
            this.$.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name((Output<String>)Output.of((Object)name));
        }

        public Builder payloadContentType(@Nullable Output<String> payloadContentType) {
            this.$.payloadContentType = payloadContentType;
            return this;
        }

        public Builder payloadContentType(String payloadContentType) {
            return this.payloadContentType((Output<String>)Output.of((Object)payloadContentType));
        }

        public OrderV1MetaArgs build() {
            if (this.$.algorithm == null) {
                throw new MissingRequiredPropertyException("OrderV1MetaArgs", "algorithm");
            }
            if (this.$.bitLength == null) {
                throw new MissingRequiredPropertyException("OrderV1MetaArgs", "bitLength");
            }
            return this.$;
        }
    }
}

