/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.openstack.keymanager.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class OrderV1Meta {
    private String algorithm;
    private Integer bitLength;
    @Nullable
    private String expiration;
    @Nullable
    private String mode;
    @Nullable
    private String name;
    @Nullable
    private String payloadContentType;

    private OrderV1Meta() {
    }

    public String algorithm() {
        return this.algorithm;
    }

    public Integer bitLength() {
        return this.bitLength;
    }

    public Optional<String> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    public Optional<String> mode() {
        return Optional.ofNullable(this.mode);
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> payloadContentType() {
        return Optional.ofNullable(this.payloadContentType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OrderV1Meta defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String algorithm;
        private Integer bitLength;
        @Nullable
        private String expiration;
        @Nullable
        private String mode;
        @Nullable
        private String name;
        @Nullable
        private String payloadContentType;

        public Builder() {
        }

        public Builder(OrderV1Meta defaults) {
            Objects.requireNonNull(defaults);
            this.algorithm = defaults.algorithm;
            this.bitLength = defaults.bitLength;
            this.expiration = defaults.expiration;
            this.mode = defaults.mode;
            this.name = defaults.name;
            this.payloadContentType = defaults.payloadContentType;
        }

        @CustomType.Setter
        public Builder algorithm(String algorithm) {
            if (algorithm == null) {
                throw new MissingRequiredPropertyException("OrderV1Meta", "algorithm");
            }
            this.algorithm = algorithm;
            return this;
        }

        @CustomType.Setter
        public Builder bitLength(Integer bitLength) {
            if (bitLength == null) {
                throw new MissingRequiredPropertyException("OrderV1Meta", "bitLength");
            }
            this.bitLength = bitLength;
            return this;
        }

        @CustomType.Setter
        public Builder expiration(@Nullable String expiration) {
            this.expiration = expiration;
            return this;
        }

        @CustomType.Setter
        public Builder mode(@Nullable String mode) {
            this.mode = mode;
            return this;
        }

        @CustomType.Setter
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder payloadContentType(@Nullable String payloadContentType) {
            this.payloadContentType = payloadContentType;
            return this;
        }

        public OrderV1Meta build() {
            OrderV1Meta _resultValue = new OrderV1Meta();
            _resultValue.algorithm = this.algorithm;
            _resultValue.bitLength = this.bitLength;
            _resultValue.expiration = this.expiration;
            _resultValue.mode = this.mode;
            _resultValue.name = this.name;
            _resultValue.payloadContentType = this.payloadContentType;
            return _resultValue;
        }
    }
}

