/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.openstack.networking.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.openstack.networking.outputs.GetNetworkSegment;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetNetworkResult {
    private String adminStateUp;
    private List<String> allTags;
    private List<String> availabilityZoneHints;
    @Nullable
    private String description;
    private String dnsDomain;
    @Nullable
    private Boolean external;
    private String id;
    @Nullable
    private String matchingSubnetCidr;
    @Nullable
    private Integer mtu;
    @Nullable
    private String name;
    @Nullable
    private String networkId;
    private String region;
    private List<GetNetworkSegment> segments;
    private String shared;
    @Nullable
    private String status;
    private List<String> subnets;
    @Nullable
    private List<String> tags;
    @Nullable
    private String tenantId;
    @Nullable
    private Boolean transparentVlan;

    private GetNetworkResult() {
    }

    public String adminStateUp() {
        return this.adminStateUp;
    }

    public List<String> allTags() {
        return this.allTags;
    }

    public List<String> availabilityZoneHints() {
        return this.availabilityZoneHints;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public String dnsDomain() {
        return this.dnsDomain;
    }

    public Optional<Boolean> external() {
        return Optional.ofNullable(this.external);
    }

    public String id() {
        return this.id;
    }

    public Optional<String> matchingSubnetCidr() {
        return Optional.ofNullable(this.matchingSubnetCidr);
    }

    public Optional<Integer> mtu() {
        return Optional.ofNullable(this.mtu);
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> networkId() {
        return Optional.ofNullable(this.networkId);
    }

    public String region() {
        return this.region;
    }

    public List<GetNetworkSegment> segments() {
        return this.segments;
    }

    public String shared() {
        return this.shared;
    }

    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<String> tags() {
        return this.tags == null ? List.of() : this.tags;
    }

    public Optional<String> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    public Optional<Boolean> transparentVlan() {
        return Optional.ofNullable(this.transparentVlan);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetNetworkResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String adminStateUp;
        private List<String> allTags;
        private List<String> availabilityZoneHints;
        @Nullable
        private String description;
        private String dnsDomain;
        @Nullable
        private Boolean external;
        private String id;
        @Nullable
        private String matchingSubnetCidr;
        @Nullable
        private Integer mtu;
        @Nullable
        private String name;
        @Nullable
        private String networkId;
        private String region;
        private List<GetNetworkSegment> segments;
        private String shared;
        @Nullable
        private String status;
        private List<String> subnets;
        @Nullable
        private List<String> tags;
        @Nullable
        private String tenantId;
        @Nullable
        private Boolean transparentVlan;

        public Builder() {
        }

        public Builder(GetNetworkResult defaults) {
            Objects.requireNonNull(defaults);
            this.adminStateUp = defaults.adminStateUp;
            this.allTags = defaults.allTags;
            this.availabilityZoneHints = defaults.availabilityZoneHints;
            this.description = defaults.description;
            this.dnsDomain = defaults.dnsDomain;
            this.external = defaults.external;
            this.id = defaults.id;
            this.matchingSubnetCidr = defaults.matchingSubnetCidr;
            this.mtu = defaults.mtu;
            this.name = defaults.name;
            this.networkId = defaults.networkId;
            this.region = defaults.region;
            this.segments = defaults.segments;
            this.shared = defaults.shared;
            this.status = defaults.status;
            this.subnets = defaults.subnets;
            this.tags = defaults.tags;
            this.tenantId = defaults.tenantId;
            this.transparentVlan = defaults.transparentVlan;
        }

        @CustomType.Setter
        public Builder adminStateUp(String adminStateUp) {
            if (adminStateUp == null) {
                throw new MissingRequiredPropertyException("GetNetworkResult", "adminStateUp");
            }
            this.adminStateUp = adminStateUp;
            return this;
        }

        @CustomType.Setter
        public Builder allTags(List<String> allTags) {
            if (allTags == null) {
                throw new MissingRequiredPropertyException("GetNetworkResult", "allTags");
            }
            this.allTags = allTags;
            return this;
        }

        public Builder allTags(String ... allTags) {
            return this.allTags(List.of(allTags));
        }

        @CustomType.Setter
        public Builder availabilityZoneHints(List<String> availabilityZoneHints) {
            if (availabilityZoneHints == null) {
                throw new MissingRequiredPropertyException("GetNetworkResult", "availabilityZoneHints");
            }
            this.availabilityZoneHints = availabilityZoneHints;
            return this;
        }

        public Builder availabilityZoneHints(String ... availabilityZoneHints) {
            return this.availabilityZoneHints(List.of(availabilityZoneHints));
        }

        @CustomType.Setter
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CustomType.Setter
        public Builder dnsDomain(String dnsDomain) {
            if (dnsDomain == null) {
                throw new MissingRequiredPropertyException("GetNetworkResult", "dnsDomain");
            }
            this.dnsDomain = dnsDomain;
            return this;
        }

        @CustomType.Setter
        public Builder external(@Nullable Boolean external) {
            this.external = external;
            return this;
        }

        @CustomType.Setter
        public Builder id(String id) {
            if (id == null) {
                throw new MissingRequiredPropertyException("GetNetworkResult", "id");
            }
            this.id = id;
            return this;
        }

        @CustomType.Setter
        public Builder matchingSubnetCidr(@Nullable String matchingSubnetCidr) {
            this.matchingSubnetCidr = matchingSubnetCidr;
            return this;
        }

        @CustomType.Setter
        public Builder mtu(@Nullable Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        @CustomType.Setter
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder networkId(@Nullable String networkId) {
            this.networkId = networkId;
            return this;
        }

        @CustomType.Setter
        public Builder region(String region) {
            if (region == null) {
                throw new MissingRequiredPropertyException("GetNetworkResult", "region");
            }
            this.region = region;
            return this;
        }

        @CustomType.Setter
        public Builder segments(List<GetNetworkSegment> segments) {
            if (segments == null) {
                throw new MissingRequiredPropertyException("GetNetworkResult", "segments");
            }
            this.segments = segments;
            return this;
        }

        public Builder segments(GetNetworkSegment ... segments) {
            return this.segments(List.of(segments));
        }

        @CustomType.Setter
        public Builder shared(String shared) {
            if (shared == null) {
                throw new MissingRequiredPropertyException("GetNetworkResult", "shared");
            }
            this.shared = shared;
            return this;
        }

        @CustomType.Setter
        public Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        @CustomType.Setter
        public Builder subnets(List<String> subnets) {
            if (subnets == null) {
                throw new MissingRequiredPropertyException("GetNetworkResult", "subnets");
            }
            this.subnets = subnets;
            return this;
        }

        public Builder subnets(String ... subnets) {
            return this.subnets(List.of(subnets));
        }

        @CustomType.Setter
        public Builder tags(@Nullable List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(String ... tags) {
            return this.tags(List.of(tags));
        }

        @CustomType.Setter
        public Builder tenantId(@Nullable String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @CustomType.Setter
        public Builder transparentVlan(@Nullable Boolean transparentVlan) {
            this.transparentVlan = transparentVlan;
            return this;
        }

        public GetNetworkResult build() {
            GetNetworkResult _resultValue = new GetNetworkResult();
            _resultValue.adminStateUp = this.adminStateUp;
            _resultValue.allTags = this.allTags;
            _resultValue.availabilityZoneHints = this.availabilityZoneHints;
            _resultValue.description = this.description;
            _resultValue.dnsDomain = this.dnsDomain;
            _resultValue.external = this.external;
            _resultValue.id = this.id;
            _resultValue.matchingSubnetCidr = this.matchingSubnetCidr;
            _resultValue.mtu = this.mtu;
            _resultValue.name = this.name;
            _resultValue.networkId = this.networkId;
            _resultValue.region = this.region;
            _resultValue.segments = this.segments;
            _resultValue.shared = this.shared;
            _resultValue.status = this.status;
            _resultValue.subnets = this.subnets;
            _resultValue.tags = this.tags;
            _resultValue.tenantId = this.tenantId;
            _resultValue.transparentVlan = this.transparentVlan;
            return _resultValue;
        }
    }
}

