/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.openstack.networking.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.openstack.networking.outputs.GetSubnetAllocationPool;
import com.pulumi.openstack.networking.outputs.GetSubnetHostRoute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetSubnetResult {
    private List<String> allTags;
    private List<GetSubnetAllocationPool> allocationPools;
    private String cidr;
    private String description;
    @Deprecated
    @Nullable
    private Boolean dhcpDisabled;
    @Nullable
    private Boolean dhcpEnabled;
    private List<String> dnsNameservers;
    private Boolean enableDhcp;
    private String gatewayIp;
    private List<GetSubnetHostRoute> hostRoutes;
    private String id;
    private Integer ipVersion;
    private String ipv6AddressMode;
    private String ipv6RaMode;
    private String name;
    private String networkId;
    private String region;
    private List<String> serviceTypes;
    private String subnetId;
    private String subnetpoolId;
    @Nullable
    private List<String> tags;
    private String tenantId;

    private GetSubnetResult() {
    }

    public List<String> allTags() {
        return this.allTags;
    }

    public List<GetSubnetAllocationPool> allocationPools() {
        return this.allocationPools;
    }

    public String cidr() {
        return this.cidr;
    }

    public String description() {
        return this.description;
    }

    @Deprecated
    public Optional<Boolean> dhcpDisabled() {
        return Optional.ofNullable(this.dhcpDisabled);
    }

    public Optional<Boolean> dhcpEnabled() {
        return Optional.ofNullable(this.dhcpEnabled);
    }

    public List<String> dnsNameservers() {
        return this.dnsNameservers;
    }

    public Boolean enableDhcp() {
        return this.enableDhcp;
    }

    public String gatewayIp() {
        return this.gatewayIp;
    }

    public List<GetSubnetHostRoute> hostRoutes() {
        return this.hostRoutes;
    }

    public String id() {
        return this.id;
    }

    public Integer ipVersion() {
        return this.ipVersion;
    }

    public String ipv6AddressMode() {
        return this.ipv6AddressMode;
    }

    public String ipv6RaMode() {
        return this.ipv6RaMode;
    }

    public String name() {
        return this.name;
    }

    public String networkId() {
        return this.networkId;
    }

    public String region() {
        return this.region;
    }

    public List<String> serviceTypes() {
        return this.serviceTypes;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String subnetpoolId() {
        return this.subnetpoolId;
    }

    public List<String> tags() {
        return this.tags == null ? List.of() : this.tags;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetSubnetResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> allTags;
        private List<GetSubnetAllocationPool> allocationPools;
        private String cidr;
        private String description;
        @Nullable
        private Boolean dhcpDisabled;
        @Nullable
        private Boolean dhcpEnabled;
        private List<String> dnsNameservers;
        private Boolean enableDhcp;
        private String gatewayIp;
        private List<GetSubnetHostRoute> hostRoutes;
        private String id;
        private Integer ipVersion;
        private String ipv6AddressMode;
        private String ipv6RaMode;
        private String name;
        private String networkId;
        private String region;
        private List<String> serviceTypes;
        private String subnetId;
        private String subnetpoolId;
        @Nullable
        private List<String> tags;
        private String tenantId;

        public Builder() {
        }

        public Builder(GetSubnetResult defaults) {
            Objects.requireNonNull(defaults);
            this.allTags = defaults.allTags;
            this.allocationPools = defaults.allocationPools;
            this.cidr = defaults.cidr;
            this.description = defaults.description;
            this.dhcpDisabled = defaults.dhcpDisabled;
            this.dhcpEnabled = defaults.dhcpEnabled;
            this.dnsNameservers = defaults.dnsNameservers;
            this.enableDhcp = defaults.enableDhcp;
            this.gatewayIp = defaults.gatewayIp;
            this.hostRoutes = defaults.hostRoutes;
            this.id = defaults.id;
            this.ipVersion = defaults.ipVersion;
            this.ipv6AddressMode = defaults.ipv6AddressMode;
            this.ipv6RaMode = defaults.ipv6RaMode;
            this.name = defaults.name;
            this.networkId = defaults.networkId;
            this.region = defaults.region;
            this.serviceTypes = defaults.serviceTypes;
            this.subnetId = defaults.subnetId;
            this.subnetpoolId = defaults.subnetpoolId;
            this.tags = defaults.tags;
            this.tenantId = defaults.tenantId;
        }

        @CustomType.Setter
        public Builder allTags(List<String> allTags) {
            if (allTags == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "allTags");
            }
            this.allTags = allTags;
            return this;
        }

        public Builder allTags(String ... allTags) {
            return this.allTags(List.of(allTags));
        }

        @CustomType.Setter
        public Builder allocationPools(List<GetSubnetAllocationPool> allocationPools) {
            if (allocationPools == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "allocationPools");
            }
            this.allocationPools = allocationPools;
            return this;
        }

        public Builder allocationPools(GetSubnetAllocationPool ... allocationPools) {
            return this.allocationPools(List.of(allocationPools));
        }

        @CustomType.Setter
        public Builder cidr(String cidr) {
            if (cidr == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "cidr");
            }
            this.cidr = cidr;
            return this;
        }

        @CustomType.Setter
        public Builder description(String description) {
            if (description == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "description");
            }
            this.description = description;
            return this;
        }

        @CustomType.Setter
        public Builder dhcpDisabled(@Nullable Boolean dhcpDisabled) {
            this.dhcpDisabled = dhcpDisabled;
            return this;
        }

        @CustomType.Setter
        public Builder dhcpEnabled(@Nullable Boolean dhcpEnabled) {
            this.dhcpEnabled = dhcpEnabled;
            return this;
        }

        @CustomType.Setter
        public Builder dnsNameservers(List<String> dnsNameservers) {
            if (dnsNameservers == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "dnsNameservers");
            }
            this.dnsNameservers = dnsNameservers;
            return this;
        }

        public Builder dnsNameservers(String ... dnsNameservers) {
            return this.dnsNameservers(List.of(dnsNameservers));
        }

        @CustomType.Setter
        public Builder enableDhcp(Boolean enableDhcp) {
            if (enableDhcp == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "enableDhcp");
            }
            this.enableDhcp = enableDhcp;
            return this;
        }

        @CustomType.Setter
        public Builder gatewayIp(String gatewayIp) {
            if (gatewayIp == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "gatewayIp");
            }
            this.gatewayIp = gatewayIp;
            return this;
        }

        @CustomType.Setter
        public Builder hostRoutes(List<GetSubnetHostRoute> hostRoutes) {
            if (hostRoutes == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "hostRoutes");
            }
            this.hostRoutes = hostRoutes;
            return this;
        }

        public Builder hostRoutes(GetSubnetHostRoute ... hostRoutes) {
            return this.hostRoutes(List.of(hostRoutes));
        }

        @CustomType.Setter
        public Builder id(String id) {
            if (id == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "id");
            }
            this.id = id;
            return this;
        }

        @CustomType.Setter
        public Builder ipVersion(Integer ipVersion) {
            if (ipVersion == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "ipVersion");
            }
            this.ipVersion = ipVersion;
            return this;
        }

        @CustomType.Setter
        public Builder ipv6AddressMode(String ipv6AddressMode) {
            if (ipv6AddressMode == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "ipv6AddressMode");
            }
            this.ipv6AddressMode = ipv6AddressMode;
            return this;
        }

        @CustomType.Setter
        public Builder ipv6RaMode(String ipv6RaMode) {
            if (ipv6RaMode == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "ipv6RaMode");
            }
            this.ipv6RaMode = ipv6RaMode;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder networkId(String networkId) {
            if (networkId == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "networkId");
            }
            this.networkId = networkId;
            return this;
        }

        @CustomType.Setter
        public Builder region(String region) {
            if (region == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "region");
            }
            this.region = region;
            return this;
        }

        @CustomType.Setter
        public Builder serviceTypes(List<String> serviceTypes) {
            if (serviceTypes == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "serviceTypes");
            }
            this.serviceTypes = serviceTypes;
            return this;
        }

        public Builder serviceTypes(String ... serviceTypes) {
            return this.serviceTypes(List.of(serviceTypes));
        }

        @CustomType.Setter
        public Builder subnetId(String subnetId) {
            if (subnetId == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "subnetId");
            }
            this.subnetId = subnetId;
            return this;
        }

        @CustomType.Setter
        public Builder subnetpoolId(String subnetpoolId) {
            if (subnetpoolId == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "subnetpoolId");
            }
            this.subnetpoolId = subnetpoolId;
            return this;
        }

        @CustomType.Setter
        public Builder tags(@Nullable List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(String ... tags) {
            return this.tags(List.of(tags));
        }

        @CustomType.Setter
        public Builder tenantId(String tenantId) {
            if (tenantId == null) {
                throw new MissingRequiredPropertyException("GetSubnetResult", "tenantId");
            }
            this.tenantId = tenantId;
            return this;
        }

        public GetSubnetResult build() {
            GetSubnetResult _resultValue = new GetSubnetResult();
            _resultValue.allTags = this.allTags;
            _resultValue.allocationPools = this.allocationPools;
            _resultValue.cidr = this.cidr;
            _resultValue.description = this.description;
            _resultValue.dhcpDisabled = this.dhcpDisabled;
            _resultValue.dhcpEnabled = this.dhcpEnabled;
            _resultValue.dnsNameservers = this.dnsNameservers;
            _resultValue.enableDhcp = this.enableDhcp;
            _resultValue.gatewayIp = this.gatewayIp;
            _resultValue.hostRoutes = this.hostRoutes;
            _resultValue.id = this.id;
            _resultValue.ipVersion = this.ipVersion;
            _resultValue.ipv6AddressMode = this.ipv6AddressMode;
            _resultValue.ipv6RaMode = this.ipv6RaMode;
            _resultValue.name = this.name;
            _resultValue.networkId = this.networkId;
            _resultValue.region = this.region;
            _resultValue.serviceTypes = this.serviceTypes;
            _resultValue.subnetId = this.subnetId;
            _resultValue.subnetpoolId = this.subnetpoolId;
            _resultValue.tags = this.tags;
            _resultValue.tenantId = this.tenantId;
            return _resultValue;
        }
    }
}

