/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.openstack.networking.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class NetworkSegment {
    @Nullable
    private String networkType;
    @Nullable
    private String physicalNetwork;
    @Nullable
    private Integer segmentationId;

    private NetworkSegment() {
    }

    public Optional<String> networkType() {
        return Optional.ofNullable(this.networkType);
    }

    public Optional<String> physicalNetwork() {
        return Optional.ofNullable(this.physicalNetwork);
    }

    public Optional<Integer> segmentationId() {
        return Optional.ofNullable(this.segmentationId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(NetworkSegment defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String networkType;
        @Nullable
        private String physicalNetwork;
        @Nullable
        private Integer segmentationId;

        public Builder() {
        }

        public Builder(NetworkSegment defaults) {
            Objects.requireNonNull(defaults);
            this.networkType = defaults.networkType;
            this.physicalNetwork = defaults.physicalNetwork;
            this.segmentationId = defaults.segmentationId;
        }

        @CustomType.Setter
        public Builder networkType(@Nullable String networkType) {
            this.networkType = networkType;
            return this;
        }

        @CustomType.Setter
        public Builder physicalNetwork(@Nullable String physicalNetwork) {
            this.physicalNetwork = physicalNetwork;
            return this;
        }

        @CustomType.Setter
        public Builder segmentationId(@Nullable Integer segmentationId) {
            this.segmentationId = segmentationId;
            return this;
        }

        public NetworkSegment build() {
            NetworkSegment _resultValue = new NetworkSegment();
            _resultValue.networkType = this.networkType;
            _resultValue.physicalNetwork = this.physicalNetwork;
            _resultValue.segmentationId = this.segmentationId;
            return _resultValue;
        }
    }
}

