// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.random;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.random.RandomBytesArgs;
import com.pulumi.random.Utilities;
import com.pulumi.random.inputs.RandomBytesState;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * The resource `random.RandomBytes` generates random bytes that are intended to be used as a secret, or key. Use this in preference to `random.RandomId` when the output is considered sensitive, and should not be displayed in the CLI.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.RandomBytes;
 * import com.pulumi.random.RandomBytesArgs;
 * import com.pulumi.azure.keyvault.Secret;
 * import com.pulumi.azure.keyvault.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var jwtSecretRandomBytes = new RandomBytes(&#34;jwtSecretRandomBytes&#34;, RandomBytesArgs.builder()        
 *             .length(64)
 *             .build());
 * 
 *         var jwtSecretSecret = new Secret(&#34;jwtSecretSecret&#34;, SecretArgs.builder()        
 *             .keyVaultId(&#34;some-azure-key-vault-id&#34;)
 *             .value(jwtSecretRandomBytes.base64())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Random bytes can be imported by specifying the value as base64 string.
 * 
 * ```sh
 *  $ pulumi import random:index/randomBytes:RandomBytes basic &#34;8/fu3q+2DcgSJ19i0jZ5Cw==&#34;
 * ```
 * 
 */
@ResourceType(type="random:index/randomBytes:RandomBytes")
public class RandomBytes extends com.pulumi.resources.CustomResource {
    /**
     * The generated bytes presented in base64 string format.
     * 
     */
    @Export(name="base64", refs={String.class}, tree="[0]")
    private Output<String> base64;

    /**
     * @return The generated bytes presented in base64 string format.
     * 
     */
    public Output<String> base64() {
        return this.base64;
    }
    /**
     * The generated bytes presented in hex string format.
     * 
     */
    @Export(name="hex", refs={String.class}, tree="[0]")
    private Output<String> hex;

    /**
     * @return The generated bytes presented in hex string format.
     * 
     */
    public Output<String> hex() {
        return this.hex;
    }
    /**
     * Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
     * 
     */
    @Export(name="keepers", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> keepers;

    /**
     * @return Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
     * 
     */
    public Output<Optional<Map<String,String>>> keepers() {
        return Codegen.optional(this.keepers);
    }
    /**
     * The number of bytes requested. The minimum value for length is 1.
     * 
     */
    @Export(name="length", refs={Integer.class}, tree="[0]")
    private Output<Integer> length;

    /**
     * @return The number of bytes requested. The minimum value for length is 1.
     * 
     */
    public Output<Integer> length() {
        return this.length;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public RandomBytes(String name) {
        this(name, RandomBytesArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public RandomBytes(String name, RandomBytesArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public RandomBytes(String name, RandomBytesArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("random:index/randomBytes:RandomBytes", name, args == null ? RandomBytesArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private RandomBytes(String name, Output<String> id, @Nullable RandomBytesState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("random:index/randomBytes:RandomBytes", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "base64",
                "hex"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static RandomBytes get(String name, Output<String> id, @Nullable RandomBytesState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new RandomBytes(name, id, state, options);
    }
}
