/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class JavadocTypeCheck
extends AbstractCheck {
    public static final String MSG_UNKNOWN_TAG = "javadoc.unknownTag";
    public static final String MSG_TAG_FORMAT = "type.tagFormat";
    public static final String MSG_MISSING_TAG = "type.missingTag";
    public static final String MSG_UNUSED_TAG = "javadoc.unusedTag";
    public static final String MSG_UNUSED_TAG_GENERAL = "javadoc.unusedTagGeneral";
    private static final String OPEN_ANGLE_BRACKET = "<";
    private static final String CLOSE_ANGLE_BRACKET = ">";
    private static final String SPACE = " ";
    private static final Pattern TYPE_NAME_IN_JAVADOC_TAG = Pattern.compile("\\s*<([^>]+)>.*");
    private static final Pattern TYPE_NAME_IN_JAVADOC_TAG_SPLITTER = Pattern.compile("\\s+");
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern authorFormat;
    private Pattern versionFormat;
    private boolean allowMissingParamTags;
    private boolean allowUnknownTags;
    private List<String> allowedAnnotations = Collections.singletonList("Generated");

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    public void setAuthorFormat(Pattern pattern) {
        this.authorFormat = pattern;
    }

    public void setVersionFormat(Pattern pattern) {
        this.versionFormat = pattern;
    }

    public void setAllowMissingParamTags(boolean flag) {
        this.allowMissingParamTags = flag;
    }

    public void setAllowUnknownTags(boolean flag) {
        this.allowUnknownTags = flag;
    }

    public void setAllowedAnnotations(String ... userAnnotations) {
        this.allowedAnnotations = Arrays.asList(userAnnotations);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 199};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int lineNo;
        FileContents contents;
        TextBlock textBlock;
        if (this.shouldCheck(ast) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(lineNo = ast.getLineNo())) != null) {
            List<JavadocTag> tags = this.getJavadocTags(textBlock);
            if (ScopeUtil.isOuterMostType(ast)) {
                this.checkTag(ast, tags, JavadocTagInfo.AUTHOR.getName(), this.authorFormat);
                this.checkTag(ast, tags, JavadocTagInfo.VERSION.getName(), this.versionFormat);
            }
            List<String> typeParamNames = CheckUtil.getTypeParameterNames(ast);
            List<String> recordComponentNames = JavadocTypeCheck.getRecordComponentNames(ast);
            if (!this.allowMissingParamTags) {
                typeParamNames.forEach(typeParamName -> this.checkTypeParamTag(ast, tags, (String)typeParamName));
                recordComponentNames.forEach(componentName -> this.checkComponentParamTag(ast, tags, (String)componentName));
            }
            this.checkUnusedParamTags(tags, typeParamNames, recordComponentNames);
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        Scope customScope = ScopeUtil.getScope(ast);
        Scope surroundingScope = ScopeUtil.getSurroundingScope(ast);
        return customScope.isIn(this.scope) && (surroundingScope == null || surroundingScope.isIn(this.scope)) && (this.excludeScope == null || !customScope.isIn(this.excludeScope) || surroundingScope != null && !surroundingScope.isIn(this.excludeScope)) && !AnnotationUtil.containsAnnotation(ast, this.allowedAnnotations);
    }

    private List<JavadocTag> getJavadocTags(TextBlock textBlock) {
        JavadocTags tags = JavadocUtil.getJavadocTags(textBlock, JavadocUtil.JavadocTagType.BLOCK);
        if (!this.allowUnknownTags) {
            for (InvalidJavadocTag tag : tags.getInvalidTags()) {
                this.log(tag.getLine(), tag.getCol(), MSG_UNKNOWN_TAG, tag.getName());
            }
        }
        return tags.getValidTags();
    }

    private void checkTag(DetailAST ast, List<JavadocTag> tags, String tagName, Pattern formatPattern) {
        if (formatPattern != null) {
            boolean hasTag = false;
            String tagPrefix = "@";
            for (JavadocTag tag : tags) {
                if (!tag.getTagName().equals(tagName)) continue;
                hasTag = true;
                if (formatPattern.matcher(tag.getFirstArg()).find()) continue;
                this.log(ast, MSG_TAG_FORMAT, "@" + tagName, formatPattern.pattern());
            }
            if (!hasTag) {
                this.log(ast, MSG_MISSING_TAG, "@" + tagName);
            }
        }
    }

    private void checkComponentParamTag(DetailAST ast, List<JavadocTag> tags, String recordComponentName) {
        boolean found = tags.stream().filter(JavadocTag::isParamTag).anyMatch(tag -> tag.getFirstArg().indexOf(recordComponentName) == 0);
        if (!found) {
            this.log(ast, MSG_MISSING_TAG, JavadocTagInfo.PARAM.getText() + SPACE + recordComponentName);
        }
    }

    private void checkTypeParamTag(DetailAST ast, List<JavadocTag> tags, String typeParamName) {
        String typeParamNameWithBrackets = OPEN_ANGLE_BRACKET + typeParamName + CLOSE_ANGLE_BRACKET;
        boolean found = tags.stream().filter(JavadocTag::isParamTag).anyMatch(tag -> tag.getFirstArg().indexOf(typeParamNameWithBrackets) == 0);
        if (!found) {
            this.log(ast, MSG_MISSING_TAG, JavadocTagInfo.PARAM.getText() + SPACE + typeParamNameWithBrackets);
        }
    }

    private void checkUnusedParamTags(List<JavadocTag> tags, List<String> typeParamNames, List<String> recordComponentNames) {
        for (JavadocTag tag : tags) {
            String paramName;
            boolean found;
            if (!tag.isParamTag() || (found = typeParamNames.contains(paramName = JavadocTypeCheck.extractParamNameFromTag(tag)) || recordComponentNames.contains(paramName))) continue;
            String actualParamName = TYPE_NAME_IN_JAVADOC_TAG_SPLITTER.split(tag.getFirstArg())[0];
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, JavadocTagInfo.PARAM.getText(), actualParamName);
        }
    }

    private static String extractParamNameFromTag(JavadocTag tag) {
        Matcher matchInAngleBrackets = TYPE_NAME_IN_JAVADOC_TAG.matcher(tag.getFirstArg());
        String typeParamName = matchInAngleBrackets.find() ? matchInAngleBrackets.group(1).trim() : TYPE_NAME_IN_JAVADOC_TAG_SPLITTER.split(tag.getFirstArg())[0];
        return typeParamName;
    }

    private static List<String> getRecordComponentNames(DetailAST node) {
        DetailAST components = node.findFirstToken(201);
        ArrayList<String> componentList = new ArrayList<String>();
        if (components != null) {
            TokenUtil.forEachChild(components, 202, component -> {
                DetailAST ident = component.findFirstToken(58);
                componentList.add(ident.getText());
            });
        }
        return componentList;
    }
}

