/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.utils.UnmodifiableCollectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlLoader
extends DefaultHandler {
    private final Map<String, String> publicIdToResourceNameMap;
    private final XMLReader parser;

    protected XmlLoader(Map<String, String> publicIdToResourceNameMap) throws SAXException, ParserConfigurationException {
        this.publicIdToResourceNameMap = UnmodifiableCollectionUtil.copyOfMap(publicIdToResourceNameMap);
        this.parser = XmlLoader.createXmlReader(this);
    }

    public void parseInputSource(InputSource inputSource) throws IOException, SAXException {
        this.parser.parse(inputSource);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        String dtdResourceName;
        InputSource inputSource = null;
        if (publicId != null && (dtdResourceName = this.publicIdToResourceNameMap.get(publicId)) != null) {
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream dtdIs = loader.getResourceAsStream(dtdResourceName);
            inputSource = new InputSource(dtdIs);
        }
        return inputSource;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    private static XMLReader createXmlReader(DefaultHandler handler) throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        LoadExternalDtdFeatureProvider.setFeaturesBySystemProperty(factory);
        factory.setValidating(true);
        XMLReader xmlReader = factory.newSAXParser().getXMLReader();
        xmlReader.setContentHandler(handler);
        xmlReader.setEntityResolver(handler);
        xmlReader.setErrorHandler(handler);
        return xmlReader;
    }

    public static final class LoadExternalDtdFeatureProvider {
        public static final String ENABLE_EXTERNAL_DTD_LOAD = "checkstyle.enableExternalDtdLoad";
        public static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        public static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
        public static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";

        private LoadExternalDtdFeatureProvider() {
        }

        public static void setFeaturesBySystemProperty(SAXParserFactory factory) throws SAXException, ParserConfigurationException {
            boolean enableExternalDtdLoad = Boolean.parseBoolean(System.getProperty(ENABLE_EXTERNAL_DTD_LOAD, "false"));
            factory.setFeature(LOAD_EXTERNAL_DTD, enableExternalDtdLoad);
            factory.setFeature(EXTERNAL_GENERAL_ENTITIES, enableExternalDtdLoad);
            factory.setFeature(EXTERNAL_PARAMETER_ENTITIES, enableExternalDtdLoad);
        }
    }
}

