/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.PropertyCacheFile;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.BeforeExecutionFileFilter;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpMultilineCheck;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineCheck;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineJavaCheck;
import com.puppycrawl.tools.checkstyle.site.ClassAndPropertiesSettersJavadocScraper;
import com.puppycrawl.tools.checkstyle.site.ViolationMessagesMacro;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.maven.doxia.macro.MacroExecutionException;

public final class SiteUtil {
    public static final String TOKENS = "tokens";
    public static final String JAVADOC_TOKENS = "javadocTokens";
    public static final String DOT = ".";
    public static final String COMMA_SPACE = ", ";
    public static final String TOKEN_TYPES = "TokenTypes";
    public static final String PATH_TO_TOKEN_TYPES = "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html";
    public static final String PATH_TO_JAVADOC_TOKEN_TYPES = "apidocs/com/puppycrawl/tools/checkstyle/api/JavadocTokenTypes.html";
    private static final String CHECKSTYLE_ORG_URL = "https://checkstyle.org/";
    private static final String CHARSET = "charset";
    private static final String CURLY_BRACKETS = "{}";
    private static final String FILE_EXTENSIONS = "fileExtensions";
    private static final String CHECKS = "checks";
    private static final String NAMING = "naming";
    private static final String SRC = "src";
    private static final Pattern SETTER_PATTERN = Pattern.compile("^Setter to ");
    private static final Map<Class<?>, String> CLASS_TO_PARENT_MODULE = Map.ofEntries(Map.entry(AbstractCheck.class, TreeWalker.class.getSimpleName()), Map.entry(TreeWalkerFilter.class, TreeWalker.class.getSimpleName()), Map.entry(AbstractFileSetCheck.class, Checker.class.getSimpleName()), Map.entry(Filter.class, Checker.class.getSimpleName()), Map.entry(BeforeExecutionFileFilter.class, Checker.class.getSimpleName()));
    private static final Set<String> CHECK_PROPERTIES = SiteUtil.getProperties(AbstractCheck.class);
    private static final Set<String> JAVADOC_CHECK_PROPERTIES = SiteUtil.getProperties(AbstractJavadocCheck.class);
    private static final Set<String> FILESET_PROPERTIES = SiteUtil.getProperties(AbstractFileSetCheck.class);
    private static final String HEADER_CHECK_HEADER = "HeaderCheck.header";
    private static final String REGEXP_HEADER_CHECK_HEADER = "RegexpHeaderCheck.header";
    private static final Set<String> UNDOCUMENTED_PROPERTIES = Set.of("SuppressWithNearbyCommentFilter.fileContents", "SuppressionCommentFilter.fileContents");
    private static final Set<String> PROPERTIES_ALLOWED_GET_TYPES_FROM_METHOD = Set.of("SuppressWarningsHolder.aliasList", "HeaderCheck.header", "RegexpHeaderCheck.header", "CustomImportOrderCheck.customImportOrderRules");
    private static final String VERSION_6_9 = "6.9";
    private static final String VERSION_5_0 = "5.0";
    private static final String VERSION_3_2 = "3.2";
    private static final String V824 = "8.24";
    private static final String VERSION_3_0 = "3.0";
    private static final String VERSION_7_7 = "7.7";
    private static final String VERSION_5_7 = "5.7";
    private static final String VERSION_3_4 = "3.4";
    private static final Map<String, String> SINCE_VERSION_FOR_INHERITED_PROPERTY = Map.ofEntries(Map.entry("MissingDeprecatedCheck.violateExecutionOnNonTightHtml", "8.24"), Map.entry("NonEmptyAtclauseDescriptionCheck.violateExecutionOnNonTightHtml", "8.3"), Map.entry("HeaderCheck.charset", "5.0"), Map.entry("HeaderCheck.fileExtensions", "6.9"), Map.entry("HeaderCheck.headerFile", "3.2"), Map.entry("HeaderCheck.header", "5.0"), Map.entry("RegexpHeaderCheck.charset", "5.0"), Map.entry("RegexpHeaderCheck.fileExtensions", "6.9"), Map.entry("RegexpHeaderCheck.headerFile", "3.2"), Map.entry("RegexpHeaderCheck.header", "5.0"), Map.entry("ClassDataAbstractionCouplingCheck.excludeClassesRegexps", "7.7"), Map.entry("ClassDataAbstractionCouplingCheck.excludedClasses", "5.7"), Map.entry("ClassDataAbstractionCouplingCheck.excludedPackages", "7.7"), Map.entry("ClassDataAbstractionCouplingCheck.max", "3.4"), Map.entry("ClassFanOutComplexityCheck.excludeClassesRegexps", "7.7"), Map.entry("ClassFanOutComplexityCheck.excludedClasses", "5.7"), Map.entry("ClassFanOutComplexityCheck.excludedPackages", "7.7"), Map.entry("ClassFanOutComplexityCheck.max", "3.4"), Map.entry("NonEmptyAtclauseDescriptionCheck.javadocTokens", "7.3"), Map.entry("FileTabCharacterCheck.fileExtensions", "5.0"), Map.entry("NewlineAtEndOfFileCheck.fileExtensions", "3.1"), Map.entry("JavadocPackageCheck.fileExtensions", "5.0"), Map.entry("LineLengthCheck.fileExtensions", "8.24"), Map.entry("JavadocBlockTagLocationCheck.violateExecutionOnNonTightHtml", "8.24"), Map.entry("JavadocMissingLeadingAsteriskCheck.violateExecutionOnNonTightHtml", "8.38"), Map.entry("ParenPadCheck.option", "3.0"), Map.entry("TypecastParenPadCheck.option", "3.2"), Map.entry("FileLengthCheck.fileExtensions", "5.0"), Map.entry("StaticVariableNameCheck.applyToPackage", "5.0"), Map.entry("StaticVariableNameCheck.applyToPrivate", "5.0"), Map.entry("StaticVariableNameCheck.applyToProtected", "5.0"), Map.entry("StaticVariableNameCheck.applyToPublic", "5.0"), Map.entry("StaticVariableNameCheck.format", "3.0"), Map.entry("TypeNameCheck.applyToPackage", "5.0"), Map.entry("TypeNameCheck.applyToPrivate", "5.0"), Map.entry("TypeNameCheck.applyToProtected", "5.0"), Map.entry("TypeNameCheck.applyToPublic", "5.0"), Map.entry("RegexpMultilineCheck.fileExtensions", "5.0"), Map.entry("RegexpOnFilenameCheck.fileExtensions", "6.15"), Map.entry("RegexpSinglelineCheck.fileExtensions", "5.0"), Map.entry("ClassTypeParameterNameCheck.format", "5.0"), Map.entry("CatchParameterNameCheck.format", "6.14"), Map.entry("TypeNameCheck.format", "3.0"));
    private static final Map<String, DetailNode> SUPER_CLASS_PROPERTIES_JAVADOCS = new HashMap<String, DetailNode>();
    private static final String MAIN_FOLDER_PATH = Paths.get("src", "main", "java", "com", "puppycrawl", "tools", "checkstyle").toString();
    private static final List<File> MODULE_SUPER_CLASS_FILES = List.of(new File(Paths.get(MAIN_FOLDER_PATH, "checks", "naming", "AbstractAccessControlNameCheck.java").toString()), new File(Paths.get(MAIN_FOLDER_PATH, "checks", "naming", "AbstractNameCheck.java").toString()), new File(Paths.get(MAIN_FOLDER_PATH, "checks", "javadoc", "AbstractJavadocCheck.java").toString()), new File(Paths.get(MAIN_FOLDER_PATH, "api", "AbstractFileSetCheck.java").toString()), new File(Paths.get(MAIN_FOLDER_PATH, "checks", "header", "AbstractHeaderCheck.java").toString()), new File(Paths.get(MAIN_FOLDER_PATH, "checks", "metrics", "AbstractClassCouplingCheck.java").toString()), new File(Paths.get(MAIN_FOLDER_PATH, "checks", "whitespace", "AbstractParenPadCheck.java").toString()));

    private SiteUtil() {
    }

    public static Set<String> getMessageKeys(Class<?> module) throws MacroExecutionException {
        Set<Field> messageKeyFields = SiteUtil.getCheckMessageKeys(module);
        TreeSet<String> messageKeys = new TreeSet<String>();
        for (Field field : messageKeyFields) {
            messageKeys.add(SiteUtil.getFieldValue(field, module).toString());
        }
        return messageKeys;
    }

    private static Set<Field> getCheckMessageKeys(Class<?> module) throws MacroExecutionException {
        try {
            Field[] fields;
            HashSet<Field> checkstyleMessages = new HashSet<Field>();
            for (Field field : fields = module.getDeclaredFields()) {
                if (!field.getName().startsWith("MSG_")) continue;
                checkstyleMessages.add(field);
            }
            Class<?> superModule = module.getSuperclass();
            if (superModule != null) {
                checkstyleMessages.addAll(SiteUtil.getCheckMessageKeys(superModule));
            }
            if (module == RegexpMultilineCheck.class) {
                checkstyleMessages.addAll(SiteUtil.getCheckMessageKeys(Class.forName("com.puppycrawl.tools.checkstyle.checks.regexp.MultilineDetector")));
            } else if (module == RegexpSinglelineCheck.class || module == RegexpSinglelineJavaCheck.class) {
                checkstyleMessages.addAll(SiteUtil.getCheckMessageKeys(Class.forName("com.puppycrawl.tools.checkstyle.checks.regexp.SinglelineDetector")));
            }
            return checkstyleMessages;
        }
        catch (ClassNotFoundException ex) {
            String message = String.format(Locale.ROOT, "Couldn't find class: %s", module.getName());
            throw new MacroExecutionException(message, (Throwable)ex);
        }
    }

    public static Object getFieldValue(Field field, Object instance) throws MacroExecutionException {
        try {
            field.trySetAccessible();
            return field.get(instance);
        }
        catch (IllegalAccessException ex) {
            throw new MacroExecutionException("Couldn't get field value", (Throwable)ex);
        }
    }

    public static Object getModuleInstance(String moduleName) throws MacroExecutionException {
        PackageObjectFactory factory = SiteUtil.getPackageObjectFactory();
        try {
            return factory.createModule(moduleName);
        }
        catch (CheckstyleException ex) {
            throw new MacroExecutionException("Couldn't find class: " + moduleName, (Throwable)ex);
        }
    }

    private static PackageObjectFactory getPackageObjectFactory() throws MacroExecutionException {
        try {
            ClassLoader cl = ViolationMessagesMacro.class.getClassLoader();
            Set<String> packageNames = PackageNamesLoader.getPackageNames(cl);
            return new PackageObjectFactory(packageNames, cl);
        }
        catch (CheckstyleException ex) {
            throw new MacroExecutionException("Couldn't load checkstyle modules", (Throwable)ex);
        }
    }

    public static String getNewlineAndIndentSpaces(int amountOfSpaces) {
        return System.lineSeparator() + " ".repeat(amountOfSpaces);
    }

    public static Path getTemplatePath(String moduleName) throws MacroExecutionException {
        String fileNamePattern = ".*[\\\\/]" + moduleName.toLowerCase(Locale.ROOT) + "\\..*";
        return SiteUtil.getXdocsTemplatesFilePaths().stream().filter(path -> path.toString().matches(fileNamePattern)).findFirst().orElse(null);
    }

    public static Set<Path> getXdocsTemplatesFilePaths() throws MacroExecutionException {
        Set<Path> set;
        block8: {
            Path directory = Paths.get("src/xdocs", new String[0]);
            Stream<Path> stream = Files.find(directory, Integer.MAX_VALUE, (path, attr) -> attr.isRegularFile() && path.toString().endsWith(".xml.template"), new FileVisitOption[0]);
            try {
                set = stream.collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    throw new MacroExecutionException("Failed to find xdocs templates", (Throwable)ioException);
                }
            }
            stream.close();
        }
        return set;
    }

    public static String getParentModule(Class<?> moduleClass) throws MacroExecutionException {
        String parentModuleName = "";
        for (Class<?> parentClass = moduleClass.getSuperclass(); parentClass != null && (parentModuleName = CLASS_TO_PARENT_MODULE.get(parentClass)) == null; parentClass = parentClass.getSuperclass()) {
        }
        if (parentModuleName == null || parentModuleName.isEmpty()) {
            Class<?> interfaceClass;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = moduleClass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (parentModuleName = CLASS_TO_PARENT_MODULE.get(interfaceClass = classArray[i])) == null; ++i) {
            }
        }
        if (parentModuleName == null || parentModuleName.isEmpty()) {
            String message = String.format(Locale.ROOT, "Failed to find parent module for %s", moduleClass.getSimpleName());
            throw new MacroExecutionException(message);
        }
        return parentModuleName;
    }

    public static Set<String> getPropertiesForDocumentation(Class<?> clss, Object instance) {
        Set properties = SiteUtil.getProperties(clss).stream().filter(prop -> !SiteUtil.isGlobalProperty(clss, prop) && !SiteUtil.isUndocumentedProperty(clss, prop)).collect(Collectors.toSet());
        properties.addAll(SiteUtil.getNonExplicitProperties(instance, clss));
        return new TreeSet<String>(properties);
    }

    public static Map<String, DetailNode> getPropertiesJavadocs(Set<String> properties, String moduleName, File moduleFile) throws MacroExecutionException {
        if (SUPER_CLASS_PROPERTIES_JAVADOCS.isEmpty()) {
            SiteUtil.processSuperclasses();
        }
        SiteUtil.processModule(moduleName, moduleFile);
        Map<String, DetailNode> unmodifiableJavadocs = ClassAndPropertiesSettersJavadocScraper.getJavadocsForModuleOrProperty();
        LinkedHashMap<String, DetailNode> javadocs = new LinkedHashMap<String, DetailNode>(unmodifiableJavadocs);
        properties.forEach(property -> {
            DetailNode superClassPropertyJavadoc = SUPER_CLASS_PROPERTIES_JAVADOCS.get(property);
            if (superClassPropertyJavadoc != null) {
                javadocs.putIfAbsent((String)property, superClassPropertyJavadoc);
            }
        });
        SiteUtil.assertAllPropertySetterJavadocsAreFound(properties, moduleName, javadocs);
        return javadocs;
    }

    private static void assertAllPropertySetterJavadocsAreFound(Set<String> properties, String moduleName, Map<String, DetailNode> javadocs) throws MacroExecutionException {
        for (String property : properties) {
            boolean isPropertySetterJavadocFound = javadocs.containsKey(property) || TOKENS.equals(property) || JAVADOC_TOKENS.equals(property);
            if (isPropertySetterJavadocFound) continue;
            String message = String.format(Locale.ROOT, "%s: Failed to find setter javadoc for property '%s'", moduleName, property);
            throw new MacroExecutionException(message);
        }
    }

    private static void processSuperclasses() throws MacroExecutionException {
        for (File superclassFile : MODULE_SUPER_CLASS_FILES) {
            String superclassName = CommonUtil.getFileNameWithoutExtension(superclassFile.getName());
            SiteUtil.processModule(superclassName, superclassFile);
            Map<String, DetailNode> superclassJavadocs = ClassAndPropertiesSettersJavadocScraper.getJavadocsForModuleOrProperty();
            SUPER_CLASS_PROPERTIES_JAVADOCS.putAll(superclassJavadocs);
        }
    }

    private static void processModule(String moduleName, File moduleFile) throws MacroExecutionException {
        if (!moduleFile.isFile()) {
            String message = String.format(Locale.ROOT, "File %s is not a file. Please check the 'modulePath' property.", moduleFile);
            throw new MacroExecutionException(message);
        }
        ClassAndPropertiesSettersJavadocScraper.initialize(moduleName);
        Checker checker = new Checker();
        checker.setModuleClassLoader(Checker.class.getClassLoader());
        DefaultConfiguration scraperCheckConfig = new DefaultConfiguration(ClassAndPropertiesSettersJavadocScraper.class.getName());
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("configuration");
        DefaultConfiguration treeWalkerConfig = new DefaultConfiguration(TreeWalker.class.getName());
        defaultConfiguration.addProperty(CHARSET, StandardCharsets.UTF_8.name());
        defaultConfiguration.addChild(treeWalkerConfig);
        treeWalkerConfig.addChild(scraperCheckConfig);
        try {
            checker.configure(defaultConfiguration);
            List<File> filesToProcess = List.of(moduleFile);
            checker.process(filesToProcess);
            checker.destroy();
        }
        catch (CheckstyleException checkstyleException) {
            String message = String.format(Locale.ROOT, "Failed processing %s", moduleName);
            throw new MacroExecutionException(message, (Throwable)checkstyleException);
        }
    }

    public static Set<String> getProperties(Class<?> clss) {
        PropertyDescriptor[] propertyDescriptors;
        TreeSet<String> result = new TreeSet<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(clss)) {
            if (propertyDescriptor.getWriteMethod() == null) continue;
            result.add(propertyDescriptor.getName());
        }
        return result;
    }

    private static boolean isGlobalProperty(Class<?> clss, String propertyName) {
        return AbstractCheck.class.isAssignableFrom(clss) && CHECK_PROPERTIES.contains(propertyName) || AbstractJavadocCheck.class.isAssignableFrom(clss) && JAVADOC_CHECK_PROPERTIES.contains(propertyName) || AbstractFileSetCheck.class.isAssignableFrom(clss) && FILESET_PROPERTIES.contains(propertyName);
    }

    private static boolean isUndocumentedProperty(Class<?> clss, String propertyName) {
        return UNDOCUMENTED_PROPERTIES.contains(clss.getSimpleName() + DOT + propertyName);
    }

    private static Set<String> getNonExplicitProperties(Object instance, Class<?> clss) {
        AbstractCheck check;
        TreeSet<String> result = new TreeSet<String>();
        if (AbstractCheck.class.isAssignableFrom(clss)) {
            check = (AbstractCheck)instance;
            int[] acceptableTokens = check.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            int[] defaultTokens = check.getDefaultTokens();
            Arrays.sort(defaultTokens);
            int[] requiredTokens = check.getRequiredTokens();
            Arrays.sort(requiredTokens);
            if (!Arrays.equals(acceptableTokens, defaultTokens) || !Arrays.equals(acceptableTokens, requiredTokens)) {
                result.add(TOKENS);
            }
        }
        if (AbstractJavadocCheck.class.isAssignableFrom(clss)) {
            check = (AbstractJavadocCheck)instance;
            result.add("violateExecutionOnNonTightHtml");
            int[] acceptableJavadocTokens = ((AbstractJavadocCheck)check).getAcceptableJavadocTokens();
            Arrays.sort(acceptableJavadocTokens);
            int[] defaultJavadocTokens = ((AbstractJavadocCheck)check).getDefaultJavadocTokens();
            Arrays.sort(defaultJavadocTokens);
            int[] requiredJavadocTokens = ((AbstractJavadocCheck)check).getRequiredJavadocTokens();
            Arrays.sort(requiredJavadocTokens);
            if (!Arrays.equals(acceptableJavadocTokens, defaultJavadocTokens) || !Arrays.equals(acceptableJavadocTokens, requiredJavadocTokens)) {
                result.add(JAVADOC_TOKENS);
            }
        }
        if (AbstractFileSetCheck.class.isAssignableFrom(clss)) {
            result.add(FILE_EXTENSIONS);
        }
        return result;
    }

    public static String getPropertyDescription(String propertyName, DetailNode javadoc, String moduleName) throws MacroExecutionException {
        Object description;
        if (TOKENS.equals(propertyName)) {
            description = "tokens to check";
        } else if (JAVADOC_TOKENS.equals(propertyName)) {
            description = "javadoc tokens to check";
        } else {
            String descriptionString = SETTER_PATTERN.matcher(DescriptionExtractor.getDescriptionFromJavadoc(javadoc, moduleName)).replaceFirst("");
            String firstLetterCapitalized = descriptionString.substring(0, 1).toUpperCase(Locale.ROOT);
            description = firstLetterCapitalized + descriptionString.substring(1);
        }
        return description;
    }

    public static String getSinceVersion(String moduleName, DetailNode moduleJavadoc, String propertyName, DetailNode propertyJavadoc) throws MacroExecutionException {
        String superClassSinceVersion = SINCE_VERSION_FOR_INHERITED_PROPERTY.get(moduleName + DOT + propertyName);
        String sinceVersion = superClassSinceVersion != null ? superClassSinceVersion : (TOKENS.equals(propertyName) || JAVADOC_TOKENS.equals(propertyName) ? SiteUtil.getSinceVersionFromJavadoc(moduleJavadoc) : SiteUtil.getSinceVersionFromJavadoc(propertyJavadoc));
        if (sinceVersion == null) {
            String message = String.format(Locale.ROOT, "Failed to find '@since' version for '%s' property in '%s' and all parent classes.", propertyName, moduleName);
            throw new MacroExecutionException(message);
        }
        return sinceVersion;
    }

    @Nullable
    private static String getSinceVersionFromJavadoc(DetailNode javadoc) {
        DetailNode sinceJavadocTag = SiteUtil.getSinceJavadocTag(javadoc);
        return Optional.ofNullable(sinceJavadocTag).map(tag -> JavadocUtil.findFirstToken(tag, 10068)).map(description -> JavadocUtil.findFirstToken(description, 10074)).map(DetailNode::getText).orElse(null);
    }

    private static DetailNode getSinceJavadocTag(DetailNode javadoc) {
        DetailNode[] children = javadoc.getChildren();
        DetailNode javadocTagWithSince = null;
        for (DetailNode child : children) {
            DetailNode sinceNode;
            if (child.getType() != 10071 || (sinceNode = JavadocUtil.findFirstToken(child, 16)) == null) continue;
            javadocTagWithSince = child;
            break;
        }
        return javadocTagWithSince;
    }

    public static String getType(Field field, String propertyName, String moduleName, Object instance) throws MacroExecutionException {
        Class<?> fieldClass = SiteUtil.getFieldClass(field, propertyName, moduleName, instance);
        return Optional.ofNullable(field).map(nonNullField -> nonNullField.getAnnotation(XdocsPropertyType.class)).map(propertyType -> propertyType.value().getDescription()).orElseGet(fieldClass::getSimpleName);
    }

    public static String getDefaultValue(String propertyName, Field field, Object classInstance, String moduleName) throws MacroExecutionException {
        Object value = SiteUtil.getFieldValue(field, classInstance);
        Class<?> fieldClass = SiteUtil.getFieldClass(field, propertyName, moduleName, classInstance);
        Object result = null;
        if (CHARSET.equals(propertyName)) {
            result = "the charset property of the parent <a href=\"https://checkstyle.org/config.html#Checker\">Checker</a> module";
        } else if (classInstance instanceof PropertyCacheFile) {
            result = "null (no cache file)";
        } else if (fieldClass == Boolean.TYPE) {
            result = value.toString();
        } else if (fieldClass == Integer.TYPE) {
            result = value.toString();
        } else if (fieldClass == int[].class) {
            result = SiteUtil.getIntArrayPropertyValue(value);
        } else if (fieldClass == double[].class) {
            result = SiteUtil.removeSquareBrackets(Arrays.toString((double[])value).replace(".0", ""));
            if (((String)result).isEmpty()) {
                result = CURLY_BRACKETS;
            }
        } else if (fieldClass == String[].class) {
            result = SiteUtil.getStringArrayPropertyValue(propertyName, value);
        } else if (fieldClass == URI.class || fieldClass == String.class) {
            if (value != null) {
                result = "\"" + value.toString() + "\"";
            }
        } else if (fieldClass == Pattern.class) {
            if (value != null) {
                result = "\"" + value.toString().replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r").replace("\f", "\\f") + "\"";
            }
        } else if (fieldClass == Pattern[].class) {
            result = SiteUtil.getPatternArrayPropertyValue(value);
        } else if (fieldClass.isEnum()) {
            if (value != null) {
                result = value.toString().toLowerCase(Locale.ENGLISH);
            }
        } else if (fieldClass == AccessModifierOption[].class) {
            result = SiteUtil.removeSquareBrackets(Arrays.toString((Object[])value));
        } else {
            String message = String.format(Locale.ROOT, "Unknown property type: %s", fieldClass.getSimpleName());
            throw new MacroExecutionException(message);
        }
        if (result == null) {
            result = "null";
        }
        return result;
    }

    private static String getPatternArrayPropertyValue(Object fieldValue) {
        A[] value = fieldValue;
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            value = collection.stream().map(Pattern.class::cast).toArray(Pattern[]::new);
        }
        String result = "";
        if (value != null && Array.getLength(value) > 0) {
            result = SiteUtil.removeSquareBrackets(Arrays.stream((Pattern[])value).map(Pattern::pattern).collect(Collectors.joining(COMMA_SPACE)));
        }
        if (result.isEmpty()) {
            result = CURLY_BRACKETS;
        }
        return result;
    }

    private static String removeSquareBrackets(String value) {
        return value.replace("[", "").replace("]", "");
    }

    private static String getStringArrayPropertyValue(String propertyName, Object value) {
        String result;
        if (value == null) {
            result = "";
        } else {
            try (Stream<?> valuesStream = SiteUtil.getValuesStream(value);){
                result = valuesStream.map(String.class::cast).sorted().collect(Collectors.joining(COMMA_SPACE));
            }
        }
        if (result.isEmpty()) {
            result = FILE_EXTENSIONS.equals(propertyName) ? "all files" : CURLY_BRACKETS;
        }
        return result;
    }

    private static Stream<?> getValuesStream(Object value) {
        Stream<Object> valuesStream;
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            valuesStream = collection.stream();
        } else {
            Object[] array = (Object[])value;
            valuesStream = Arrays.stream(array);
        }
        return valuesStream;
    }

    private static String getIntArrayPropertyValue(Object value) {
        try (IntStream stream = SiteUtil.getIntStream(value);){
            String result = stream.mapToObj(TokenUtil::getTokenName).sorted().collect(Collectors.joining(COMMA_SPACE));
            if (result.isEmpty()) {
                result = CURLY_BRACKETS;
            }
            String string = result;
            return string;
        }
    }

    private static IntStream getIntStream(Object value) {
        IntStream stream;
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            stream = collection.stream().mapToInt(Integer.TYPE::cast);
        } else {
            stream = value instanceof BitSet ? ((BitSet)value).stream() : Arrays.stream((int[])value);
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class<?> getFieldClass(Field field, String propertyName, String moduleName, Object instance) throws MacroExecutionException {
        void var4_14;
        void var4_8;
        void var4_6;
        Object var4_4 = null;
        if (field != null) {
            Class<?> clazz = field.getType();
        }
        if (var4_6 == null) {
            if (!PROPERTIES_ALLOWED_GET_TYPES_FROM_METHOD.contains(moduleName + DOT + propertyName)) {
                throw new MacroExecutionException("Could not find field " + propertyName + " in class " + moduleName);
            }
            Class<?> clazz = SiteUtil.getPropertyClass(propertyName, instance);
        }
        if (field != null && (var4_8 == List.class || var4_8 == Set.class)) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Class parameterClass = (Class)type.getActualTypeArguments()[0];
            if (parameterClass == Integer.class) {
                return var4_14;
            }
            if (parameterClass == String.class) {
                return var4_14;
            }
            if (parameterClass == Pattern.class) {
                return var4_14;
            }
            String message = "Unknown parameterized type: " + parameterClass.getSimpleName();
            throw new MacroExecutionException(message);
        }
        if (var4_8 != BitSet.class) return var4_14;
        return var4_14;
    }

    public static Class<?> getPropertyClass(String propertyName, Object instance) throws MacroExecutionException {
        Class<?> result;
        try {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)instance, (String)propertyName);
            result = descriptor.getPropertyType();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            throw new MacroExecutionException(exc.getMessage(), (Throwable)exc);
        }
        return result;
    }

    public static List<Integer> getDifference(int[] tokens, int ... subtractions) {
        Set subtractionsSet = Arrays.stream(subtractions).boxed().collect(Collectors.toSet());
        return Arrays.stream(tokens).boxed().filter(token -> !subtractionsSet.contains(token)).collect(Collectors.toList());
    }

    public static Field getField(Class<?> fieldClass, String propertyName) {
        Field result = null;
        Class<?> currentClass = fieldClass;
        while (!Object.class.equals(currentClass)) {
            try {
                result = currentClass.getDeclaredField(propertyName);
                result.trySetAccessible();
                break;
            }
            catch (NoSuchFieldException ignored) {
                currentClass = currentClass.getSuperclass();
            }
        }
        return result;
    }

    public static String getLinkToDocument(String moduleName, String document) throws MacroExecutionException {
        Path templatePath = SiteUtil.getTemplatePath(moduleName.replace("Check", ""));
        if (templatePath == null) {
            throw new MacroExecutionException(String.format(Locale.ROOT, "Could not find template for %s", moduleName));
        }
        Path templatePathParent = templatePath.getParent();
        if (templatePathParent == null) {
            throw new MacroExecutionException("Failed to get parent path for " + templatePath);
        }
        return templatePathParent.relativize(Paths.get(SRC, "xdocs", document)).toString().replace(".xml", ".html").replace('\\', '/');
    }

    private static final class DescriptionExtractor {
        private DescriptionExtractor() {
        }

        private static String getDescriptionFromJavadoc(DetailNode javadoc, String moduleName) throws MacroExecutionException {
            boolean isInCodeLiteral = false;
            boolean isInHtmlElement = false;
            boolean isInHrefAttribute = false;
            StringBuilder description = new StringBuilder(128);
            ArrayDeque queue = new ArrayDeque();
            List<DetailNode> descriptionNodes = DescriptionExtractor.getDescriptionNodes(javadoc);
            Lists.reverse(descriptionNodes).forEach(queue::push);
            while (!queue.isEmpty()) {
                DetailNode node = (DetailNode)queue.pop();
                Lists.reverse(Arrays.asList(node.getChildren())).forEach(queue::push);
                if (node.getType() == 100 && "href".equals(node.getText())) {
                    isInHrefAttribute = true;
                }
                if (isInHrefAttribute && node.getType() == 89) {
                    String href = node.getText();
                    if (href.contains(SiteUtil.CHECKSTYLE_ORG_URL)) {
                        DescriptionExtractor.handleInternalLink(description, moduleName, href);
                    } else {
                        description.append(href);
                    }
                    isInHrefAttribute = false;
                    continue;
                }
                if (node.getType() == 10001) {
                    isInHtmlElement = true;
                }
                if (node.getType() == 55 && node.getParent().getType() == 10003) {
                    description.append(node.getText());
                    isInHtmlElement = false;
                }
                if (node.getType() == 10074 || isInHtmlElement && node.getChildren().length == 0 && node.getType() != 1) {
                    description.append(node.getText());
                }
                if (node.getType() == 45) {
                    isInCodeLiteral = true;
                    description.append("<code>");
                }
                if (!isInCodeLiteral || node.getType() != 20) continue;
                isInCodeLiteral = false;
                description.append("</code>");
            }
            return description.toString().trim();
        }

        private static void handleInternalLink(StringBuilder description, String moduleName, String value) throws MacroExecutionException {
            String href = value;
            href = href.replace(SiteUtil.CHECKSTYLE_ORG_URL, "");
            href = href.substring(1, href.length() - 1);
            String relativeHref = SiteUtil.getLinkToDocument(moduleName, href);
            int doubleQuote = 34;
            description.append('\"').append(relativeHref).append('\"');
        }

        private static List<DetailNode> getDescriptionNodes(DetailNode javadoc) {
            DetailNode[] children = javadoc.getChildren();
            ArrayList<DetailNode> descriptionNodes = new ArrayList<DetailNode>();
            for (DetailNode child : children) {
                if (DescriptionExtractor.isEndOfDescription(child)) break;
                descriptionNodes.add(child);
            }
            return descriptionNodes;
        }

        private static boolean isEndOfDescription(DetailNode child) {
            DetailNode nextSibling = JavadocUtil.getNextSibling(child);
            DetailNode secondNextSibling = JavadocUtil.getNextSibling(nextSibling);
            DetailNode thirdNextSibling = JavadocUtil.getNextSibling(secondNextSibling);
            return child.getType() == 6 && nextSibling.getType() == 1 && secondNextSibling.getType() == 6 && thirdNextSibling.getType() == 1;
        }
    }
}

