/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.JavadocDetailNodeParser;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractJavadocCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
    public static final String MSG_JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
    public static final String MSG_JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
    public static final String MSG_KEY_UNCLOSED_HTML_TAG = "javadoc.unclosedHtml";
    private static final ThreadLocal<Map<LineColumn, JavadocDetailNodeParser.ParseStatus>> TREE_CACHE = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<FileContext> context = ThreadLocal.withInitial(() -> new FileContext());
    private final Set<Integer> javadocTokens = new HashSet<Integer>();
    private boolean violateExecutionOnNonTightHtml;

    public abstract int[] getDefaultJavadocTokens();

    public abstract void visitJavadocToken(DetailNode var1);

    public int[] getAcceptableJavadocTokens() {
        int[] defaultJavadocTokens = this.getDefaultJavadocTokens();
        int[] copy = new int[defaultJavadocTokens.length];
        System.arraycopy(defaultJavadocTokens, 0, copy, 0, defaultJavadocTokens.length);
        return copy;
    }

    public int[] getRequiredJavadocTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public boolean acceptJavadocWithNonTightHtml() {
        return true;
    }

    public final void setViolateExecutionOnNonTightHtml(boolean shouldReportViolation) {
        this.violateExecutionOnNonTightHtml = shouldReportViolation;
    }

    public final void setJavadocTokens(String ... strRep) {
        for (String str : strRep) {
            this.javadocTokens.add(JavadocUtil.getTokenId(str));
        }
    }

    @Override
    public void init() {
        this.validateDefaultJavadocTokens();
        if (this.javadocTokens.isEmpty()) {
            this.javadocTokens.addAll(Arrays.stream(this.getDefaultJavadocTokens()).boxed().collect(Collectors.toUnmodifiableList()));
        } else {
            int[] acceptableJavadocTokens = this.getAcceptableJavadocTokens();
            Arrays.sort(acceptableJavadocTokens);
            for (Integer javadocTokenId : this.javadocTokens) {
                if (Arrays.binarySearch(acceptableJavadocTokens, javadocTokenId) >= 0) continue;
                String message = String.format(Locale.ROOT, "Javadoc Token \"%s\" was not found in Acceptable javadoc tokens list in check %s", JavadocUtil.getTokenName(javadocTokenId), this.getClass().getName());
                throw new IllegalStateException(message);
            }
        }
    }

    private void validateDefaultJavadocTokens() {
        if (this.getRequiredJavadocTokens().length != 0) {
            int[] defaultJavadocTokens = this.getDefaultJavadocTokens();
            Arrays.sort(defaultJavadocTokens);
            for (int javadocToken : this.getRequiredJavadocTokens()) {
                if (Arrays.binarySearch(defaultJavadocTokens, javadocToken) >= 0) continue;
                String message = String.format(Locale.ROOT, "Javadoc Token \"%s\" from required javadoc tokens was not found in default javadoc tokens list in check %s", javadocToken, this.getClass().getName());
                throw new IllegalStateException(message);
            }
        }
    }

    public void beginJavadocTree(DetailNode rootAst) {
    }

    public void finishJavadocTree(DetailNode rootAst) {
    }

    public void leaveJavadocToken(DetailNode ast) {
    }

    @Override
    public final int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public final int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public final int[] getRequiredTokens() {
        return new int[]{145};
    }

    @Override
    public final boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public final void beginTree(DetailAST rootAST) {
        TREE_CACHE.get().clear();
    }

    @Override
    public final void finishTree(DetailAST rootAST) {
    }

    @Override
    public final void visitToken(DetailAST blockCommentNode) {
        if (JavadocUtil.isJavadocComment(blockCommentNode)) {
            this.context.get().blockCommentAst = blockCommentNode;
            LineColumn treeCacheKey = new LineColumn(blockCommentNode.getLineNo(), blockCommentNode.getColumnNo());
            JavadocDetailNodeParser.ParseStatus result = TREE_CACHE.get().computeIfAbsent(treeCacheKey, key -> this.context.get().parser.parseJavadocAsDetailNode(blockCommentNode));
            if (result.getParseErrorMessage() == null) {
                if (this.acceptJavadocWithNonTightHtml() || !result.isNonTight()) {
                    this.processTree(result.getTree());
                }
                if (this.violateExecutionOnNonTightHtml && result.isNonTight()) {
                    this.log(result.getFirstNonTightHtmlTag().getLine(), MSG_KEY_UNCLOSED_HTML_TAG, result.getFirstNonTightHtmlTag().getText());
                }
            } else {
                JavadocDetailNodeParser.ParseErrorMessage parseErrorMessage = result.getParseErrorMessage();
                this.log(parseErrorMessage.getLineNumber(), parseErrorMessage.getMessageKey(), parseErrorMessage.getMessageArguments());
            }
        }
    }

    protected DetailAST getBlockCommentAst() {
        return this.context.get().blockCommentAst;
    }

    private void processTree(DetailNode root) {
        this.beginJavadocTree(root);
        this.walk(root);
        this.finishJavadocTree(root);
    }

    private void walk(DetailNode root) {
        DetailNode curNode = root;
        while (curNode != null) {
            boolean waitsForProcessing = this.shouldBeProcessed(curNode);
            if (waitsForProcessing) {
                this.visitJavadocToken(curNode);
            }
            DetailNode toVisit = JavadocUtil.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                if (waitsForProcessing) {
                    this.leaveJavadocToken(curNode);
                }
                if ((toVisit = JavadocUtil.getNextSibling(curNode)) != null || (curNode = curNode.getParent()) == null) continue;
                waitsForProcessing = this.shouldBeProcessed(curNode);
            }
            curNode = toVisit;
        }
    }

    private boolean shouldBeProcessed(DetailNode curNode) {
        return this.javadocTokens.contains(curNode.getType());
    }

    @Override
    public void destroy() {
        super.destroy();
        this.context.remove();
        TREE_CACHE.remove();
    }

    private static final class FileContext {
        private final JavadocDetailNodeParser parser = new JavadocDetailNodeParser();
        private DetailAST blockCommentAst;

        private FileContext() {
        }
    }
}

