/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.List;

@StatelessCheck
public class AvoidStarImportCheck
extends AbstractCheck {
    public static final String MSG_KEY = "import.avoidStar";
    private static final String STAR_IMPORT_SUFFIX = ".*";
    private final List<String> excludes = new ArrayList<String>();
    private boolean allowClassImports;
    private boolean allowStaticMemberImports;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 152};
    }

    public void setExcludes(String ... excludesParam) {
        for (String exclude : excludesParam) {
            if (exclude.endsWith(STAR_IMPORT_SUFFIX)) {
                this.excludes.add(exclude);
                continue;
            }
            this.excludes.add(exclude + STAR_IMPORT_SUFFIX);
        }
    }

    public void setAllowClassImports(boolean allow) {
        this.allowClassImports = allow;
    }

    public void setAllowStaticMemberImports(boolean allow) {
        this.allowStaticMemberImports = allow;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 30) {
            if (!this.allowClassImports) {
                DetailAST startingDot = ast.getFirstChild();
                this.logsStarredImportViolation(startingDot);
            }
        } else if (!this.allowStaticMemberImports) {
            DetailAST startingDot = ast.getFirstChild().getNextSibling();
            this.logsStarredImportViolation(startingDot);
        }
    }

    private void logsStarredImportViolation(DetailAST startingDot) {
        FullIdent name = FullIdent.createFullIdent(startingDot);
        String importText = name.getText();
        if (importText.endsWith(STAR_IMPORT_SUFFIX) && !this.excludes.contains(importText)) {
            this.log(startingDot, MSG_KEY, importText);
        }
    }
}

