/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;

@StatelessCheck
public class NonEmptyAtclauseDescriptionCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "non.empty.atclause";

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10, 11, 17, 9, 8};
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (NonEmptyAtclauseDescriptionCheck.isEmptyTag(ast.getParent())) {
            this.log(ast.getLineNumber(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isEmptyTag(DetailNode tagNode) {
        DetailNode tagDescription = JavadocUtil.findFirstToken(tagNode, 10068);
        return tagDescription == null || NonEmptyAtclauseDescriptionCheck.hasOnlyEmptyText(tagDescription);
    }

    private static boolean hasOnlyEmptyText(DetailNode description) {
        boolean result = true;
        for (DetailNode child : description.getChildren()) {
            if (child.getType() == 1 || CommonUtil.isBlank(child.getText())) continue;
            result = false;
            break;
        }
        return result;
    }
}

