/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

@StatelessCheck
public class SuppressWarningsHolder
extends AbstractCheck {
    private static final String CHECKSTYLE_PREFIX = "checkstyle:";
    private static final String JAVA_LANG_PREFIX = "java.lang.";
    private static final String CHECK_SUFFIX = "check";
    private static final String ALL_WARNING_MATCHING_ID = "all";
    private static final Map<String, String> CHECK_ALIAS_MAP = new HashMap<String, String>();
    private static final ThreadLocal<List<Entry>> ENTRIES = ThreadLocal.withInitial(LinkedList::new);
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern NEWLINE = Pattern.compile("\\n");

    public static String getDefaultAlias(String sourceName) {
        int endIndex = sourceName.length();
        String sourceNameLower = sourceName.toLowerCase(Locale.ENGLISH);
        if (sourceNameLower.endsWith(CHECK_SUFFIX)) {
            endIndex -= CHECK_SUFFIX.length();
        }
        int startIndex = sourceNameLower.lastIndexOf(46) + 1;
        return sourceNameLower.substring(startIndex, endIndex);
    }

    public static String getAlias(String sourceName) {
        String checkAlias = CHECK_ALIAS_MAP.get(sourceName);
        if (checkAlias == null) {
            checkAlias = SuppressWarningsHolder.getDefaultAlias(sourceName);
        }
        return checkAlias;
    }

    private static void registerAlias(String sourceName, String checkAlias) {
        CHECK_ALIAS_MAP.put(sourceName, checkAlias);
    }

    public void setAliasList(String ... aliasList) {
        for (String sourceAlias : aliasList) {
            int index = sourceAlias.indexOf(61);
            if (index > 0) {
                SuppressWarningsHolder.registerAlias(sourceAlias.substring(0, index), sourceAlias.substring(index + 1));
                continue;
            }
            if (sourceAlias.isEmpty()) continue;
            throw new IllegalArgumentException("'=' expected in alias list item: " + sourceAlias);
        }
    }

    public static boolean isSuppressed(AuditEvent event) {
        List<Entry> entries = ENTRIES.get();
        String sourceName = event.getSourceName();
        String checkAlias = SuppressWarningsHolder.getAlias(sourceName);
        int line = event.getLine();
        int column = event.getColumn();
        boolean suppressed = false;
        for (Entry entry : entries) {
            boolean nameMatches;
            boolean afterStart = SuppressWarningsHolder.isSuppressedAfterEventStart(line, column, entry);
            boolean beforeEnd = SuppressWarningsHolder.isSuppressedBeforeEventEnd(line, column, entry);
            String checkName = entry.getCheckName();
            boolean bl = nameMatches = ALL_WARNING_MATCHING_ID.equals(checkName) || checkName.equalsIgnoreCase(checkAlias) || SuppressWarningsHolder.getDefaultAlias(checkName).equalsIgnoreCase(checkAlias);
            if (!afterStart || !beforeEnd || !nameMatches && !checkName.equals(event.getModuleId())) continue;
            suppressed = true;
            break;
        }
        return suppressed;
    }

    private static boolean isSuppressedAfterEventStart(int line, int column, Entry entry) {
        return entry.getFirstLine() < line || entry.getFirstLine() == line && (column == 0 || entry.getFirstColumn() <= column);
    }

    private static boolean isSuppressedBeforeEventEnd(int line, int column, Entry entry) {
        return entry.getLastLine() > line || entry.getLastLine() == line && entry.getLastColumn() >= column;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{159};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        ENTRIES.get().clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        String identifier = SuppressWarningsHolder.getIdentifier(SuppressWarningsHolder.getNthChild(ast, 1));
        if (identifier.startsWith(JAVA_LANG_PREFIX)) {
            identifier = identifier.substring(JAVA_LANG_PREFIX.length());
        }
        if ("SuppressWarnings".equals(identifier)) {
            SuppressWarningsHolder.getAnnotationTarget(ast).ifPresent(targetAST -> SuppressWarningsHolder.addSuppressions(SuppressWarningsHolder.getAllAnnotationValues(ast), targetAST));
        }
    }

    private static void addSuppressions(List<String> values, DetailAST targetAST) {
        int lastColumn;
        int lastLine;
        int firstLine = targetAST.getLineNo();
        int firstColumn = targetAST.getColumnNo();
        DetailAST nextAST = targetAST.getNextSibling();
        if (nextAST == null) {
            lastLine = Integer.MAX_VALUE;
            lastColumn = Integer.MAX_VALUE;
        } else {
            lastLine = nextAST.getLineNo();
            lastColumn = nextAST.getColumnNo();
        }
        List<Entry> entries = ENTRIES.get();
        for (String value : values) {
            String checkName = SuppressWarningsHolder.removeCheckstylePrefixIfExists(value);
            entries.add(new Entry(checkName, firstLine, firstColumn, lastLine, lastColumn));
        }
    }

    private static String removeCheckstylePrefixIfExists(String checkName) {
        String result = checkName;
        if (checkName.startsWith(CHECKSTYLE_PREFIX)) {
            result = checkName.substring(CHECKSTYLE_PREFIX.length());
        }
        return result;
    }

    private static List<String> getAllAnnotationValues(DetailAST ast) {
        List<String> values = Collections.emptyList();
        DetailAST lparenAST = ast.findFirstToken(76);
        if (lparenAST != null) {
            DetailAST nextAST = lparenAST.getNextSibling();
            int nextType = nextAST.getType();
            switch (nextType) {
                case 28: 
                case 162: {
                    values = SuppressWarningsHolder.getAnnotationValues(nextAST);
                    break;
                }
                case 160: {
                    values = SuppressWarningsHolder.getAnnotationValues(SuppressWarningsHolder.getNthChild(nextAST, 2));
                    break;
                }
                case 77: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected AST: " + String.valueOf(nextAST));
                }
            }
        }
        return values;
    }

    private static Optional<DetailAST> getAnnotationTarget(DetailAST ast) {
        Optional<DetailAST> result;
        DetailAST parentAST = ast.getParent();
        switch (parentAST.getType()) {
            case 5: 
            case 158: 
            case 159: 
            case 160: {
                result = Optional.of(parentAST.getParent());
                break;
            }
            case 94: {
                result = Optional.empty();
                break;
            }
            case 162: {
                result = SuppressWarningsHolder.getAnnotationTarget(parentAST);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected container AST: " + String.valueOf(parentAST));
            }
        }
        return result;
    }

    private static DetailAST getNthChild(DetailAST ast, int index) {
        DetailAST child = ast.getFirstChild();
        for (int i = 0; i < index && child != null; child = child.getNextSibling(), ++i) {
        }
        return child;
    }

    private static String getIdentifier(DetailAST ast) {
        if (ast == null) {
            throw new IllegalArgumentException("Identifier AST expected, but get null.");
        }
        Object identifier = ast.getType() == 58 ? ast.getText() : SuppressWarningsHolder.getIdentifier(ast.getFirstChild()) + "." + SuppressWarningsHolder.getIdentifier(ast.getLastChild());
        return identifier;
    }

    private static String getStringExpr(DetailAST ast) {
        DetailAST firstChild = ast.getFirstChild();
        String expr = "";
        switch (firstChild.getType()) {
            case 139: {
                String quotedText = firstChild.getText();
                expr = quotedText.substring(1, quotedText.length() - 1);
                break;
            }
            case 58: {
                expr = firstChild.getText();
                break;
            }
            case 59: {
                expr = firstChild.getLastChild().getText();
                break;
            }
            case 204: {
                String textBlockContent = firstChild.getFirstChild().getText();
                expr = SuppressWarningsHolder.getContentWithoutPrecedingWhitespace(textBlockContent);
                break;
            }
        }
        return expr;
    }

    private static List<String> getAnnotationValues(DetailAST ast) {
        List<String> annotationValues;
        switch (ast.getType()) {
            case 28: {
                annotationValues = Collections.singletonList(SuppressWarningsHolder.getStringExpr(ast));
                break;
            }
            case 162: {
                annotationValues = SuppressWarningsHolder.findAllExpressionsInChildren(ast);
                break;
            }
            default: {
                throw new IllegalArgumentException("Expression or annotation array initializer AST expected: " + String.valueOf(ast));
            }
        }
        return annotationValues;
    }

    private static List<String> findAllExpressionsInChildren(DetailAST parent) {
        LinkedList<String> valueList = new LinkedList<String>();
        for (DetailAST childAST = parent.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
            if (childAST.getType() != 28) continue;
            valueList.add(SuppressWarningsHolder.getStringExpr(childAST));
        }
        return valueList;
    }

    private static String getContentWithoutPrecedingWhitespace(String textBlockContent) {
        String contentWithNoPrecedingNewline = NEWLINE.matcher(textBlockContent).replaceAll("");
        return WHITESPACE.matcher(contentWithNoPrecedingNewline).replaceAll("");
    }

    @Override
    public void destroy() {
        super.destroy();
        ENTRIES.remove();
    }

    private static final class Entry {
        private final String checkName;
        private final int firstLine;
        private final int firstColumn;
        private final int lastLine;
        private final int lastColumn;

        private Entry(String checkName, int firstLine, int firstColumn, int lastLine, int lastColumn) {
            this.checkName = checkName;
            this.firstLine = firstLine;
            this.firstColumn = firstColumn;
            this.lastLine = lastLine;
            this.lastColumn = lastColumn;
        }

        public String getCheckName() {
            return this.checkName;
        }

        public int getFirstLine() {
            return this.firstLine;
        }

        public int getFirstColumn() {
            return this.firstColumn;
        }

        public int getLastLine() {
            return this.lastLine;
        }

        public int getLastColumn() {
            return this.lastColumn;
        }
    }
}

