/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Violation;
import com.puppycrawl.tools.checkstyle.xpath.XpathQueryGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XpathFileGeneratorAstFilter
extends AbstractAutomaticBean
implements TreeWalkerFilter {
    private static final String DELIMITER = " | \n";
    private static final Map<Violation, String> MESSAGE_QUERY_MAP = new HashMap<Violation, String>();
    private int tabWidth;

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public static String findCorrespondingXpathQuery(AuditEvent event) {
        return MESSAGE_QUERY_MAP.get(event.getViolation());
    }

    @Override
    protected void finishLocalSetup() {
        MESSAGE_QUERY_MAP.clear();
    }

    @Override
    public boolean accept(TreeWalkerAuditEvent event) {
        XpathQueryGenerator xpathQueryGenerator;
        List<String> xpathQueries;
        if (event.getTokenType() != 0 && !(xpathQueries = (xpathQueryGenerator = new XpathQueryGenerator(event, this.tabWidth)).generate()).isEmpty()) {
            String query = String.join((CharSequence)DELIMITER, xpathQueries);
            MESSAGE_QUERY_MAP.put(event.getViolation(), query);
        }
        return true;
    }
}

