/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.Violation;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class AbstractFileSetCheck
extends AbstractViolationReporter
implements FileSetCheck {
    private static final String EXTENSION_SEPARATOR = ".";
    private final ThreadLocal<FileContext> context = ThreadLocal.withInitial(FileContext::new);
    private MessageDispatcher messageDispatcher;
    private String[] fileExtensions;
    private int tabWidth;

    protected abstract void processFiltered(File var1, FileText var2) throws CheckstyleException;

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
        this.context.remove();
    }

    @Override
    public void beginProcessing(String charset) {
    }

    @Override
    public final SortedSet<Violation> process(File file, FileText fileText) throws CheckstyleException {
        FileContext fileContext = this.context.get();
        fileContext.fileContents = new FileContents(fileText);
        fileContext.violations.clear();
        if (CommonUtil.matchesFileExtension(file, this.fileExtensions)) {
            this.processFiltered(file, fileText);
        }
        TreeSet<Violation> result = new TreeSet<Violation>(fileContext.violations);
        fileContext.violations.clear();
        return result;
    }

    @Override
    public void finishProcessing() {
    }

    @Override
    public final void setMessageDispatcher(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
    }

    protected final MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public SortedSet<Violation> getViolations() {
        return new TreeSet<Violation>(this.context.get().violations);
    }

    public final void setFileContents(FileContents contents) {
        this.context.get().fileContents = contents;
    }

    protected final FileContents getFileContents() {
        return this.context.get().fileContents;
    }

    public String[] getFileExtensions() {
        return Arrays.copyOf(this.fileExtensions, this.fileExtensions.length);
    }

    public final void setFileExtensions(String ... extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("Extensions array can not be null");
        }
        this.fileExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            this.fileExtensions[i] = extension.startsWith(EXTENSION_SEPARATOR) ? extension : EXTENSION_SEPARATOR + extension;
        }
    }

    protected final int getTabWidth() {
        return this.tabWidth;
    }

    public final void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    protected void addViolations(SortedSet<Violation> violations) {
        this.context.get().violations.addAll(violations);
    }

    @Override
    public final void log(int line, String key, Object ... args) {
        this.context.get().violations.add(new Violation(line, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    @Override
    public final void log(int lineNo, int colNo, String key, Object ... args) {
        FileContext fileContext = this.context.get();
        int col = 1 + CommonUtil.lengthExpandedTabs(fileContext.fileContents.getLine(lineNo - 1), colNo, this.tabWidth);
        fileContext.violations.add(new Violation(lineNo, col, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    protected final void fireErrors(String fileName) {
        FileContext fileContext = this.context.get();
        TreeSet<Violation> errors = new TreeSet<Violation>(fileContext.violations);
        fileContext.violations.clear();
        this.messageDispatcher.fireErrors(fileName, errors);
    }

    private static final class FileContext {
        private final SortedSet<Violation> violations = new TreeSet<Violation>();
        private FileContents fileContents;

        private FileContext() {
        }
    }
}

