/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.meta.JavadocMetadataScraper;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.sink.Sink;

public final class ModuleJavadocParsingUtil {
    public static final String NEWLINE = System.lineSeparator();
    public static final String INDENT_LEVEL_8 = SiteUtil.getNewlineAndIndentSpaces(8);
    public static final String INDENT_LEVEL_10 = SiteUtil.getNewlineAndIndentSpaces(10);
    public static final String INDENT_LEVEL_12 = SiteUtil.getNewlineAndIndentSpaces(12);
    public static final String INDENT_LEVEL_14 = SiteUtil.getNewlineAndIndentSpaces(14);
    public static final String INDENT_LEVEL_16 = SiteUtil.getNewlineAndIndentSpaces(16);
    public static final String INDENT_LEVEL_18 = SiteUtil.getNewlineAndIndentSpaces(18);
    public static final String INDENT_LEVEL_20 = SiteUtil.getNewlineAndIndentSpaces(20);
    public static final Set<String> HTML_TEXT_FORMAT_TAGS = Set.of("<code>", "<a", "</a>", "<b>", "</b>", "<strong>", "</strong>", "<i>", "</i>", "<em>", "</em>", "<small>", "</small>", "<ins>", "<sub>", "<sup>");
    public static final String NOTES = "Notes:";
    public static final Pattern NOTES_LINE = Pattern.compile("\\s*Notes:$");

    private ModuleJavadocParsingUtil() {
    }

    public static Set<String> getPropertyNames(String moduleName) throws MacroExecutionException {
        Object instance = SiteUtil.getModuleInstance(moduleName);
        Class<?> clss = instance.getClass();
        return SiteUtil.getPropertiesForDocumentation(clss, instance);
    }

    public static int getParentSectionStartIndex(DetailNode moduleJavadoc) {
        int parentStartIndex = -1;
        for (DetailNode node : moduleJavadoc.getChildren()) {
            DetailNode paragraphNode;
            if (node.getType() != 10001 || (paragraphNode = JavadocUtil.findFirstToken(node, 10008)) == null || !JavadocMetadataScraper.isParentText(paragraphNode)) continue;
            parentStartIndex = node.getIndex();
            break;
        }
        return parentStartIndex;
    }

    public static int getNotesSectionStartIndex(DetailNode moduleJavadoc) {
        int notesStartIndex = -1;
        for (DetailNode node : moduleJavadoc.getChildren()) {
            if (node.getType() != 10001 || !ModuleJavadocParsingUtil.isStartOfNotesSection(node)) continue;
            notesStartIndex += node.getIndex();
            break;
        }
        return notesStartIndex;
    }

    private static boolean isStartOfNotesSection(DetailNode htmlElement) {
        DetailNode paragraphNode = JavadocUtil.findFirstToken(htmlElement, 10008);
        Optional<DetailNode> liNode = ModuleJavadocParsingUtil.getLiTagNode(htmlElement);
        return paragraphNode != null && JavadocMetadataScraper.isChildNodeTextMatches(paragraphNode, NOTES_LINE) || liNode.isPresent() && JavadocMetadataScraper.isChildNodeTextMatches(liNode.get(), NOTES_LINE);
    }

    public static Optional<DetailNode> getLiTagNode(DetailNode htmlElement) {
        return Optional.of(htmlElement).map(element -> JavadocUtil.findFirstToken(element, 10005)).map(element -> JavadocUtil.findFirstToken(element, 10001)).map(element -> JavadocUtil.findFirstToken(element, 10011));
    }

    public static int getPropertySectionStartIndex(DetailNode moduleJavadoc, Set<String> propertyNames) {
        int propertySectionStartIndex = -1;
        String somePropertyName = propertyNames.iterator().next();
        Optional<DetailNode> somePropertyModuleNode = SiteUtil.getPropertyJavadocNodeInModule(somePropertyName, moduleJavadoc);
        if (somePropertyModuleNode.isPresent()) {
            propertySectionStartIndex = JavadocMetadataScraper.getParentIndexOf(somePropertyModuleNode.get());
        }
        return propertySectionStartIndex;
    }

    public static void writeOutJavadocPortion(String javadocPortion, Sink sink) {
        String[] javadocPortionLinesSplit = javadocPortion.split(NEWLINE.replace("\r", ""));
        sink.rawText(javadocPortionLinesSplit[0]);
        String lastHtmlTag = javadocPortionLinesSplit[0];
        for (int index = 1; index < javadocPortionLinesSplit.length; ++index) {
            Object processedLine;
            String currentLine = javadocPortionLinesSplit[index].trim();
            if (currentLine.isEmpty()) {
                processedLine = NEWLINE;
            } else if (currentLine.startsWith("<") && !ModuleJavadocParsingUtil.startsWithTextFormattingHtmlTag(currentLine)) {
                processedLine = INDENT_LEVEL_8 + currentLine;
                lastHtmlTag = currentLine;
            } else if (lastHtmlTag.contains("<pre")) {
                String currentLineWithPreservedIndent = javadocPortionLinesSplit[index].substring(1);
                processedLine = NEWLINE + currentLineWithPreservedIndent;
            } else {
                processedLine = INDENT_LEVEL_10 + currentLine;
            }
            sink.rawText((String)processedLine);
        }
    }

    public static boolean startsWithTextFormattingHtmlTag(String line) {
        boolean result = false;
        for (String tag : HTML_TEXT_FORMAT_TAGS) {
            if (!line.startsWith(tag)) continue;
            result = true;
            break;
        }
        return result;
    }
}

