/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import java.util.Set;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="violation-messages")
public class ViolationMessagesMacro
extends AbstractMacro {
    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        if (!(sink instanceof XdocSink)) {
            throw new MacroExecutionException("Expected Sink to be an XdocSink.");
        }
        String checkName = (String)request.getParameter("checkName");
        Object instance = SiteUtil.getModuleInstance(checkName);
        Class<?> clss = instance.getClass();
        Set<String> messageKeys = SiteUtil.getMessageKeys(clss);
        ViolationMessagesMacro.createListOfMessages((XdocSink)sink, clss, messageKeys);
    }

    private static void createListOfMessages(XdocSink sink, Class<?> clss, Set<String> messageKeys) {
        String indentLevel8 = SiteUtil.getNewlineAndIndentSpaces(8);
        sink.setInsertNewline(false);
        sink.list();
        sink.setInsertNewline(true);
        for (String messageKey : messageKeys) {
            ViolationMessagesMacro.createListItem(sink, clss, messageKey);
        }
        sink.rawText(indentLevel8);
        sink.list_();
    }

    private static void createListItem(XdocSink sink, Class<?> clss, String messageKey) {
        String messageKeyUrl = ViolationMessagesMacro.constructMessageKeyUrl(clss, messageKey);
        String indentLevel10 = SiteUtil.getNewlineAndIndentSpaces(10);
        String indentLevel12 = SiteUtil.getNewlineAndIndentSpaces(12);
        String indentLevel14 = SiteUtil.getNewlineAndIndentSpaces(14);
        sink.rawText(indentLevel10);
        sink.setInsertNewline(false);
        sink.listItem();
        sink.setInsertNewline(true);
        sink.rawText(indentLevel12);
        sink.link(messageKeyUrl);
        sink.rawText(indentLevel14);
        sink.rawText(messageKey);
        sink.rawText(indentLevel12);
        sink.link_();
        sink.rawText(indentLevel10);
        sink.listItem_();
    }

    private static String constructMessageKeyUrl(Class<?> clss, String messageKey) {
        return "https://github.com/search?q=path%3Asrc%2Fmain%2Fresources%2F" + clss.getPackage().getName().replace(".", "%2F") + "%20path%3A**%2Fmessages*.properties+repo%3Acheckstyle%2Fcheckstyle+%22" + messageKey + "%22";
    }
}

