/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.JavadocDetailNodeParser;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.gui.MainFrameModel;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeTableModel;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.HashMap;
import java.util.Map;

public class ParseTreeTablePresentation {
    private static final String UNKNOWN_COLUMN_MSG = "Unknown column";
    private static final String[] COLUMN_NAMES = new String[]{"Tree", "Type", "Line", "Column", "Text"};
    private final Map<DetailAST, DetailNode> blockCommentToJavadocTree = new HashMap<DetailAST, DetailNode>();
    private DetailAST root;
    private MainFrameModel.ParseMode parseMode;

    public ParseTreeTablePresentation(DetailAST parseTree) {
        this.root = parseTree;
    }

    protected final void setRoot(DetailAST parseTree) {
        this.root = parseTree;
    }

    protected void setParseMode(MainFrameModel.ParseMode mode) {
        this.parseMode = mode;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class<?> getColumnClass(int column) {
        return switch (column) {
            case 0 -> ParseTreeTableModel.class;
            case 1, 4 -> String.class;
            case 2, 3 -> Integer.class;
            default -> throw new IllegalStateException(UNKNOWN_COLUMN_MSG);
        };
    }

    public Object getValueAt(Object node, int column) {
        Object result;
        if (node instanceof DetailNode) {
            DetailNode detailNode = (DetailNode)node;
            result = ParseTreeTablePresentation.getValueAtDetailNode(detailNode, column);
        } else {
            result = ParseTreeTablePresentation.getValueAtDetailAST((DetailAST)node, column);
        }
        return result;
    }

    public Object getChild(Object parent, int index) {
        Object result;
        if (parent instanceof DetailNode) {
            DetailNode node = (DetailNode)parent;
            result = node.getChildren()[index];
        } else {
            result = this.getChildAtDetailAst((DetailAST)parent, index);
        }
        return result;
    }

    public int getChildCount(Object parent) {
        int result;
        if (parent instanceof DetailNode) {
            DetailNode node = (DetailNode)parent;
            result = node.getChildren().length;
        } else {
            result = this.parseMode == MainFrameModel.ParseMode.JAVA_WITH_JAVADOC_AND_COMMENTS && ((DetailAST)parent).getType() == 183 && JavadocUtil.isJavadocComment(((DetailAST)parent).getParent()) ? 1 : ((DetailAST)parent).getChildCount();
        }
        return result;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int index = -1;
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            index = i;
            break;
        }
        return index;
    }

    public boolean isCellEditable(int column) {
        return false;
    }

    private Object getChildAtDetailAst(DetailAST parent, int index) {
        Object result;
        if (this.parseMode == MainFrameModel.ParseMode.JAVA_WITH_JAVADOC_AND_COMMENTS && parent.getType() == 183 && JavadocUtil.isJavadocComment(parent.getParent())) {
            result = this.getJavadocTree(parent.getParent());
        } else {
            DetailAST child = parent.getFirstChild();
            for (int currentIndex = 0; currentIndex < index; ++currentIndex) {
                child = child.getNextSibling();
            }
            result = child;
        }
        return result;
    }

    private static Object getValueAtDetailNode(DetailNode node, int column) {
        return switch (column) {
            case 0 -> null;
            case 1 -> JavadocUtil.getTokenName(node.getType());
            case 2 -> node.getLineNumber();
            case 3 -> node.getColumnNumber();
            case 4 -> node.getText();
            default -> throw new IllegalStateException(UNKNOWN_COLUMN_MSG);
        };
    }

    private static Object getValueAtDetailAST(DetailAST ast, int column) {
        return switch (column) {
            case 0 -> null;
            case 1 -> TokenUtil.getTokenName(ast.getType());
            case 2 -> ast.getLineNo();
            case 3 -> ast.getColumnNo();
            case 4 -> ast.getText();
            default -> throw new IllegalStateException(UNKNOWN_COLUMN_MSG);
        };
    }

    private DetailNode getJavadocTree(DetailAST blockComment) {
        return this.blockCommentToJavadocTree.computeIfAbsent(blockComment, ParseTreeTablePresentation::parseJavadocTree);
    }

    private static DetailNode parseJavadocTree(DetailAST blockComment) {
        return new JavadocDetailNodeParser().parseJavadocAsDetailNode(blockComment).getTree();
    }
}

