/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.Violation;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@FileStatefulCheck
public final class TreeWalker
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    public static final String PARSE_EXCEPTION_MSG = "parse.exception";
    private final Map<Integer, Set<AbstractCheck>> tokenToOrdinaryChecks = new HashMap<Integer, Set<AbstractCheck>>();
    private final Map<Integer, Set<AbstractCheck>> tokenToCommentChecks = new HashMap<Integer, Set<AbstractCheck>>();
    private final Set<AbstractCheck> ordinaryChecks = TreeWalker.createNewCheckSortedSet();
    private final Set<AbstractCheck> commentChecks = TreeWalker.createNewCheckSortedSet();
    private final Set<TreeWalkerFilter> filters = new HashSet<TreeWalkerFilter>();
    private final SortedSet<Violation> violations = new TreeSet<Violation>();
    private Context childContext;
    private ModuleFactory moduleFactory;
    private boolean skipFileOnJavaParseException;
    private SeverityLevel javaParseExceptionSeverity = SeverityLevel.ERROR;

    public TreeWalker() {
        this.setFileExtensions("java");
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    public void setSkipFileOnJavaParseException(boolean skipFileOnJavaParseException) {
        this.skipFileOnJavaParseException = skipFileOnJavaParseException;
    }

    public void setJavaParseExceptionSeverity(SeverityLevel javaParseExceptionSeverity) {
        this.javaParseExceptionSeverity = javaParseExceptionSeverity;
    }

    @Override
    public void finishLocalSetup() {
        DefaultContext checkContext = new DefaultContext();
        checkContext.add("severity", this.getSeverity());
        checkContext.add("tabWidth", String.valueOf(this.getTabWidth()));
        this.childContext = checkContext;
    }

    @Override
    public void setupChild(Configuration childConf) throws CheckstyleException {
        Object module;
        String name = childConf.getName();
        try {
            module = this.moduleFactory.createModule(name);
            if (module instanceof AbstractAutomaticBean) {
                AbstractAutomaticBean bean = (AbstractAutomaticBean)module;
                bean.contextualize(this.childContext);
                bean.configure(childConf);
            }
        }
        catch (CheckstyleException exc) {
            throw new CheckstyleException("cannot initialize module " + name + " - " + exc.getMessage(), exc);
        }
        if (module instanceof AbstractCheck) {
            AbstractCheck check = (AbstractCheck)module;
            check.init();
            this.registerCheck(check);
        } else if (module instanceof TreeWalkerFilter) {
            TreeWalkerFilter filter = (TreeWalkerFilter)module;
            this.filters.add(filter);
        } else {
            throw new CheckstyleException("TreeWalker is not allowed as a parent of " + name + " Please review 'Parent Module' section for this Check in web documentation if Check is standard.");
        }
    }

    @Override
    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (!this.ordinaryChecks.isEmpty() || !this.commentChecks.isEmpty()) {
            FileContents contents = this.getFileContents();
            DetailAST rootAST = null;
            boolean skip = false;
            try {
                rootAST = JavaParser.parse(contents);
            }
            catch (Exception exc) {
                if (!this.skipFileOnJavaParseException) {
                    throw exc;
                }
                skip = true;
                this.violations.add(new Violation(1, "com.puppycrawl.tools.checkstyle.messages", PARSE_EXCEPTION_MSG, new Object[]{exc.getMessage()}, this.javaParseExceptionSeverity, null, this.getClass(), null));
                this.addViolations(this.violations);
            }
            if (!skip) {
                if (!this.ordinaryChecks.isEmpty()) {
                    this.walk(rootAST, contents, AstState.ORDINARY);
                }
                if (!this.commentChecks.isEmpty()) {
                    DetailAST astWithComments = JavaParser.appendHiddenCommentNodes(rootAST);
                    this.walk(astWithComments, contents, AstState.WITH_COMMENTS);
                }
                if (this.filters.isEmpty()) {
                    this.addViolations(this.violations);
                } else {
                    SortedSet<Violation> filteredViolations = this.getFilteredViolations(file.getAbsolutePath(), contents, rootAST);
                    this.addViolations(filteredViolations);
                }
            }
            this.violations.clear();
        }
    }

    private SortedSet<Violation> getFilteredViolations(String fileName, FileContents fileContents, DetailAST rootAST) {
        TreeSet<Violation> result = new TreeSet<Violation>(this.violations);
        block0: for (Violation element : this.violations) {
            TreeWalkerAuditEvent event = new TreeWalkerAuditEvent(fileContents, fileName, element, rootAST);
            for (TreeWalkerFilter filter : this.filters) {
                if (filter.accept(event)) continue;
                result.remove(element);
                continue block0;
            }
        }
        return result;
    }

    private void registerCheck(AbstractCheck check) throws CheckstyleException {
        int[] tokens;
        Set<String> checkTokens = check.getTokenNames();
        if (checkTokens.isEmpty()) {
            tokens = check.getDefaultTokens();
        } else {
            tokens = check.getRequiredTokens();
            int[] acceptableTokens = check.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            for (String token : checkTokens) {
                int tokenId = TokenUtil.getTokenId(token);
                if (Arrays.binarySearch(acceptableTokens, tokenId) >= 0) {
                    this.registerCheck(tokenId, check);
                    continue;
                }
                String message = String.format(Locale.ROOT, "Token \"%s\" was not found in Acceptable tokens list in check %s", token, check.getClass().getName());
                throw new CheckstyleException(message);
            }
        }
        for (int element : tokens) {
            this.registerCheck(element, check);
        }
        if (check.isCommentNodesRequired()) {
            this.commentChecks.add(check);
        } else {
            this.ordinaryChecks.add(check);
        }
    }

    private void registerCheck(int tokenId, AbstractCheck check) throws CheckstyleException {
        if (check.isCommentNodesRequired()) {
            this.tokenToCommentChecks.computeIfAbsent(tokenId, empty -> TreeWalker.createNewCheckSortedSet()).add(check);
        } else {
            if (TokenUtil.isCommentType(tokenId)) {
                String message = String.format(Locale.ROOT, "Check '%s' waits for comment type token ('%s') and should override 'isCommentNodesRequired()' method to return 'true'", check.getClass().getName(), TokenUtil.getTokenName(tokenId));
                throw new CheckstyleException(message);
            }
            this.tokenToOrdinaryChecks.computeIfAbsent(tokenId, empty -> TreeWalker.createNewCheckSortedSet()).add(check);
        }
    }

    private void walk(DetailAST ast, FileContents contents, AstState astState) {
        this.notifyBegin(ast, contents, astState);
        this.processIter(ast, astState);
        this.notifyEnd(ast, astState);
    }

    private void notifyBegin(DetailAST rootAST, FileContents contents, AstState astState) {
        Set<AbstractCheck> checks = astState == AstState.WITH_COMMENTS ? this.commentChecks : this.ordinaryChecks;
        for (AbstractCheck check : checks) {
            check.setFileContents(contents);
            check.clearViolations();
            check.beginTree(rootAST);
        }
    }

    private void notifyEnd(DetailAST rootAST, AstState astState) {
        Set<AbstractCheck> checks = astState == AstState.WITH_COMMENTS ? this.commentChecks : this.ordinaryChecks;
        for (AbstractCheck check : checks) {
            check.finishTree(rootAST);
            this.violations.addAll(check.getViolations());
        }
    }

    private void notifyVisit(DetailAST ast, AstState astState) {
        Collection<AbstractCheck> visitors = this.getListOfChecks(ast, astState);
        if (visitors != null) {
            for (AbstractCheck check : visitors) {
                check.visitToken(ast);
            }
        }
    }

    private void notifyLeave(DetailAST ast, AstState astState) {
        Collection<AbstractCheck> visitors = this.getListOfChecks(ast, astState);
        if (visitors != null) {
            for (AbstractCheck check : visitors) {
                check.leaveToken(ast);
            }
        }
    }

    private Collection<AbstractCheck> getListOfChecks(DetailAST ast, AstState astState) {
        int tokenId = ast.getType();
        Collection visitors = astState == AstState.WITH_COMMENTS ? (Collection)this.tokenToCommentChecks.get(tokenId) : (Collection)this.tokenToOrdinaryChecks.get(tokenId);
        return visitors;
    }

    @Override
    public void destroy() {
        this.ordinaryChecks.forEach(AbstractCheck::destroy);
        this.commentChecks.forEach(AbstractCheck::destroy);
        super.destroy();
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        return Stream.concat(this.filters.stream(), Stream.concat(this.ordinaryChecks.stream(), this.commentChecks.stream())).filter(ExternalResourceHolder.class::isInstance).flatMap(resource -> ((ExternalResourceHolder)resource).getExternalResourceLocations().stream()).collect(Collectors.toUnmodifiableSet());
    }

    private void processIter(DetailAST root, AstState astState) {
        DetailAST curNode = root;
        while (curNode != null) {
            this.notifyVisit(curNode, astState);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.notifyLeave(curNode, astState);
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    private static SortedSet<AbstractCheck> createNewCheckSortedSet() {
        return new TreeSet<AbstractCheck>(Comparator.comparing(check -> check.getClass().getName()).thenComparing(AbstractViolationReporter::getId, Comparator.nullsLast(Comparator.naturalOrder())).thenComparingInt(Object::hashCode));
    }

    private static enum AstState {
        ORDINARY,
        WITH_COMMENTS;

    }
}

