/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public final class FullIdent {
    private final List<String> elements = new ArrayList<String>();
    private DetailAST detailAst;

    private FullIdent() {
    }

    public static FullIdent createFullIdentBelow(DetailAST ast) {
        return FullIdent.createFullIdent(ast.getFirstChild());
    }

    public static FullIdent createFullIdent(DetailAST ast) {
        FullIdent ident = new FullIdent();
        FullIdent.extractFullIdent(ident, ast);
        return ident;
    }

    private static void extractFullIdent(FullIdent full, DetailAST ast) {
        ArrayDeque<DetailAST> identStack = new ArrayDeque<DetailAST>();
        FullIdent.pushToIdentStack(identStack, ast);
        boolean bracketsExist = false;
        int dotCounter = 0;
        while (!identStack.isEmpty()) {
            DetailAST currentAst = (DetailAST)identStack.pop();
            DetailAST nextSibling = currentAst.getNextSibling();
            boolean isArrayTypeDeclarationStart = nextSibling != null && (nextSibling.getType() == 17 || nextSibling.getType() == 158) && FullIdent.isArrayTypeDeclaration(nextSibling);
            int typeOfAst = currentAst.getType();
            bracketsExist = bracketsExist || isArrayTypeDeclarationStart;
            DetailAST firstChild = currentAst.getFirstChild();
            if (typeOfAst == 136 && currentAst.hasChildren()) {
                FullIdent.pushToIdentStack(identStack, firstChild);
                continue;
            }
            if (typeOfAst == 59) {
                FullIdent.pushToIdentStack(identStack, firstChild.getNextSibling());
                FullIdent.pushToIdentStack(identStack, firstChild);
                ++dotCounter;
                continue;
            }
            dotCounter = FullIdent.appendToFull(full, currentAst, dotCounter, bracketsExist, isArrayTypeDeclarationStart);
        }
    }

    private static int appendToFull(FullIdent full, DetailAST ast, int dotCounter, boolean bracketsExist, boolean isArrayTypeDeclarationStart) {
        int result = dotCounter;
        if (isArrayTypeDeclarationStart) {
            full.append(ast);
            FullIdent.appendBrackets(full, ast);
        } else if (ast.getType() != 158) {
            full.append(ast);
            if (dotCounter > 0) {
                full.append(".");
                --result;
            }
            if (bracketsExist) {
                FullIdent.appendBrackets(full, ast.getParent());
            }
        }
        return result;
    }

    private static void pushToIdentStack(Deque<DetailAST> stack, DetailAST ast) {
        if (ast != null) {
            stack.push(ast);
        }
    }

    private static boolean isArrayTypeDeclaration(DetailAST arrayDeclarator) {
        DetailAST expression;
        for (expression = arrayDeclarator; expression != null && expression.getType() != 28; expression = expression.getFirstChild()) {
        }
        return expression == null;
    }

    private static void appendBrackets(FullIdent full, DetailAST ast) {
        int bracketCount = ast.getParent().getChildCount(17);
        for (int i = 0; i < bracketCount; ++i) {
            full.append("[]");
        }
    }

    public String getText() {
        return String.join((CharSequence)"", this.elements);
    }

    public DetailAST getDetailAst() {
        return this.detailAst;
    }

    public int getLineNo() {
        return this.detailAst.getLineNo();
    }

    public int getColumnNo() {
        return this.detailAst.getColumnNo();
    }

    public String toString() {
        return String.join((CharSequence)"", this.elements) + "[" + this.detailAst.getLineNo() + "x" + this.detailAst.getColumnNo() + "]";
    }

    private void append(String text) {
        this.elements.add(text);
    }

    private void append(DetailAST ast) {
        this.elements.add(ast.getText());
        if (this.detailAst == null) {
            this.detailAst = ast;
        }
    }
}

