/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="allCheckSummaries")
public class AllCheckSummaries
extends AbstractMacro {
    private static final Pattern LINK_PATTERN = Pattern.compile("<a[^>]*>([^<]*)</a>");
    private static final Pattern TAG_PATTERN = Pattern.compile("(?i)</?(?:p|div|span|strong|em)[^>]*>");
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern AMP_PATTERN = Pattern.compile("&(?![a-zA-Z#0-9]+;)");
    private static final String SRC = "src";
    private static final String CHECKS = "checks";
    private static final Path JAVA_CHECKS_ROOT = Path.of("src", "main", "java", "com", "puppycrawl", "tools", "checkstyle", "checks");
    private static final Path SITE_CHECKS_ROOT = Path.of("src", "site", "xdoc", "checks");
    private static final int MAX_LINE_WIDTH = 86;
    private static final String XML_EXTENSION = ".xml";
    private static final String HTML_EXTENSION = ".html";
    private static final String TD_TAG = "<td>";
    private static final String TD_CLOSE_TAG = "</td>";

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        Map<String, String> xmlHrefMap = AllCheckSummaries.buildXmlHtmlMap();
        TreeMap<String, CheckInfo> infos = new TreeMap<String, CheckInfo>();
        AllCheckSummaries.processCheckFiles(infos, xmlHrefMap);
        StringBuilder normalRows = new StringBuilder(4096);
        StringBuilder holderRows = new StringBuilder(512);
        AllCheckSummaries.buildTableRows(infos, normalRows, holderRows);
        sink.rawText(normalRows.toString());
        if (!holderRows.isEmpty()) {
            AllCheckSummaries.appendHolderSection(sink, holderRows);
        }
    }

    private static void processCheckFiles(Map<String, CheckInfo> infos, Map<String, String> xmlHrefMap) throws MacroExecutionException {
        try {
            final ArrayList checkFiles = new ArrayList();
            Files.walkFileTree(JAVA_CHECKS_ROOT, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (AllCheckSummaries.isCheckOrHolderFile(file)) {
                        checkFiles.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            checkFiles.forEach(path -> AllCheckSummaries.processCheckFile(path, infos, xmlHrefMap));
        }
        catch (IOException | IllegalStateException exception) {
            throw new MacroExecutionException("Failed to discover checks", (Throwable)exception);
        }
    }

    private static boolean isCheckOrHolderFile(Path path) {
        String name;
        Path fileName;
        boolean result = Files.isRegularFile(path, new LinkOption[0]) ? ((fileName = path.getFileName()) == null ? false : (name = fileName.toString()).endsWith("Check.java") || name.endsWith("Holder.java")) : false;
        return result;
    }

    private static void processCheckFile(Path path, Map<String, CheckInfo> infos, Map<String, String> xmlHrefMap) {
        try {
            String description;
            String moduleName = CommonUtil.getFileNameWithoutExtension(path.toString());
            boolean isHolder = moduleName.endsWith("Holder");
            String simpleName = isHolder ? moduleName : moduleName.substring(0, moduleName.length() - "Check".length());
            DetailNode javadoc = SiteUtil.getModuleJavadoc(moduleName, path);
            if (javadoc != null && (description = AllCheckSummaries.getDescriptionIfPresent(javadoc)) != null) {
                String summary = AllCheckSummaries.createSummary(description);
                String category = AllCheckSummaries.extractCategory(path);
                String href = AllCheckSummaries.resolveHref(xmlHrefMap, category, simpleName);
                AllCheckSummaries.addCheckInfo(infos, simpleName, href, summary, isHolder);
            }
        }
        catch (MacroExecutionException exceptionThrown) {
            throw new IllegalArgumentException(exceptionThrown);
        }
    }

    @Nullable
    private static String getDescriptionIfPresent(DetailNode javadoc) {
        String result = null;
        String desc = AllCheckSummaries.getModuleDescriptionSafe(javadoc);
        if (desc != null && !desc.isEmpty()) {
            result = desc;
        }
        return result;
    }

    private static String createSummary(String description) {
        return AllCheckSummaries.sanitizeAndFirstSentence(description);
    }

    private static String extractCategory(Path path) {
        return AllCheckSummaries.extractCategoryFromJavaPath(path);
    }

    private static void addCheckInfo(Map<String, CheckInfo> infos, String simpleName, String href, String summary, boolean isHolder) {
        infos.put(simpleName, new CheckInfo(simpleName, href, summary, isHolder));
    }

    @Nullable
    private static String getModuleDescriptionSafe(DetailNode javadoc) {
        String result = null;
        if (javadoc != null) {
            try {
                if (ModuleJavadocParsingUtil.getModuleSinceVersionTagStartNode(javadoc) != null) {
                    result = ModuleJavadocParsingUtil.getModuleDescription(javadoc);
                }
            }
            catch (IllegalStateException exception) {
                result = null;
            }
        }
        return result;
    }

    private static void buildTableRows(Map<String, CheckInfo> infos, StringBuilder normalRows, StringBuilder holderRows) {
        AllCheckSummaries.appendRows(infos, normalRows, holderRows);
        AllCheckSummaries.finalizeRows(normalRows, holderRows);
    }

    private static void appendRows(Map<String, CheckInfo> infos, StringBuilder normalRows, StringBuilder holderRows) {
        for (CheckInfo info : infos.values()) {
            String row = AllCheckSummaries.buildTableRow(info);
            if (info.isHolder) {
                holderRows.append(row);
                continue;
            }
            normalRows.append(row);
        }
    }

    private static void finalizeRows(StringBuilder normalRows, StringBuilder holderRows) {
        AllCheckSummaries.removeLeadingNewline(normalRows);
        AllCheckSummaries.removeLeadingNewline(holderRows);
    }

    private static String buildTableRow(CheckInfo info) {
        String ind10 = ModuleJavadocParsingUtil.INDENT_LEVEL_10;
        String ind12 = ModuleJavadocParsingUtil.INDENT_LEVEL_12;
        String ind14 = ModuleJavadocParsingUtil.INDENT_LEVEL_14;
        String ind16 = ModuleJavadocParsingUtil.INDENT_LEVEL_16;
        return ind10 + "<tr>" + ind12 + TD_TAG + ind14 + "<a href=\"" + info.link + "\">" + ind16 + info.simpleName + ind14 + "</a>" + ind12 + TD_CLOSE_TAG + ind12 + TD_TAG + ind14 + AllCheckSummaries.wrapSummary(info.summary) + ind12 + TD_CLOSE_TAG + ind10 + "</tr>";
    }

    private static void removeLeadingNewline(StringBuilder builder) {
        while (!builder.isEmpty() && Character.isWhitespace(builder.charAt(0))) {
            builder.delete(0, 1);
        }
    }

    private static void appendHolderSection(Sink sink, StringBuilder holderRows) {
        String holderSection = AllCheckSummaries.buildHolderSectionHtml(holderRows);
        sink.rawText(holderSection);
    }

    private static String buildHolderSectionHtml(StringBuilder holderRows) {
        return ModuleJavadocParsingUtil.INDENT_LEVEL_8 + "</table>" + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + "</div>" + ModuleJavadocParsingUtil.INDENT_LEVEL_4 + "</section>" + ModuleJavadocParsingUtil.INDENT_LEVEL_4 + "<section name=\"Holder Checks\">" + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + "<p>" + ModuleJavadocParsingUtil.INDENT_LEVEL_8 + "These checks aren't normal checks and are usually" + ModuleJavadocParsingUtil.INDENT_LEVEL_8 + "associated with a specialized filter to gather" + ModuleJavadocParsingUtil.INDENT_LEVEL_8 + "information the filter can't get on its own." + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + "</p>" + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + "<div class=\"wrapper\">" + ModuleJavadocParsingUtil.INDENT_LEVEL_8 + "<table>" + ModuleJavadocParsingUtil.INDENT_LEVEL_10 + String.valueOf(holderRows);
    }

    private static Map<String, String> buildXmlHtmlMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (Files.exists(SITE_CHECKS_ROOT, new LinkOption[0])) {
            try {
                final ArrayList xmlFiles = new ArrayList();
                Files.walkFileTree(SITE_CHECKS_ROOT, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (AllCheckSummaries.isValidXmlFile(file)) {
                            xmlFiles.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                xmlFiles.forEach(path -> AllCheckSummaries.addXmlHtmlMapping(path, map));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return map;
    }

    private static boolean isValidXmlFile(Path path) {
        Path fileName;
        boolean result = Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(XML_EXTENSION) ? (fileName = path.getFileName()) != null && !"index.xml".equalsIgnoreCase(fileName.toString()) : false;
        return result;
    }

    private static void addXmlHtmlMapping(Path path, Map<String, String> map) {
        Path fileName = path.getFileName();
        if (fileName != null) {
            String fileNameString = fileName.toString();
            int extensionLength = 4;
            String base = fileNameString.substring(0, fileNameString.length() - 4).toLowerCase(Locale.ROOT);
            Path relativePath = SITE_CHECKS_ROOT.relativize(path);
            String relativePathString = relativePath.toString();
            String rel = relativePathString.replace('\\', '/').replace(XML_EXTENSION, HTML_EXTENSION);
            map.put(base, "checks/" + rel);
        }
    }

    private static String resolveHref(Map<String, String> xmlMap, String category, String simpleName) {
        String lower = simpleName.toLowerCase(Locale.ROOT);
        String href = xmlMap.get(lower);
        Object result = href != null ? href + "#" + simpleName : String.format(Locale.ROOT, "%s/%s/%s.html#%s", CHECKS, category, lower, simpleName);
        return result;
    }

    private static String extractCategoryFromJavaPath(Path javaPath) {
        Path rel = JAVA_CHECKS_ROOT.relativize(javaPath);
        Path parent = rel.getParent();
        String result = parent == null ? "" : parent.toString().replace('\\', '/');
        return result;
    }

    private static String sanitizeAndFirstSentence(String html) {
        String result;
        if (html == null || html.isEmpty()) {
            result = "";
        } else {
            String cleaned = LINK_PATTERN.matcher(html).replaceAll("$1");
            cleaned = TAG_PATTERN.matcher(cleaned).replaceAll("");
            cleaned = SPACE_PATTERN.matcher(cleaned).replaceAll(" ").trim();
            cleaned = AMP_PATTERN.matcher(cleaned).replaceAll("&amp;");
            result = AllCheckSummaries.extractFirstSentence(cleaned);
        }
        return result;
    }

    private static String extractFirstSentence(String text) {
        String result = "";
        if (text != null && !text.isEmpty()) {
            int end = -1;
            for (int index = 0; index < text.length(); ++index) {
                if (text.charAt(index) != '.' || index != text.length() - 1 && !Character.isWhitespace(text.charAt(index + 1)) && text.charAt(index + 1) != '<') continue;
                end = index;
                break;
            }
            result = end == -1 ? text.trim() : text.substring(0, end + 1).trim();
        }
        return result;
    }

    private static String wrapSummary(String text) {
        String result = text == null || text.isEmpty() ? "" : (text.length() <= 86 ? text : AllCheckSummaries.performWrapping(text));
        return result;
    }

    private static String performWrapping(String text) {
        int textLength = text.length();
        StringBuilder result = new StringBuilder(textLength + 100);
        int pos = 0;
        String indent = ModuleJavadocParsingUtil.INDENT_LEVEL_14;
        boolean firstLine = true;
        while (pos < textLength) {
            int end = Math.min(pos + 86, textLength);
            if (end >= textLength) {
                if (!firstLine) {
                    result.append(indent);
                }
                result.append(text.substring(pos));
                break;
            }
            int breakPos = text.lastIndexOf(32, end);
            if (breakPos <= pos) {
                breakPos = end;
            }
            if (!firstLine) {
                result.append(indent);
            }
            result.append(text, pos, breakPos);
            pos = breakPos + 1;
            firstLine = false;
        }
        return result.toString();
    }

    private static final class CheckInfo {
        private final String simpleName;
        private final String link;
        private final String summary;
        private final boolean isHolder;

        private CheckInfo(String simpleName, String link, String summary, boolean isHolder) {
            this.simpleName = simpleName;
            this.link = link;
            this.summary = summary;
            this.isHolder = isHolder;
        }
    }
}

