/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.meta.JavadocMetadataScraperUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.sink.Sink;

public final class ModuleJavadocParsingUtil {
    public static final String NEWLINE = System.lineSeparator();
    public static final String INDENT_LEVEL_4 = SiteUtil.getNewlineAndIndentSpaces(4);
    public static final String INDENT_LEVEL_6 = SiteUtil.getNewlineAndIndentSpaces(6);
    public static final String INDENT_LEVEL_8 = SiteUtil.getNewlineAndIndentSpaces(8);
    public static final String INDENT_LEVEL_10 = SiteUtil.getNewlineAndIndentSpaces(10);
    public static final String INDENT_LEVEL_12 = SiteUtil.getNewlineAndIndentSpaces(12);
    public static final String INDENT_LEVEL_14 = SiteUtil.getNewlineAndIndentSpaces(14);
    public static final String INDENT_LEVEL_16 = SiteUtil.getNewlineAndIndentSpaces(16);
    public static final String INDENT_LEVEL_18 = SiteUtil.getNewlineAndIndentSpaces(18);
    public static final String INDENT_LEVEL_20 = SiteUtil.getNewlineAndIndentSpaces(20);
    public static final Set<String> HTML_TEXT_FORMAT_TAGS = Set.of("<code>", "<a", "</a>", "<b>", "</b>", "<strong>", "</strong>", "<i>", "</i>", "<em>", "</em>", "<small>", "</small>", "<ins>", "<sub>", "<sup>");
    public static final String NOTES = "Notes:";
    public static final Pattern NOTES_LINE = Pattern.compile("\\s*Notes:$");
    public static final Pattern NOTES_LINE_WITH_NEWLINE = Pattern.compile("\r?\n\\s?Notes:");

    private ModuleJavadocParsingUtil() {
    }

    public static Set<String> getPropertyNames(String moduleName) throws MacroExecutionException {
        Object instance = SiteUtil.getModuleInstance(moduleName);
        Class<?> clss = instance.getClass();
        return SiteUtil.getPropertiesForDocumentation(clss, instance);
    }

    private static boolean isStartOfNotesSection(DetailNode htmlElement) {
        DetailNode htmlContentNode = JavadocUtil.findFirstToken(htmlElement, 70);
        return htmlContentNode != null && JavadocMetadataScraperUtil.isChildNodeTextMatches(htmlContentNode, NOTES_LINE);
    }

    public static void writeOutJavadocPortion(String javadocPortion, Sink sink) {
        String[] javadocPortionLinesSplit = javadocPortion.split(NEWLINE.replace("\r", ""));
        sink.rawText(javadocPortionLinesSplit[0]);
        String lastHtmlTag = javadocPortionLinesSplit[0];
        for (int index = 1; index < javadocPortionLinesSplit.length; ++index) {
            Object processedLine;
            String currentLine = javadocPortionLinesSplit[index].trim();
            if (currentLine.isEmpty()) {
                processedLine = NEWLINE;
            } else if (currentLine.startsWith("<") && !ModuleJavadocParsingUtil.startsWithTextFormattingHtmlTag(currentLine)) {
                processedLine = INDENT_LEVEL_8 + currentLine;
                lastHtmlTag = currentLine;
            } else if (lastHtmlTag.contains("<pre")) {
                String currentLineWithPreservedIndent = javadocPortionLinesSplit[index].substring(1);
                processedLine = NEWLINE + currentLineWithPreservedIndent;
            } else {
                processedLine = INDENT_LEVEL_10 + currentLine;
            }
            sink.rawText((String)processedLine);
        }
    }

    public static boolean startsWithTextFormattingHtmlTag(String line) {
        boolean result = false;
        for (String tag : HTML_TEXT_FORMAT_TAGS) {
            if (!line.startsWith(tag)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getModuleDescription(DetailNode moduleJavadoc) {
        DetailNode descriptionEndNode = ModuleJavadocParsingUtil.getDescriptionEndNode(moduleJavadoc);
        return JavadocMetadataScraperUtil.constructSubTreeText(moduleJavadoc, descriptionEndNode);
    }

    public static DetailNode getDescriptionEndNode(DetailNode moduleJavadoc) {
        DetailNode notesStartingNode = ModuleJavadocParsingUtil.getNotesSectionStartNode(moduleJavadoc);
        DetailNode descriptionEndNode = notesStartingNode != null ? notesStartingNode.getPreviousSibling() : ModuleJavadocParsingUtil.getModuleSinceVersionTagStartNode(moduleJavadoc).getPreviousSibling();
        return descriptionEndNode;
    }

    public static DetailNode getNotesSectionStartNode(DetailNode moduleJavadoc) {
        DetailNode notesStartNode = null;
        for (DetailNode node = moduleJavadoc.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != 68) continue;
            boolean found = false;
            if (JavadocUtil.isTag(node, "ul")) {
                DetailNode htmlContentNode = JavadocUtil.findFirstToken(node, 70);
                if (ModuleJavadocParsingUtil.isStartOfNotesSection(htmlContentNode.getFirstChild())) {
                    notesStartNode = node;
                    found = true;
                }
            } else if ((JavadocUtil.isTag(node, "p") || JavadocUtil.isTag(node, "li")) && ModuleJavadocParsingUtil.isStartOfNotesSection(node)) {
                notesStartNode = node;
                found = true;
            }
            if (found) break;
        }
        return notesStartNode;
    }

    public static DetailNode getModuleSinceVersionTagStartNode(DetailNode moduleJavadoc) {
        return JavadocUtil.getAllNodesOfType(moduleJavadoc, 75).stream().filter(javadocTag -> javadocTag.getFirstChild().getType() == 94).findFirst().orElse(null);
    }

    public static String getModuleNotes(DetailNode moduleJavadoc) {
        String result;
        DetailNode notesStartNode = ModuleJavadocParsingUtil.getNotesSectionStartNode(moduleJavadoc);
        if (notesStartNode == null) {
            result = "";
        } else {
            DetailNode notesEndNode = ModuleJavadocParsingUtil.getNotesEndNode(moduleJavadoc);
            String unprocessedNotes = JavadocMetadataScraperUtil.constructSubTreeText(notesStartNode, notesEndNode);
            result = NOTES_LINE_WITH_NEWLINE.matcher(unprocessedNotes).replaceAll("");
        }
        return result;
    }

    public static DetailNode getNotesEndNode(DetailNode moduleJavadoc) {
        return ModuleJavadocParsingUtil.getModuleSinceVersionTagStartNode(moduleJavadoc).getPreviousSibling();
    }

    public static boolean isPropertySpecialTokenProp(Field propertyField) {
        boolean result = false;
        if (propertyField != null) {
            XdocsPropertyType fieldXdocAnnotation = propertyField.getAnnotation(XdocsPropertyType.class);
            result = fieldXdocAnnotation != null && fieldXdocAnnotation.value() == PropertyType.TOKEN_ARRAY;
        }
        return result;
    }
}

