/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeclarationCollector
extends Check {
    private Map<DetailAST, LexicalFrame> mFrames;
    private LexicalFrame mCurrent;

    @Override
    public void beginTree(DetailAST aRootAST) {
        LinkedList aFrameStack = Lists.newLinkedList();
        aFrameStack.add(new GlobalFrame());
        this.mFrames = Maps.newHashMap();
        DetailAST curNode = aRootAST;
        while (curNode != null) {
            this.collectDeclarations(aFrameStack, curNode);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.endCollectingDeclarations(aFrameStack, curNode);
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    @Override
    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.mCurrent = this.mFrames.get((Object)aAST);
                break;
            }
        }
    }

    private void collectDeclarations(Deque<LexicalFrame> aFrameStack, DetailAST aAST) {
        LexicalFrame frame = aFrameStack.peek();
        switch (aAST.getType()) {
            case 10: {
                String name = aAST.findFirstToken(58).getText();
                if (frame instanceof ClassFrame) {
                    DetailAST mods = aAST.findFirstToken(5);
                    if (mods.branchContains(64)) {
                        ((ClassFrame)frame).addStaticMember(name);
                        break;
                    }
                    ((ClassFrame)frame).addInstanceMember(name);
                    break;
                }
                frame.addName(name);
                break;
            }
            case 21: {
                DetailAST nameAST = aAST.findFirstToken(58);
                frame.addName(nameAST.getText());
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                DetailAST nameAST = aAST.findFirstToken(58);
                frame.addName(nameAST.getText());
                aFrameStack.addFirst(new ClassFrame(frame));
                break;
            }
            case 7: {
                aFrameStack.addFirst(new BlockFrame(frame));
                break;
            }
            case 9: {
                String name = aAST.findFirstToken(58).getText();
                if (frame instanceof ClassFrame) {
                    DetailAST mods = aAST.findFirstToken(5);
                    if (mods.branchContains(64)) {
                        ((ClassFrame)frame).addStaticMember(name);
                    } else {
                        ((ClassFrame)frame).addInstanceMember(name);
                    }
                }
            }
            case 8: {
                aFrameStack.addFirst(new MethodFrame(frame));
                break;
            }
        }
    }

    private void endCollectingDeclarations(Queue<LexicalFrame> aFrameStack, DetailAST aAST) {
        switch (aAST.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.mFrames.put(aAST, aFrameStack.poll());
                break;
            }
        }
    }

    protected final boolean isClassField(String aName) {
        LexicalFrame frame = this.findFrame(aName);
        return frame instanceof ClassFrame && ((ClassFrame)frame).hasInstanceMember(aName);
    }

    private LexicalFrame findFrame(String aName) {
        if (this.mCurrent != null) {
            return this.mCurrent.getIfContains(aName);
        }
        return null;
    }

    private static class BlockFrame
    extends LexicalFrame {
        protected BlockFrame(LexicalFrame aParent) {
            super(aParent);
        }
    }

    private static class ClassFrame
    extends LexicalFrame {
        private final Set<String> mInstanceMembers = Sets.newHashSet();
        private final Set<String> mStaticMembers = Sets.newHashSet();

        public ClassFrame(LexicalFrame aParent) {
            super(aParent);
        }

        public void addStaticMember(String aName) {
            this.mStaticMembers.add(aName);
        }

        public void addInstanceMember(String aName) {
            this.mInstanceMembers.add(aName);
        }

        public boolean hasInstanceMember(String aName) {
            return this.mInstanceMembers.contains(aName);
        }

        boolean contains(String aNameToFind) {
            return super.contains(aNameToFind) || this.mInstanceMembers.contains(aNameToFind) || this.mStaticMembers.contains(aNameToFind);
        }
    }

    private static class MethodFrame
    extends LexicalFrame {
        protected MethodFrame(LexicalFrame aParent) {
            super(aParent);
        }
    }

    private static class GlobalFrame
    extends LexicalFrame {
        protected GlobalFrame() {
            super(null);
        }
    }

    private static abstract class LexicalFrame {
        private final Set<String> mVarNames;
        private final LexicalFrame mParent;

        protected LexicalFrame(LexicalFrame aParent) {
            this.mParent = aParent;
            this.mVarNames = Sets.newHashSet();
        }

        void addName(String aNameToAdd) {
            this.mVarNames.add(aNameToAdd);
        }

        boolean contains(String aNameToFind) {
            return this.mVarNames.contains(aNameToFind);
        }

        LexicalFrame getIfContains(String aNameToFind) {
            if (this.contains(aNameToFind)) {
                return this;
            }
            if (this.mParent != null) {
                return this.mParent.getIfContains(aNameToFind);
            }
            return null;
        }
    }
}

