/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import antlr.collections.ASTEnumeration;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableDeclarationUsageDistanceCheck
extends Check {
    public static final String MSG_KEY = "variable.declaration.usage.distance";
    public static final String MSG_KEY_EXT = "variable.declaration.usage.distance.extend";
    private static final int DEFAULT_DISTANCE = 3;
    private int mAllowedDistance = 3;
    private Pattern mIgnoreVariablePattern = Pattern.compile("");
    private boolean mValidateBetweenScopes;
    private boolean mIgnoreFinal = true;

    public void setAllowedDistance(int aAllowedDistance) {
        this.mAllowedDistance = aAllowedDistance;
    }

    public void setIgnoreVariablePattern(String aIgnorePattern) {
        this.mIgnoreVariablePattern = Pattern.compile(aIgnorePattern);
    }

    public void setValidateBetweenScopes(boolean aValidateBetweenScopes) {
        this.mValidateBetweenScopes = aValidateBetweenScopes;
    }

    public void setIgnoreFinal(boolean aIgnoreFinal) {
        this.mIgnoreFinal = aIgnoreFinal;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST variable;
        int parentType = aAST.getParent().getType();
        DetailAST modifiers = aAST.getFirstChild();
        if (!(this.mIgnoreFinal && modifiers.branchContains(40) || parentType == 6 || this.isVariableMatchesIgnorePattern((variable = aAST.findFirstToken(59)).getText()))) {
            DetailAST semicolonAst = aAST.getNextSibling();
            Map.Entry<DetailAST, Integer> entry = null;
            entry = this.mValidateBetweenScopes ? this.calculateDistanceBetweenScopes(semicolonAst, variable) : this.calculateDistanceInSingleScope(semicolonAst, variable);
            DetailAST variableUsageAst = entry.getKey();
            int dist = entry.getValue();
            if (dist > this.mAllowedDistance && !VariableDeclarationUsageDistanceCheck.isInitializationSequence(variableUsageAst, variable.getText())) {
                if (this.mIgnoreFinal) {
                    this.log(variable.getLineNo(), MSG_KEY_EXT, variable.getText(), dist, this.mAllowedDistance);
                } else {
                    this.log(variable.getLineNo(), MSG_KEY, variable.getText(), dist, this.mAllowedDistance);
                }
            }
        }
    }

    private static String getInstanceName(DetailAST aMethodCallAst) {
        String methodCallName = FullIdent.createFullIdentBelow(aMethodCallAst).getText();
        int lastDotIndex = methodCallName.lastIndexOf(46);
        String instanceName = "";
        if (lastDotIndex != -1) {
            instanceName = methodCallName.substring(0, lastDotIndex);
        }
        return instanceName;
    }

    private static boolean isInitializationSequence(DetailAST aVariableUsageAst, String aVariableName) {
        boolean result = true;
        boolean isUsedVariableDeclarationFound = false;
        String initInstanceName = "";
        block5: for (DetailAST currentSiblingAst = aVariableUsageAst; result && !isUsedVariableDeclarationFound && currentSiblingAst != null; currentSiblingAst = currentSiblingAst.getPreviousSibling()) {
            switch (currentSiblingAst.getType()) {
                case 29: {
                    DetailAST methodCallAst = currentSiblingAst.getFirstChild();
                    if (methodCallAst != null && methodCallAst.getType() == 27) {
                        String instanceName = VariableDeclarationUsageDistanceCheck.getInstanceName(methodCallAst);
                        if (instanceName.isEmpty()) {
                            result = false;
                            continue block5;
                        }
                        if (instanceName.equals(initInstanceName)) continue block5;
                        if (!initInstanceName.isEmpty()) {
                            result = false;
                            continue block5;
                        }
                        initInstanceName = instanceName;
                        continue block5;
                    }
                    result = false;
                    continue block5;
                }
                case 10: {
                    String currentVariableName = currentSiblingAst.findFirstToken(59).getText();
                    isUsedVariableDeclarationFound = aVariableName.equals(currentVariableName);
                    continue block5;
                }
                case 46: {
                    continue block5;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    private Map.Entry<DetailAST, Integer> calculateDistanceInSingleScope(DetailAST aSemicolonAst, DetailAST aVariableIdentAst) {
        int dist = 0;
        boolean firstUsageFound = false;
        DetailAST variableUsageAst = null;
        for (DetailAST currentAst = aSemicolonAst; !firstUsageFound && currentAst != null && currentAst.getType() != 74; currentAst = currentAst.getNextSibling()) {
            if (currentAst.getFirstChild() == null) continue;
            if (VariableDeclarationUsageDistanceCheck.isChild(currentAst, aVariableIdentAst)) {
                switch (currentAst.getType()) {
                    case 10: {
                        ++dist;
                        break;
                    }
                    case 7: {
                        dist = 0;
                        break;
                    }
                    case 85: 
                    case 86: 
                    case 87: 
                    case 91: 
                    case 93: {
                        if (this.isVariableInOperatorExpr(currentAst, aVariableIdentAst)) {
                            ++dist;
                            break;
                        }
                        dist = 0;
                        break;
                    }
                    default: {
                        if (currentAst.branchContains(7)) {
                            dist = 0;
                            break;
                        }
                        ++dist;
                    }
                }
                variableUsageAst = currentAst;
                firstUsageFound = true;
                continue;
            }
            if (currentAst.getType() == 10) continue;
            ++dist;
        }
        if (!firstUsageFound) {
            dist = 0;
        }
        return new AbstractMap.SimpleEntry<Object, Integer>(variableUsageAst, dist);
    }

    private Map.Entry<DetailAST, Integer> calculateDistanceBetweenScopes(DetailAST aAST, DetailAST aVariable) {
        int dist = 0;
        DetailAST currentScopeAst = aAST;
        DetailAST variableUsageAst = null;
        while (currentScopeAst != null) {
            ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
            DetailAST currentStatementAst = currentScopeAst;
            currentScopeAst = null;
            while (currentStatementAst != null && currentStatementAst.getType() != 74) {
                if (currentStatementAst.getFirstChild() != null) {
                    if (VariableDeclarationUsageDistanceCheck.isChild(currentStatementAst, aVariable)) {
                        variableUsageExpressions.add(currentStatementAst);
                    } else if (variableUsageExpressions.size() == 0 && currentStatementAst.getType() != 10) {
                        ++dist;
                    }
                }
                currentStatementAst = currentStatementAst.getNextSibling();
            }
            if (variableUsageExpressions.size() == 1) {
                DetailAST blockWithVariableUsage = (DetailAST)((Object)variableUsageExpressions.get(0));
                DetailAST exprWithVariableUsage = null;
                switch (blockWithVariableUsage.getType()) {
                    case 10: 
                    case 29: {
                        ++dist;
                        break;
                    }
                    case 86: 
                    case 87: 
                    case 93: {
                        exprWithVariableUsage = this.getFirstNodeInsideForWhileDoWhileBlocks(blockWithVariableUsage, aVariable);
                        break;
                    }
                    case 85: {
                        exprWithVariableUsage = this.getFirstNodeInsideIfBlock(blockWithVariableUsage, aVariable);
                        break;
                    }
                    case 91: {
                        exprWithVariableUsage = this.getFirstNodeInsideSwitchBlock(blockWithVariableUsage, aVariable);
                        break;
                    }
                    case 97: {
                        exprWithVariableUsage = VariableDeclarationUsageDistanceCheck.getFirstNodeInsideTryCatchFinallyBlocks(blockWithVariableUsage, aVariable);
                        break;
                    }
                    default: {
                        exprWithVariableUsage = blockWithVariableUsage.getFirstChild();
                    }
                }
                currentScopeAst = exprWithVariableUsage;
                if (exprWithVariableUsage != null) {
                    variableUsageAst = exprWithVariableUsage;
                    continue;
                }
                variableUsageAst = blockWithVariableUsage;
                continue;
            }
            if (variableUsageExpressions.size() > 1) {
                ++dist;
                variableUsageAst = (DetailAST)((Object)variableUsageExpressions.get(0));
                continue;
            }
            variableUsageAst = null;
        }
        return new AbstractMap.SimpleEntry<Object, Integer>(variableUsageAst, dist);
    }

    private DetailAST getFirstNodeInsideForWhileDoWhileBlocks(DetailAST aBlock, DetailAST aVariable) {
        DetailAST firstNodeInsideBlock = null;
        if (!this.isVariableInOperatorExpr(aBlock, aVariable)) {
            DetailAST currentNode = null;
            if (aBlock.getType() == 87) {
                currentNode = aBlock.getFirstChild();
            } else {
                currentNode = aBlock.findFirstToken(78);
                if (currentNode != null) {
                    currentNode = currentNode.getNextSibling();
                }
            }
            if (currentNode != null) {
                int currentNodeType = currentNode.getType();
                if (currentNodeType == 7) {
                    firstNodeInsideBlock = currentNode.getFirstChild();
                } else if (currentNodeType != 10 && currentNodeType != 29) {
                    firstNodeInsideBlock = currentNode;
                }
            }
        }
        return firstNodeInsideBlock;
    }

    private DetailAST getFirstNodeInsideIfBlock(DetailAST aBlock, DetailAST aVariable) {
        DetailAST firstNodeInsideBlock = null;
        if (!this.isVariableInOperatorExpr(aBlock, aVariable)) {
            DetailAST currentNode = aBlock.getLastChild();
            ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
            while (currentNode != null && currentNode.getType() == 94) {
                DetailAST previousNode = currentNode.getPreviousSibling();
                if (VariableDeclarationUsageDistanceCheck.isChild(previousNode, aVariable)) {
                    variableUsageExpressions.add(previousNode);
                }
                if ((currentNode = currentNode.getFirstChild()).getType() == 85) {
                    currentNode = currentNode.getLastChild();
                    continue;
                }
                if (!VariableDeclarationUsageDistanceCheck.isChild(currentNode, aVariable)) continue;
                variableUsageExpressions.add(currentNode);
                currentNode = null;
            }
            if (currentNode != null && VariableDeclarationUsageDistanceCheck.isChild(currentNode, aVariable)) {
                variableUsageExpressions.add(currentNode);
            }
            if (variableUsageExpressions.size() == 1) {
                firstNodeInsideBlock = (DetailAST)((Object)variableUsageExpressions.get(0));
            }
        }
        return firstNodeInsideBlock;
    }

    private DetailAST getFirstNodeInsideSwitchBlock(DetailAST aBlock, DetailAST aVariable) {
        DetailAST firstNodeInsideBlock = null;
        if (!this.isVariableInOperatorExpr(aBlock, aVariable)) {
            ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
            for (DetailAST currentNode = aBlock.findFirstToken(34); currentNode != null && currentNode.getType() == 34; currentNode = currentNode.getNextSibling()) {
                DetailAST lastNodeInCaseGroup = currentNode.getLastChild();
                if (!VariableDeclarationUsageDistanceCheck.isChild(lastNodeInCaseGroup, aVariable)) continue;
                variableUsageExpressions.add(lastNodeInCaseGroup);
            }
            if (variableUsageExpressions.size() == 1) {
                firstNodeInsideBlock = (DetailAST)((Object)variableUsageExpressions.get(0));
            }
        }
        return firstNodeInsideBlock;
    }

    private static DetailAST getFirstNodeInsideTryCatchFinallyBlocks(DetailAST aBlock, DetailAST aVariable) {
        DetailAST finalBlock;
        DetailAST currentNode = aBlock.getFirstChild();
        ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
        if (VariableDeclarationUsageDistanceCheck.isChild(currentNode, aVariable)) {
            variableUsageExpressions.add(currentNode);
        }
        for (currentNode = currentNode.getNextSibling(); currentNode != null && currentNode.getType() == 98; currentNode = currentNode.getNextSibling()) {
            DetailAST catchBlock = currentNode.getLastChild();
            if (!VariableDeclarationUsageDistanceCheck.isChild(catchBlock, aVariable)) continue;
            variableUsageExpressions.add(catchBlock);
        }
        if (currentNode != null && VariableDeclarationUsageDistanceCheck.isChild(finalBlock = currentNode.getLastChild(), aVariable)) {
            variableUsageExpressions.add(finalBlock);
        }
        DetailAST variableUsageNode = null;
        if (variableUsageExpressions.size() == 1) {
            variableUsageNode = ((DetailAST)((Object)variableUsageExpressions.get(0))).getFirstChild();
        }
        return variableUsageNode;
    }

    private boolean isVariableInOperatorExpr(DetailAST aOperator, DetailAST aVariable) {
        boolean isVarInOperatorDeclr = false;
        DetailAST openingBracket = aOperator.findFirstToken(77);
        if (openingBracket != null) {
            DetailAST exprBetweenBrackets = openingBracket.getNextSibling();
            while (exprBetweenBrackets.getType() != 78) {
                if (VariableDeclarationUsageDistanceCheck.isChild(exprBetweenBrackets, aVariable)) {
                    isVarInOperatorDeclr = true;
                    break;
                }
                exprBetweenBrackets = exprBetweenBrackets.getNextSibling();
            }
            if (!isVarInOperatorDeclr) {
                block0 : switch (aOperator.getType()) {
                    case 85: {
                        DetailAST firstNodeInsideElseBlock;
                        DetailAST elseBlock = aOperator.getLastChild();
                        if (elseBlock.getType() != 94 || (firstNodeInsideElseBlock = elseBlock.getFirstChild()).getType() != 85) break;
                        isVarInOperatorDeclr |= this.isVariableInOperatorExpr(firstNodeInsideElseBlock, aVariable);
                        break;
                    }
                    case 91: {
                        for (DetailAST currentCaseBlock = aOperator.findFirstToken(34); currentCaseBlock != null && currentCaseBlock.getType() == 34; currentCaseBlock = currentCaseBlock.getNextSibling()) {
                            DetailAST firstNodeInsideCaseBlock = currentCaseBlock.getFirstChild();
                            if (!VariableDeclarationUsageDistanceCheck.isChild(firstNodeInsideCaseBlock, aVariable)) continue;
                            isVarInOperatorDeclr = true;
                            break block0;
                        }
                        break;
                    }
                }
            }
        }
        return isVarInOperatorDeclr;
    }

    private static boolean isChild(DetailAST aParent, DetailAST aAST) {
        boolean isChild = false;
        ASTEnumeration astList = aParent.findAllPartial((AST)aAST);
        block0: while (astList.hasMoreNodes()) {
            DetailAST ast = (DetailAST)astList.nextNode();
            for (DetailAST astParent = ast.getParent(); astParent != null; astParent = astParent.getParent()) {
                if (!astParent.equals((AST)aParent) || astParent.getLineNo() != aParent.getLineNo()) continue;
                isChild = true;
                continue block0;
            }
        }
        return isChild;
    }

    private boolean isVariableMatchesIgnorePattern(String aVariable) {
        Matcher matcher = this.mIgnoreVariablePattern.matcher(aVariable);
        return matcher.matches();
    }
}

