/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportControlLoader;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgControl;
import java.io.File;
import java.net.URI;
import org.apache.commons.beanutils.ConversionException;

public class ImportControlCheck
extends Check {
    private PkgControl mRoot;
    private String mInPkg;
    private PkgControl mCurrentLeaf;

    public int[] getDefaultTokens() {
        return new int[]{16, 31, 154};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mCurrentLeaf = null;
    }

    public void visitToken(DetailAST aAST) {
        FullIdent imp;
        AccessResult access;
        if (aAST.getType() == 16) {
            DetailAST nameAST = aAST.getLastChild().getPreviousSibling();
            FullIdent full = FullIdent.createFullIdent(nameAST);
            if (this.mRoot == null) {
                this.log(nameAST, "import.control.missing.file", new Object[0]);
            } else {
                this.mInPkg = full.getText();
                this.mCurrentLeaf = this.mRoot.locateFinest(this.mInPkg);
                if (this.mCurrentLeaf == null) {
                    this.log(nameAST, "import.control.unknown.pkg", new Object[0]);
                }
            }
        } else if (this.mCurrentLeaf != null && !AccessResult.ALLOWED.equals((Object)(access = this.mCurrentLeaf.checkAccess((imp = aAST.getType() == 31 ? FullIdent.createFullIdentBelow(aAST) : FullIdent.createFullIdent(aAST.getFirstChild().getNextSibling())).getText(), this.mInPkg)))) {
            this.log(aAST, "import.control.disallowed", imp.getText());
        }
    }

    public void setUrl(String aUrl) {
        URI uri;
        if (aUrl == null || aUrl.trim().length() == 0) {
            return;
        }
        try {
            uri = URI.create(aUrl);
        }
        catch (IllegalArgumentException ex) {
            throw new ConversionException("syntax error in url " + aUrl, (Throwable)ex);
        }
        try {
            this.mRoot = ImportControlLoader.load(uri);
        }
        catch (CheckstyleException ex) {
            throw new ConversionException("Unable to load " + aUrl, (Throwable)ex);
        }
    }

    public void setFile(String aName) {
        if (aName == null || aName.trim().length() == 0) {
            return;
        }
        try {
            this.mRoot = ImportControlLoader.load(new File(aName).toURI());
        }
        catch (CheckstyleException ex) {
            throw new ConversionException("Unable to load " + aName, (Throwable)ex);
        }
    }
}

